/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.framework;

import edu.uic.cs.nlp.chiqat.framework.AppDataStore;
import edu.uic.cs.nlp.chiqat.framework.BluePrintNode;
import edu.uic.cs.nlp.chiqat.framework.IPluginClientHost;
import edu.uic.cs.nlp.chiqat.framework.Message;
import edu.uic.cs.nlp.chiqat.framework.Router;
import edu.uic.cs.nlp.chiqat.framework.SystemBluePrint;
import edu.uic.cs.nlp.chiqat.plugin.base.BasePluginInstance;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginViewDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PluginManager {
    private String m_PluginDir = "";
    private SystemBluePrint m_BluePrint = null;
    private AppDataStore m_AppDataStore = null;
    private String m_DataDir = "";
    private Router m_Router = new Router();

    private PluginManager() {
    }

    public static PluginManager Create(String dataDir, String pluginDir, SystemBluePrint bluePrint) {
        PluginManager pluginMan = new PluginManager();
        if (!pluginMan.Init(dataDir, pluginDir, bluePrint)) {
            pluginMan = null;
        }
        return pluginMan;
    }

    private boolean Init(String dataDir, String pluginDir, SystemBluePrint bluePrint) {
        boolean bSuccess = false;
        this.m_AppDataStore = new AppDataStore();
        this.m_DataDir = dataDir;
        this.m_PluginDir = pluginDir;
        this.m_BluePrint = bluePrint;
        this.m_BluePrint.m_AppDataStore = this.m_AppDataStore;
        this.m_AppDataStore.SetValue("DataDir", this.m_DataDir);
        this.m_AppDataStore.SetValue("PluginDir", this.m_PluginDir);
        File f = new File(pluginDir);
        if (f.isDirectory()) {
            bSuccess = this.LoadPlugins();
        }
        return bSuccess;
    }

    private boolean LoadPlugins() {
        this.m_BluePrint.CreateInstances(this.m_PluginDir, this.m_Router);
        return true;
    }

    public List<PluginViewDefinition> GetAllViews() {
        ArrayList<PluginViewDefinition> views = new ArrayList<PluginViewDefinition>();
        for (BluePrintNode bpn : this.m_BluePrint.CFG_Nodes) {
            if (bpn.m_Instance == null) continue;
            List<PluginViewDefinition> pvs = bpn.m_Instance.GetViewDefinitions();
            for (PluginViewDefinition pv : pvs) {
                views.add(pv);
            }
        }
        return views;
    }

    public PluginViewDefinition GetDefaultView() {
        ArrayList views = new ArrayList();
        for (BluePrintNode bpn : this.m_BluePrint.CFG_Nodes) {
            if (bpn.m_Instance == null) continue;
            List<PluginViewDefinition> pvs = bpn.m_Instance.GetViewDefinitions();
            for (PluginViewDefinition pv : pvs) {
                if ((pv.m_iHostHint & 0x1000) == 0) continue;
                return pv;
            }
        }
        return null;
    }

    public SystemBluePrint getBluePrint() {
        return this.m_BluePrint;
    }

    public void SetClientHost(IPluginClientHost host) {
        this.m_Router.SetClientHost(host);
    }

    public void Shutdown() {
        this.m_Router.ShutdownLocal();
    }

    public List<PluginViewDefinition> FindViewDefinition(String pluginInstId, String viewTypeId) {
        ArrayList<PluginViewDefinition> views = new ArrayList<PluginViewDefinition>();
        for (BluePrintNode bpn : this.m_BluePrint.CFG_Nodes) {
            if (bpn.m_Instance == null) continue;
            List<PluginViewDefinition> pvs = bpn.m_Instance.GetViewDefinitions();
            for (PluginViewDefinition pv : pvs) {
                if (pv.m_ViewTypeId.compareTo(viewTypeId) != 0 || pv.m_OwnerInstance.m_BluePrint.CFG_PluginInstanceId.compareTo(pluginInstId) != 0) continue;
                views.add(pv);
            }
        }
        return views;
    }

    public List<BasePluginInstance> GetAllPluginInstances() {
        ArrayList<BasePluginInstance> insts = new ArrayList<BasePluginInstance>();
        for (BluePrintNode bpn : this.m_BluePrint.CFG_Nodes) {
            if (bpn.m_Instance == null) continue;
            insts.add(bpn.m_Instance);
        }
        return insts;
    }

    public boolean SendMessage(Message msg) {
        return this.m_Router.PostMessage(msg);
    }
}

