/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.framework;

import edu.uic.cs.nlp.chiqat.framework.AppDataStore;
import edu.uic.cs.nlp.chiqat.framework.BluePrintNode;
import edu.uic.cs.nlp.chiqat.framework.LocalPluginConnector;
import edu.uic.cs.nlp.chiqat.framework.Router;
import edu.uic.cs.nlp.chiqat.plugin.base.BasePluginInstance;
import edu.uic.cs.nlp.toolbox.XmlConfig;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class SystemBluePrint
extends XmlConfig {
    public List<BluePrintNode> CFG_Nodes = new ArrayList<BluePrintNode>();
    public AppDataStore m_AppDataStore = null;

    public void ClearAllInstances() {
        int i = 0;
        while (i < this.CFG_Nodes.size()) {
            BluePrintNode node = this.CFG_Nodes.get(i);
            BasePluginInstance inst = node.m_Instance;
            if (node != null && node.m_Instance != null) {
                node.m_Instance.Destroy();
                node.m_Instance = null;
            }
            ++i;
        }
    }

    public void CreateInstances(String pluginDir, Router router) {
        this.ClearAllInstances();
        int i = 0;
        while (i < this.CFG_Nodes.size()) {
            Class<?> classDef;
            BluePrintNode node = this.CFG_Nodes.get(i);
            if (node.m_Instance == null && (classDef = this.LoadClassFromJar(String.valueOf(pluginDir) + "/" + node.CFG_PluginTypeId + ".jar")) != null) {
                int j = i;
                while (j < this.CFG_Nodes.size()) {
                    BluePrintNode innerNode = this.CFG_Nodes.get(j);
                    if (innerNode.CFG_PluginTypeId.equalsIgnoreCase(node.CFG_PluginTypeId) && innerNode.m_Instance == null) {
                        try {
                            BasePluginInstance obj = (BasePluginInstance)classDef.newInstance();
                            LocalPluginConnector con = new LocalPluginConnector(obj);
                            if (obj.Init(con, innerNode.CFG_PluginArguments, innerNode, this.m_AppDataStore)) {
                                router.RegisterConnector(con);
                                innerNode.m_Instance = obj;
                            }
                        }
                        catch (Exception e) {
                            System.out.println("Exception on initialising plugin " + node.CFG_PluginTypeId);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected Class<?> LoadClassFromJar(String path) {
        Class<?> interfaceClass = null;
        try {
            File file = new File(path);
            System.out.println("Got file '" + file.getName() + "'");
            String packageName = file.getName().toLowerCase();
            int iIndex = packageName.indexOf(46);
            if (iIndex > 0) {
                packageName = packageName.substring(0, iIndex);
            }
            URL url = file.toURI().toURL();
            URLClassLoader ClassLoader2 = URLClassLoader.newInstance(new URL[]{url});
            interfaceClass = Class.forName("edu.uic.cs.nlp.chiqat.plugin." + packageName + ".PluginInstance", true, ClassLoader2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return interfaceClass;
    }
}

