/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.framework.messages;

import edu.uic.cs.nlp.chiqat.server.api.ChiQatServerCom;
import edu.uic.cs.nlp.chiqat.server.api.structs.GetUserControlInfoResponse;
import edu.uic.cs.nlp.chiqat.server.api.structs.GetUserResponse;
import edu.uic.cs.nlp.chiqat.server.api.structs.UserControlInfo;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class User {
    private String id;
    private String m_Email = "";
    private String m_FirstName = "";
    private String m_LastName = "";
    private boolean m_bAllowResearch = false;
    private boolean m_bAllowDataSharing = false;
    private int m_iPrivileges = 0;
    private String m_BinaryUserInfo = "";
    private String session;
    private TreeSet<String> solvedProblems;
    private static Pattern pLoginID = Pattern.compile(".*\\{id=(.+?)\\}");
    private UserControlInfo m_ControlInfo = null;

    public User(String userId) {
        long time = System.currentTimeMillis();
        this.id = userId;
        this.session = String.valueOf(userId) + "-" + time;
        this.solvedProblems = new TreeSet();
    }

    public static User getAuthenticatedUser(ChiQatServerCom server, String email, String password) {
        long time = System.currentTimeMillis();
        User user = null;
        GetUserResponse res = server.GetUser(email, password);
        if (res != null && res.result.compareToIgnoreCase("S_OK") == 0) {
            user = new User(String.valueOf(res.user_info.id));
            user.session = String.valueOf(email) + "-" + time;
            user.m_Email = email;
            user.m_bAllowDataSharing = res.user_info.consent_share != 0;
            user.m_bAllowResearch = res.user_info.consent_research != 0;
            user.m_FirstName = res.user_info.first_name;
            user.m_LastName = res.user_info.last_name;
            user.m_iPrivileges = res.user_info.privileges;
            user.m_BinaryUserInfo = res.user_info.bin_user_info;
            GetUserControlInfoResponse conRes = server.GetUserControlInfo(res.user_info.id);
            user.m_ControlInfo = conRes.GetInfoForUserId(res.user_info.id);
        }
        return user;
    }

    public static User getLocalUser(String serverURL, String userID, String password) {
        long time = System.currentTimeMillis();
        User user = new User(userID);
        user.session = String.valueOf(userID) + "-" + time;
        user.solvedProblems = new TreeSet();
        return user;
    }

    public String getId() {
        return this.id;
    }

    public String getEmail() {
        return this.m_Email;
    }

    public String getSession() {
        return this.session;
    }

    public void setSolvedProblem(String problemID) {
        this.solvedProblems.add(problemID);
    }

    public String GetFirstName() {
        return this.m_FirstName;
    }

    public boolean IsDataCollectionAllowed() {
        return this.m_bAllowResearch;
    }

    public UserControlInfo GetUserControlInfo() {
        return this.m_ControlInfo;
    }

    public boolean IsAdmin() {
        return (this.m_iPrivileges & 1) != 0;
    }
}

