/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.lessontoolbox;

import edu.uic.cs.nlp.chiqat.framework.messages.LogMsg;
import edu.uic.cs.nlp.chiqat.lessontoolbox.LessonController;
import edu.uic.cs.nlp.chiqat.server.api.structs.UserControlInfo;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;

public class ControlPanel
extends BorderPane
implements EventHandler<ActionEvent> {
    public LessonController m_Controller = null;
    private Button buttonDone;
    private Button buttonRestart;
    private Button buttonProblems;
    private Button m_ExampleBtn = null;
    private ContextMenu problemMenu;

    public ControlPanel(LessonController controller) {
        this.m_Controller = controller;
        this.setOpacity(1.0);
        FlowPane buttonArea = new FlowPane();
        buttonArea.setOpacity(1.0);
        this.buttonProblems = new Button("Problems");
        this.buttonProblems.setId("problems");
        this.buttonProblems.setOnAction((EventHandler)this);
        buttonArea.getChildren().add((Object)this.buttonProblems);
        this.m_ExampleBtn = new Button("Example");
        this.m_ExampleBtn.setId("example");
        this.m_ExampleBtn.setOnAction((EventHandler)this);
        UserControlInfo info = controller.m_User.GetUserControlInfo();
        if (info == null || info.IsWoeEnabled()) {
            buttonArea.getChildren().add((Object)this.m_ExampleBtn);
        }
        this.buttonRestart = new Button("Restart");
        this.buttonRestart.setId("restart");
        this.buttonRestart.setOnAction((EventHandler)this);
        buttonArea.getChildren().add((Object)this.buttonRestart);
        this.buttonDone = new Button("Submit");
        this.buttonDone.setId("done");
        this.buttonDone.setOnAction((EventHandler)this);
        buttonArea.getChildren().add((Object)this.buttonDone);
        this.setCenter((Node)buttonArea);
        this.problemMenu = new ContextMenu();
    }

    public void SetProblems(List<String> problemIds) {
        this.problemMenu.getItems().clear();
        for (String pId : problemIds) {
            MenuItem item = new MenuItem();
            item.setText("Problem " + pId);
            item.setOnAction((EventHandler)this);
            this.problemMenu.getItems().add((Object)item);
            item.setId("setProblem:" + pId);
        }
    }

    public void handle(ActionEvent e) {
        String com = "";
        if (e.getSource() instanceof Button) {
            com = ((Button)e.getSource()).getId();
        } else if (e.getSource() instanceof MenuItem) {
            MenuItem item = (MenuItem)e.getSource();
            com = item.getId();
        } else if (e.getSource() instanceof TextField) {
            TextField tf = (TextField)e.getSource();
            com = tf.getId();
        }
        if (com.equals("restart")) {
            this.m_Controller.OnRestart();
        } else if (com.equals("done")) {
            this.m_Controller.OnSubmit();
        } else if (com.equals("problems")) {
            this.ShowProblemMenu();
            this.m_Controller.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Problem List Requested", false);
        } else if (com.equals("example")) {
            this.m_Controller.OnExample();
            this.m_Controller.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Example Requested", false);
        } else if (com.startsWith("setProblem:")) {
            String newPid = com.replaceAll("setProblem:", "");
            this.m_Controller.OnSetProblem(newPid);
            this.m_Controller.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "New Problem Selected", false, newPid);
        }
    }

    public void enableDone(boolean enabled) {
        this.buttonDone.setDisable(!enabled);
    }

    public void enableRestart(boolean enabled) {
        this.buttonRestart.setDisable(!enabled);
    }

    public void EnableExamples(boolean enabled) {
        this.m_ExampleBtn.setDisable(!enabled);
    }

    public void ShowProblemMenu() {
        this.problemMenu.show((Node)this.buttonProblems, Side.BOTTOM, 0.0, 0.0);
    }
}

