/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.lessontoolbox;

import edu.uic.cs.nlp.chiqat.framework.messages.LogMsg;
import edu.uic.cs.nlp.chiqat.framework.messages.StudentResponseMsg;
import edu.uic.cs.nlp.chiqat.lessontoolbox.IInputInterface;
import edu.uic.cs.nlp.chiqat.lessontoolbox.ITutorDialogue;
import edu.uic.cs.nlp.chiqat.lessontoolbox.TutorMessage;
import edu.uic.cs.nlp.chiqat.plugin.base.BasePluginInstance;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginViewFx;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;

public class FeedbackPanel
extends AnchorPane {
    protected BorderPane m_EmbeddedPane = null;
    protected ImageView m_TutorImage = null;
    protected ImageView m_ModalMessageImage = null;
    protected TextArea m_TextBodyCtrl = null;
    protected IInputInterface m_InputInterface = null;
    private BasePluginInstance m_PluginInstance = null;
    protected BorderPane m_ResponsePane = null;
    protected FlowPane m_ResponseAnswerPane = null;
    protected Button m_ResponseAcceptBtn = null;
    protected ToggleGroup m_AnswerBtnGroup = null;
    protected ITutorDialogue m_ResponseTutor = null;
    private Image m_IconPositive = null;
    private Image m_IconNegative = null;
    private Image m_IconConfused = null;
    private Image m_IconCool = null;
    private Image m_IconFriendly = null;
    private Image m_IconGood = null;
    private Image m_IconThinking = null;
    private Image m_IconYou = null;
    private Image m_IconStopGood = null;
    private Image m_IconStopOk = null;
    private Image m_IconStopBad = null;
    protected String m_DataDir = "";
    protected PluginViewFx m_OwnerView = null;

    public FeedbackPanel(IInputInterface inputInterface, PluginViewFx view) {
        this.m_InputInterface = inputInterface;
        this.m_OwnerView = view;
        this.m_EmbeddedPane = new BorderPane();
        this.m_EmbeddedPane.setPadding(new Insets(10.0));
        this.getChildren().add((Object)this.m_EmbeddedPane);
        AnchorPane.setLeftAnchor((Node)this.m_EmbeddedPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.m_EmbeddedPane, (Double)0.0);
        AnchorPane.setTopAnchor((Node)this.m_EmbeddedPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.m_EmbeddedPane, (Double)0.0);
        VBox imagePane = new VBox();
        imagePane.setAlignment(Pos.TOP_CENTER);
        this.m_TutorImage = new ImageView();
        this.m_TutorImage.setFitWidth(65.0);
        this.m_TutorImage.setFitHeight(65.0);
        this.m_ModalMessageImage = new ImageView();
        this.m_ModalMessageImage.setFitWidth(60.0);
        this.m_ModalMessageImage.setFitHeight(40.0);
        imagePane.getChildren().add((Object)this.m_TutorImage);
        imagePane.getChildren().add((Object)this.m_ModalMessageImage);
        VBox dialogPane = new VBox();
        this.m_TextBodyCtrl = new TextArea();
        this.m_TextBodyCtrl.setWrapText(true);
        this.m_TextBodyCtrl.setEditable(false);
        dialogPane.getChildren().add((Object)this.m_TextBodyCtrl);
        this.m_ResponsePane = new BorderPane();
        this.m_ResponseAnswerPane = new FlowPane();
        this.m_ResponseAnswerPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.m_ResponseAnswerPane.setHgap(25.0);
        this.m_ResponseAcceptBtn = new Button("OK");
        this.m_ResponseAcceptBtn.setAlignment(Pos.TOP_CENTER);
        this.m_ResponseAcceptBtn.setVisible(false);
        this.m_ResponseAcceptBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                FeedbackPanel.this.OnResponseBtnClicked();
            }
        });
        this.m_ResponsePane.setCenter((Node)this.m_ResponseAnswerPane);
        this.m_ResponsePane.setBottom((Node)this.m_ResponseAcceptBtn);
        dialogPane.getChildren().add((Object)this.m_ResponsePane);
        this.m_TextBodyCtrl.setStyle("-fx-text-fill: black;-fx-background-color: #F8F8F8;-fx-font-family: \"Courier New\";-fx-font-weight: normal;-fx-font-size: 12;-fx-border-color: #000000;-fx-border-radius: 5;");
        this.m_EmbeddedPane.setLeft((Node)imagePane);
        this.m_EmbeddedPane.setCenter((Node)dialogPane);
    }

    protected void OnResponseBtnClicked() {
        if (this.m_ResponseTutor != null && this.m_AnswerBtnGroup != null) {
            RadioButton toggle;
            String responseStr = "";
            if (this.m_ResponseTutor != null && (toggle = (RadioButton)this.m_AnswerBtnGroup.getSelectedToggle()) != null) {
                responseStr = toggle.getText();
                this.m_ResponseTutor.OnUserResponse(responseStr);
            }
        } else {
            this.m_OwnerView.m_Controller.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "User Acknowledge", false);
            this.RemoveAnswers();
            this.AckWoeTutor();
            this.m_ResponseAcceptBtn.setVisible(false);
            this.m_InputInterface.EnableInput(true, 1000);
        }
    }

    protected void AckWoeTutor() {
        StudentResponseMsg msg = new StudentResponseMsg();
        msg.m_PlaybackInstanceId = this.GetPluginInstance().GetInstanceId();
        msg.m_PlaybackControllerId = this.m_OwnerView.GetController().GetControllerId();
        msg.m_StringData = "-1";
        this.GetPluginInstance().PostMessage(msg);
    }

    protected void OnAcceptButtonClicked() {
        StudentResponseMsg msg = new StudentResponseMsg();
        msg.m_StringData = "-1";
        msg.m_PlaybackInstanceId = this.GetPluginInstance().GetInstanceId();
        msg.m_PlaybackControllerId = this.m_OwnerView.GetController().GetControllerId();
        this.GetPluginInstance().PostMessage(msg);
    }

    public boolean Init() {
        this.m_IconPositive = new Image("file://" + this.m_DataDir + "/Resources/Tutor/Images/good.png");
        this.m_IconNegative = new Image("file://" + this.m_DataDir + "/Resources/Tutor/Images/thinking.png");
        this.m_IconConfused = new Image("file://" + this.m_DataDir + "/Resources/Tutor/Images/confused.png");
        this.m_IconCool = new Image("file://" + this.m_DataDir + "/Resources/Tutor/Images/cool.png");
        this.m_IconFriendly = new Image("file://" + this.m_DataDir + "/Resources/Tutor/Images/friendly.png");
        this.m_IconGood = new Image("file://" + this.m_DataDir + "/Resources/Tutor/Images/good.png");
        this.m_IconThinking = new Image("file://" + this.m_DataDir + "/Resources/Tutor/Images/thinking.png");
        this.m_IconYou = new Image("file://" + this.m_DataDir + "/Resources/Tutor/Images/you.png");
        this.m_IconStopGood = new Image("file://" + this.m_DataDir + "/Resources/Tutor/Images/StopGood.png");
        this.m_IconStopOk = new Image("file://" + this.m_DataDir + "/Resources/Tutor/Images/StopOk.png");
        this.m_IconStopBad = new Image("file://" + this.m_DataDir + "/Resources/Tutor/Images/StopBad.png");
        return true;
    }

    public void DisplayFeedback(TutorMessage msg) {
        String msgText = msg.m_Text;
        boolean bModal = msg.m_bModal;
        List<String> choices = msg.m_Answers;
        ITutorDialogue tutor = msg.m_Tutor;
        Image img = null;
        switch (msg.m_VisualAction) {
            case Positive: {
                img = this.m_IconPositive;
                break;
            }
            case Negative: {
                img = this.m_IconNegative;
                break;
            }
            case Confused: {
                img = this.m_IconConfused;
                break;
            }
            case Cool: {
                img = this.m_IconCool;
                break;
            }
            case Friendly: {
                img = this.m_IconFriendly;
                break;
            }
            case Good: {
                img = this.m_IconGood;
                break;
            }
            case Thinking: {
                img = this.m_IconThinking;
                break;
            }
            case You: {
                img = this.m_IconYou;
                break;
            }
            default: {
                img = this.m_IconPositive;
            }
        }
        this.m_TutorImage.setImage(img);
        this.m_TextBodyCtrl.setText(msgText);
        this.m_ModalMessageImage.setVisible(bModal);
        this.RemoveAnswers();
        if (choices != null && choices.size() > 0) {
            this.m_AnswerBtnGroup = new ToggleGroup();
            for (String c : choices) {
                RadioButton btn = new RadioButton();
                btn.setToggleGroup(this.m_AnswerBtnGroup);
                btn.setText(c);
                this.m_ResponseAnswerPane.getChildren().add((Object)btn);
            }
        }
        int i = 0;
        while (i < this.m_ResponseAnswerPane.getChildren().size()) {
            ((RadioButton)this.m_ResponseAnswerPane.getChildren().get(i)).setDisable(msg.m_bDisableStudentChoices);
            ++i;
        }
        boolean bBlock = choices != null && choices.size() > 0 || msg.m_bAckRequired || bModal;
        this.m_ResponseAcceptBtn.setVisible(bBlock);
        this.m_InputInterface.EnableInput(!bBlock);
        this.m_ResponseTutor = tutor;
    }

    public void SetDataDir(String dataDir) {
        this.m_DataDir = dataDir;
    }

    public BasePluginInstance GetPluginInstance() {
        return this.m_PluginInstance;
    }

    public void SetPluginInstance(BasePluginInstance pluginInstance) {
        this.m_PluginInstance = pluginInstance;
    }

    public void RemoveAnswers() {
        this.m_AnswerBtnGroup = null;
        this.m_ResponseAnswerPane.getChildren().clear();
    }
}

