/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.lessontoolbox;

import edu.uic.cs.nlp.ui.misc.IFxUiTimerHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.scene.Node;

public class InputEnabler
implements IFxUiTimerHandler {
    protected Timer m_Timer = null;
    protected TimerTask m_TimerTask = null;
    protected int m_iDelayMs = 1000;
    protected boolean m_bEnableCtrls = true;
    protected List<Node> m_InputCtrls = null;
    protected boolean m_bIsRunning = false;
    private long m_lTargetTimeMs = 0L;

    public InputEnabler() {
        this.m_InputCtrls = new ArrayList<Node>();
    }

    public InputEnabler(List<Node> inputCtrls) {
        this.m_InputCtrls = inputCtrls;
    }

    public void AddControl(Node ctrl) {
        this.m_InputCtrls.add(ctrl);
    }

    protected void StartTimer() {
        this.m_bIsRunning = true;
        if (this.m_Timer != null) {
            this.StopTimer();
        }
        this.m_Timer = new Timer();
        this.m_TimerTask = new TimerTask(){

            @Override
            public void run() {
                InputEnabler.this.StopTimer();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        InputEnabler.this.OnTimerHandler();
                    }
                });
            }
        };
        this.m_Timer.schedule(this.m_TimerTask, this.m_iDelayMs);
    }

    protected void StopTimer() {
        this.m_lTargetTimeMs = 0L;
        if (this.m_Timer != null) {
            this.m_Timer.cancel();
            this.m_bIsRunning = false;
            this.m_Timer = null;
        }
    }

    @Override
    public void OnTimerHandler() {
        this.SetInputCtrlState(this.m_bEnableCtrls);
    }

    public void Enable(boolean bEnable, int iDelayMs) {
        if (this.m_lTargetTimeMs != 0L && this.m_lTargetTimeMs < System.currentTimeMillis() + (long)iDelayMs && bEnable == this.m_bEnableCtrls) {
            return;
        }
        if (iDelayMs > 0) {
            this.StopTimer();
            this.m_iDelayMs = iDelayMs;
            this.m_lTargetTimeMs = System.currentTimeMillis() + (long)iDelayMs;
            this.m_bEnableCtrls = bEnable;
            this.StartTimer();
        } else {
            this.StopTimer();
            this.SetInputCtrlState(bEnable);
        }
    }

    private void SetInputCtrlState(boolean bEnable) {
        this.StopTimer();
        for (Node n : this.m_InputCtrls) {
            n.setDisable(!bEnable);
        }
    }

    private boolean IsEnabled() {
        for (Node n : this.m_InputCtrls) {
            if (!n.isDisable()) continue;
            return false;
        }
        return true;
    }

    private boolean IsDisabled() {
        for (Node n : this.m_InputCtrls) {
            if (n.isDisable()) continue;
            return false;
        }
        return true;
    }
}

