/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.lessontoolbox;

import edu.uic.cs.nlp.chiqat.framework.Message;
import edu.uic.cs.nlp.chiqat.framework.messages.LogMsg;
import edu.uic.cs.nlp.chiqat.lessontoolbox.ControlPanel;
import edu.uic.cs.nlp.chiqat.lessontoolbox.FeedbackPanel;
import edu.uic.cs.nlp.chiqat.lessontoolbox.IInputInterface;
import edu.uic.cs.nlp.chiqat.lessontoolbox.InputEnabler;
import edu.uic.cs.nlp.chiqat.lessontoolbox.LessonController;
import edu.uic.cs.nlp.chiqat.lessontoolbox.ScratchPanel;
import edu.uic.cs.nlp.chiqat.lessontoolbox.TutorMessage;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginMenuItemDefinition;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginViewFx;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.util.Duration;

public class LessonView
extends PluginViewFx {
    protected FeedbackPanel m_FeedbackPanel;
    protected ScratchPanel m_ScratchPanel;
    protected ControlPanel m_ControlPanel;
    protected BorderPane m_RootPane = null;
    protected String m_DataDir = "";
    protected InputEnabler m_InputEnabler = null;
    private BorderPane m_CentrePane = null;
    private IInputInterface m_InputInterfaceHandler = null;
    protected Timeline m_FeedbackTl = null;
    protected Timeline m_ScratchTl = null;
    protected Timeline m_ControlTl = null;
    protected Timeline m_PrimaryPaneTl = null;
    protected Timeline m_SecondaryPaneTl = null;

    @Override
    public boolean Init() {
        return true;
    }

    public boolean Init(LessonController controller, IInputInterface inputInterfaceHandler) {
        Message msg = new Message();
        msg.m_MessageId = "OnTutorialRequested";
        msg.m_DestPlugin = this.m_Owner.m_BluePrint.CFG_PluginInstanceId;
        this.m_MenuItemDefs.add(new PluginMenuItemDefinition("File|Tutorial", msg, this.m_ViewId));
        msg = new Message();
        msg.m_MessageId = "ExitLesson";
        msg.m_DestPlugin = this.m_Owner.m_BluePrint.CFG_PluginInstanceId;
        this.m_MenuItemDefs.add(new PluginMenuItemDefinition("File|Exit Lesson", msg, this.m_ViewId));
        this.m_Controller = controller;
        this.m_InputInterfaceHandler = inputInterfaceHandler;
        this.m_DataDir = this.m_Owner.m_AppDataStore.GetValue("DataDir");
        this.m_RootPane = new BorderPane();
        this.getChildren().add((Object)this.m_RootPane);
        this.m_RootPane.setStyle("-fx-background-color: DAE6F3;");
        LessonView.setTopAnchor((Node)this.m_RootPane, (Double)0.0);
        LessonView.setBottomAnchor((Node)this.m_RootPane, (Double)0.0);
        LessonView.setLeftAnchor((Node)this.m_RootPane, (Double)0.0);
        LessonView.setRightAnchor((Node)this.m_RootPane, (Double)0.0);
        this.setOpacity(1.0);
        this.m_ScratchPanel = new ScratchPanel((LessonController)this.m_Controller);
        this.m_ControlPanel = new ControlPanel((LessonController)this.m_Controller);
        this.m_FeedbackPanel = new FeedbackPanel(this.m_InputInterfaceHandler, this);
        this.m_FeedbackPanel.SetPluginInstance(this.m_Owner);
        this.m_FeedbackPanel.SetDataDir(this.m_DataDir);
        this.m_FeedbackPanel.setMinWidth(200.0);
        this.m_FeedbackPanel.setPrefWidth(200.0);
        this.m_FeedbackPanel.setMaxWidth(200.0);
        this.m_FeedbackPanel.Init();
        GridPane subTop = new GridPane();
        subTop.add((Node)this.m_ScratchPanel, 0, 0);
        subTop.add((Node)this.m_FeedbackPanel, 1, 0, 1, 2);
        subTop.add((Node)this.m_ControlPanel, 0, 1);
        ColumnConstraints col1 = new ColumnConstraints();
        col1.setPercentWidth(50.0);
        ColumnConstraints col2 = new ColumnConstraints();
        col2.setPercentWidth(50.0);
        subTop.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2});
        this.m_FeedbackPanel.setMaxWidth(Double.MAX_VALUE);
        this.m_FeedbackPanel.setStyle("-fx-border-style: none none none solid; -fx-border-color: #555555; -fx-border-width: 0px 0px 0px 1px;");
        this.m_CentrePane = new BorderPane();
        this.m_RootPane.setCenter((Node)this.m_CentrePane);
        subTop.setMinHeight(200.0);
        subTop.setPrefHeight(200.0);
        subTop.setMaxHeight(200.0);
        this.m_CentrePane.setTop((Node)subTop);
        this.m_InputEnabler = new InputEnabler();
        this.m_FeedbackTl = this.CreateBrightnessTimeline((Node)this.m_FeedbackPanel);
        this.m_ScratchTl = this.CreateBrightnessTimeline((Node)this.m_ScratchPanel);
        this.m_ControlTl = this.CreateBrightnessTimeline((Node)this.m_ControlPanel);
        return true;
    }

    protected void SetPrimaryPaneContent(Node content) {
        this.m_CentrePane.setCenter(content);
        this.m_PrimaryPaneTl = this.CreateBrightnessTimeline(content);
    }

    protected void SetSecondaryPaneContent(Node content) {
        this.m_RootPane.setRight(content);
        this.m_SecondaryPaneTl = this.CreateBrightnessTimeline(content);
    }

    protected void AddInputEnabledControl(Node ctrl) {
        this.m_InputEnabler.AddControl(ctrl);
    }

    public void DisplayFeedback(TutorMessage msg) {
        this.m_FeedbackPanel.DisplayFeedback(msg);
        if (msg.m_Answers.size() == 0) {
            this.m_Controller.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Feedback Given", false, msg.m_Text, String.valueOf(msg.m_VisualAction.toString()) + "|" + msg.m_iIconLevel, msg.m_FeedbackStr);
        } else if (!msg.m_bDisableStudentChoices) {
            this.m_Controller.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Question Given", false, msg.m_Text, String.valueOf(msg.m_VisualAction.toString()) + "|" + msg.m_iIconLevel, msg.m_FeedbackStr);
        } else {
            this.m_Controller.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Question Answer Response", false, msg.m_Text, String.valueOf(msg.m_VisualAction.toString()) + "|" + msg.m_iIconLevel, msg.m_FeedbackStr);
        }
    }

    @Override
    public void OnMessage(Message msg) {
        super.OnMessage(msg);
    }

    public void HighlightNode(String nodeId, boolean bSet, boolean bPulse, boolean bSize, boolean bBrightness) {
    }

    public void EnableProblemInput(boolean bEnable) {
        this.EnableProblemInput(bEnable, 0);
    }

    public void EnableProblemInput(boolean bEnable, int iDelayMs) {
        this.m_InputEnabler.Enable(bEnable, iDelayMs);
    }

    public void SetScratchText(String text, int iPageNum, int iLineNum) {
        this.m_ScratchPanel.SetText(text, iPageNum, iLineNum);
    }

    public void ClearScratch(int iPageNum) {
        this.m_ScratchPanel.ClearScratch(iPageNum);
    }

    public void enableDone(boolean enabled) {
        this.m_ControlPanel.enableDone(enabled);
    }

    public void enableRestart(boolean enabled) {
        this.m_ControlPanel.enableRestart(enabled);
    }

    public void showProblemMenu() {
        this.m_ControlPanel.ShowProblemMenu();
    }

    public void EnableExamples(boolean bEnable) {
        this.m_ControlPanel.EnableExamples(bEnable);
    }

    public void HighlightUiComponent(String componentName) {
        Timeline tl = null;
        switch (componentName) {
            case "TutorPane": {
                tl = this.m_FeedbackTl;
                break;
            }
            case "ScratchPane": {
                tl = this.m_ScratchTl;
                break;
            }
            case "ControlPane": {
                tl = this.m_ControlTl;
                break;
            }
            case "PrimaryPane": {
                tl = this.m_PrimaryPaneTl;
                break;
            }
            case "SecondaryPane": {
                tl = this.m_SecondaryPaneTl;
            }
        }
        if (tl != null) {
            tl.play();
        }
    }

    protected Timeline CreateBrightnessTimeline(Node n) {
        ColorAdjust brightnessAdjust = new ColorAdjust();
        brightnessAdjust.setBrightness(0.0);
        n.setEffect((Effect)brightnessAdjust);
        n.setCache(true);
        n.setCacheHint(CacheHint.SPEED);
        Timeline brightnessTimeline = new Timeline();
        brightnessTimeline.setCycleCount(-1);
        brightnessTimeline.setAutoReverse(true);
        KeyValue kvXA = new KeyValue((WritableValue)brightnessAdjust.brightnessProperty(), (Object)0.5, Interpolator.EASE_BOTH);
        KeyFrame kfXA = new KeyFrame(Duration.millis((double)400.0), new KeyValue[]{kvXA});
        brightnessTimeline.getKeyFrames().add((Object)kfXA);
        brightnessTimeline.setCycleCount(6);
        brightnessTimeline.setAutoReverse(true);
        return brightnessTimeline;
    }
}

