/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.lessontoolbox;

import edu.uic.cs.nlp.chiqat.framework.messages.LogMsg;
import edu.uic.cs.nlp.chiqat.lessontoolbox.LessonController;
import edu.uic.cs.nlp.chiqat.lessontoolbox.ScratchPage;
import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;

public class ScratchPanel
extends BorderPane
implements EventHandler<ActionEvent> {
    protected LessonController m_Controller = null;
    private List<ScratchPage> m_ScratchPages = new ArrayList<ScratchPage>();
    private Button m_PrevPaneBtn = null;
    private Button m_NextPaneBtn = null;
    private AnchorPane m_InnerPane = null;
    private int m_iActivePage = 0;

    public ScratchPanel(LessonController controller) {
        this.m_Controller = controller;
        this.setOpacity(1.0);
        this.m_InnerPane = new AnchorPane();
        this.m_ScratchPages.add(new ScratchPage());
        this.m_ScratchPages.add(new ScratchPage());
        this.m_PrevPaneBtn = new Button();
        this.m_PrevPaneBtn.setText("<");
        this.m_PrevPaneBtn.setOnAction((EventHandler)this);
        this.m_NextPaneBtn = new Button();
        this.m_NextPaneBtn.setText(">");
        this.m_NextPaneBtn.setOnAction((EventHandler)this);
        int i = 0;
        while (i < this.m_ScratchPages.size()) {
            this.AnchorNode((Node)this.m_ScratchPages.get(i), 0.0, 0.0, 0.0, 0.0);
            this.m_ScratchPages.get(i).setVisible(false);
            ++i;
        }
        this.AnchorNode((Node)this.m_PrevPaneBtn, 3.0, null, null, 3.0);
        this.AnchorNode((Node)this.m_NextPaneBtn, 30.0, null, null, 3.0);
        this.setCenter((Node)this.m_InnerPane);
        this.ShowActivePage();
    }

    private void AnchorNode(Node n, Double l, Double t, Double r, Double b) {
        this.m_InnerPane.getChildren().add((Object)n);
        if (t != null) {
            AnchorPane.setTopAnchor((Node)n, (Double)t);
        }
        if (l != null) {
            AnchorPane.setLeftAnchor((Node)n, (Double)l);
        }
        if (r != null) {
            AnchorPane.setRightAnchor((Node)n, (Double)r);
        }
        if (b != null) {
            AnchorPane.setBottomAnchor((Node)n, (Double)b);
        }
    }

    public void handle(ActionEvent arg0) {
        if (arg0.getSource() == this.m_PrevPaneBtn) {
            --this.m_iActivePage;
            if (this.m_iActivePage < 0) {
                this.m_iActivePage = 0;
            }
            this.m_Controller.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Scratch Pad Prev", false, "" + this.m_iActivePage);
        } else if (arg0.getSource() == this.m_NextPaneBtn) {
            ++this.m_iActivePage;
            if (this.m_iActivePage >= this.m_ScratchPages.size()) {
                this.m_iActivePage = this.m_ScratchPages.size() - 1;
            }
            this.m_Controller.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Scratch Pad Next", false, "" + this.m_iActivePage);
        }
        this.ShowActivePage();
    }

    protected void SetActivePage(int iPageNum) {
        if (iPageNum >= 0 && iPageNum < this.m_ScratchPages.size()) {
            this.m_iActivePage = iPageNum;
            this.ShowActivePage();
        }
    }

    protected void ShowActivePage() {
        if (this.m_iActivePage >= 0 && this.m_iActivePage < this.m_ScratchPages.size()) {
            this.m_ScratchPages.get(this.m_iActivePage).setVisible(true);
            int i = 0;
            while (i < this.m_ScratchPages.size()) {
                if (i != this.m_iActivePage) {
                    this.m_ScratchPages.get(i).setVisible(false);
                }
                ++i;
            }
        }
        this.m_PrevPaneBtn.setDisable(this.m_iActivePage <= 0);
        this.m_NextPaneBtn.setDisable(this.m_iActivePage >= this.m_ScratchPages.size() - 1);
    }

    public void SetText(String text, int iPageNum, int iLineNum) {
        this.m_ScratchPages.get(iPageNum).SetText(text, iLineNum);
        this.SetActivePage(iPageNum);
    }

    public void ClearScratch(int iPageNum) {
        if (iPageNum < this.m_ScratchPages.size()) {
            if (iPageNum <= -1) {
                int i = 0;
                while (i < this.m_ScratchPages.size()) {
                    this.m_ScratchPages.get(i).Clear();
                    ++i;
                }
            } else {
                this.m_ScratchPages.get(iPageNum).Clear();
            }
        }
    }
}

