/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.activitycontrollerplugin;

import edu.uic.cs.nlp.chiqat.framework.KeyValuePair;
import edu.uic.cs.nlp.chiqat.framework.messages.CreateLessonMsg;
import edu.uic.cs.nlp.chiqat.framework.messages.ShowViewMsg;
import edu.uic.cs.nlp.chiqat.framework.messages.User;
import edu.uic.cs.nlp.chiqat.plugin.activitycontrollerplugin.IPanelCallback;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginViewFx;
import edu.uic.cs.nlp.toolbox.MiscFuncs;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class ActivityPanel
extends AnchorPane
implements EventHandler<ActionEvent> {
    protected User m_User = null;
    protected boolean m_bDummyLogin = false;
    protected String m_DataDir = "";
    private static String Hint_GoToTutorial = "Click here to Learn how to use ChiQat";
    protected Label m_HintLink = null;
    protected PluginViewFx m_View = null;
    protected ComboBox<ComboBoxItem> m_OptionsCombo = null;
    protected ComboBox<ComboBoxItem> m_LessonCombo = null;
    protected IPanelCallback m_Callback = null;

    public boolean Init(PluginViewFx view, IPanelCallback callback) {
        this.m_View = view;
        StackPane stackPane = new StackPane();
        BorderPane bp = new BorderPane();
        this.getChildren().add((Object)bp);
        ActivityPanel.setRightAnchor((Node)bp, (Double)0.0);
        ActivityPanel.setTopAnchor((Node)bp, (Double)0.0);
        ActivityPanel.setBottomAnchor((Node)bp, (Double)0.0);
        ActivityPanel.setLeftAnchor((Node)bp, (Double)0.0);
        bp.setCenter((Node)stackPane);
        Label l = null;
        this.m_DataDir = this.m_View.GetOwner().m_AppDataStore.GetValue("DataDir");
        Image bgImage = new Image("file://" + this.m_DataDir + "/Resources/MainLoginBackground.jpg");
        ImageView imageView = new ImageView();
        imageView.setImage(bgImage);
        imageView.setFitWidth(640.0);
        imageView.setFitHeight(480.0);
        stackPane.getChildren().add((Object)imageView);
        GridPane gridPane = new GridPane();
        stackPane.getChildren().add((Object)gridPane);
        gridPane.setPrefSize(200.0, 200.0);
        gridPane.setAlignment(Pos.CENTER);
        l = new Label();
        l.setText("Lesson");
        this.m_LessonCombo = new ComboBox();
        for (KeyValuePair kvp : this.m_View.GetOwner().m_BluePrint.CFG_PluginArguments) {
            this.m_LessonCombo.getItems().add((Object)new ComboBoxItem(kvp.CFG_Key, kvp.CFG_Value));
        }
        this.m_LessonCombo.setMaxWidth(Double.MAX_VALUE);
        this.m_LessonCombo.getSelectionModel().select(0);
        gridPane.addRow(2, new Node[]{l, this.m_LessonCombo});
        l = new Label();
        l.setText("Options");
        this.m_OptionsCombo = new ComboBox();
        this.m_OptionsCombo.getItems().addAll((Object[])new ComboBoxItem[]{new ComboBoxItem("Java", "Language=Java"), new ComboBoxItem("C++", "Language=C++")});
        this.m_OptionsCombo.setMaxWidth(Double.MAX_VALUE);
        this.m_OptionsCombo.getSelectionModel().select(0);
        gridPane.addRow(3, new Node[]{l, this.m_OptionsCombo});
        Button okButton = new Button();
        okButton.setOnAction((EventHandler)this);
        okButton.setText("Login");
        okButton.setMaxWidth(Double.MAX_VALUE);
        gridPane.add((Node)okButton, 0, 4);
        GridPane.setColumnSpan((Node)okButton, (Integer)2);
        this.m_HintLink = new Label();
        this.m_HintLink.setText("No hint");
        this.m_HintLink.setAlignment(Pos.BOTTOM_RIGHT);
        this.m_HintLink.setTextFill(Paint.valueOf((String)"blue"));
        this.m_HintLink.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.m_HintLink.setText(Hint_GoToTutorial);
        this.m_HintLink.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && ActivityPanel.this.m_HintLink.getText().compareTo(Hint_GoToTutorial) == 0) {
                    ActivityPanel.this.GoToChiQatTutorial();
                }
            }
        });
        this.m_HintLink.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                ActivityPanel.this.m_HintLink.setTextFill((Paint)Color.LIGHTBLUE);
            }
        });
        this.m_HintLink.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                ActivityPanel.this.m_HintLink.setTextFill((Paint)Color.BLUE);
            }
        });
        return true;
    }

    private void GoToChiQatTutorial() {
        CreateLessonMsg lessonMsg = new CreateLessonMsg();
        lessonMsg.m_PluginName = "HelpPlugin";
        lessonMsg.m_MessageId = "CreateLesson";
        lessonMsg.m_StringData = ((ComboBoxItem)this.m_LessonCombo.getSelectionModel().getSelectedItem()).m_Tag;
        lessonMsg.m_LessonOptionsStr = ((ComboBoxItem)this.m_OptionsCombo.getSelectionModel().getSelectedItem()).m_Tag;
        this.m_View.GetOwner().PostMessage(lessonMsg.m_PluginName, lessonMsg);
        ShowViewMsg showViewMsg = new ShowViewMsg();
        showViewMsg.m_MessageId = "ShowView";
        showViewMsg.m_StringData = this.m_View.GetViewId();
        showViewMsg.m_PluginInstanceId = "HelpPlugin";
        showViewMsg.m_ViewTypeId = "UiOverviewView";
        this.m_View.GetOwner().PostMessage("host", showViewMsg);
    }

    public void handle(ActionEvent arg0) {
        Map<String, String> lessonInfo = MiscFuncs.ParseQueryString(((ComboBoxItem)this.m_LessonCombo.getSelectionModel().getSelectedItem()).m_Tag);
        CreateLessonMsg lessonMsg = new CreateLessonMsg();
        lessonMsg.m_PluginName = lessonInfo.get("Plugin");
        lessonMsg.m_MessageId = "CreateLesson";
        lessonMsg.m_LessonOptionsStr = ((ComboBoxItem)this.m_OptionsCombo.getSelectionModel().getSelectedItem()).m_Tag;
        lessonMsg.m_StringData = ((ComboBoxItem)this.m_LessonCombo.getSelectionModel().getSelectedItem()).m_Tag;
        this.m_View.GetOwner().PostMessage(lessonMsg.m_PluginName, lessonMsg);
        ShowViewMsg showViewMsg = new ShowViewMsg();
        showViewMsg.m_MessageId = "ShowView";
        showViewMsg.m_StringData = this.m_View.GetViewId();
        showViewMsg.m_PluginInstanceId = lessonInfo.get("Plugin");
        showViewMsg.m_ViewId = lessonInfo.get("View");
        showViewMsg.m_ViewTypeId = lessonInfo.get("View");
        this.m_View.GetOwner().PostMessage("host", showViewMsg);
    }

    public class ComboBoxItem {
        public String m_Text = "";
        public String m_Tag = "";

        public ComboBoxItem() {
        }

        public ComboBoxItem(String text) {
            this.m_Text = text;
        }

        public ComboBoxItem(String text, String tag) {
            this.m_Text = text;
            this.m_Tag = tag;
        }

        public String toString() {
            return this.m_Text;
        }
    }
}

