/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.activitycontrollerplugin;

import edu.uic.cs.nlp.chiqat.framework.messages.User;
import edu.uic.cs.nlp.chiqat.plugin.activitycontrollerplugin.ExplicitCheckBox;
import edu.uic.cs.nlp.chiqat.plugin.activitycontrollerplugin.IPanelCallback;
import edu.uic.cs.nlp.chiqat.plugin.activitycontrollerplugin.Parameters;
import edu.uic.cs.nlp.chiqat.plugin.activitycontrollerplugin.PluginInstance;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginViewFx;
import edu.uic.cs.nlp.chiqat.server.api.structs.CreateUserRequest;
import edu.uic.cs.nlp.chiqat.server.api.structs.CreateUserResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBoxBuilder;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class CreateUserPanel
extends AnchorPane
implements EventHandler<ActionEvent> {
    protected User m_User = null;
    protected String m_DataDir = "";
    protected PluginViewFx m_View = null;
    protected Label m_MessageLabel = null;
    protected TextField m_FirstNameTb = null;
    protected TextField m_LastNameTb = null;
    protected TextField m_EmailTb = null;
    protected ComboBox<ComboBoxItem> m_YearOfBirthCombo = null;
    protected ComboBox<ComboBoxItem> m_ProfessionCombo = null;
    protected TextField m_SchoolTb = null;
    protected ExplicitCheckBox m_AgreeToResearch = null;
    protected ExplicitCheckBox m_AgreeToSharing = null;
    protected Label m_ShowTermsLabel = null;
    protected Button m_CreateBtn = null;
    protected IPanelCallback m_Callback = null;
    protected static final String TermsOfUseString = "<h2>Consent for participation in research: Extending and validating a computational theory of effective tutoring</h2><h3>Why am I being asked?</h3><p>You are being asked to be a participant in a research study about the effectiveness of one-on-one tutoring conducted by Dr. Barbara Di Eugenio, Associate Professor in the Computer Science Department at the University of Illinois at Chicago (UIC).  You have been asked to participate in the research because you have shown interest in using our educational software, hence, are eligible to participate.  We ask that you read this form and ask any questions you may have by email or phone (contact information is listed below) before agreeing to be in the research.</p><p>Your participation in this research is voluntary. Your decision whether or not to participate will not affect your current or future relations with UIC. If you decide to participate, you are free to withdraw at any time without affecting that relationship. </p><h3>Why is this research being done?</h3><p>One-on-one tutoring has long been known to be a very effective form of instruction. If we could identify exactly why it is effective, we might be able to duplicate the crucial features of effective tutoring in educational software.  </p><h3>What is the purpose of this research? </h3><p>The purpose of this project is to compare novice, expert and computer-based tutors to identify the effective features of expert tutor behavior. We approach this problem by making systematic comparisons among novice, expert and computer-based tutors. Once we have identified some interesting differences, we implement those in educational software. Finally, we evaluate the resulting software by deploying it with students.</p><h3>What procedures are involved? </h3><p>If you agree to be in this research, we would ask of you the following:<ul><li>If you participate in the study by using our educational software, we ask your permission to record your work with the software. If you agree, you will gain access to the software and your work will be recorded electronically. You may also be asked to take a memory span test, an initial test on data structures (pretest) before using software, and a second test on data structures (posttest) after using software.  If you do not agree to have your data recorded, then you cannot access the software.</li><li>In participating, you will do only what you usually do when interacting with a computer.</li></ul>Approximately 5,000 participants may be involved in this research.</p><h3>What are the potential risks and discomforts?</h3><p>There are no risks associated with participation than those that accompany normal participation in using computers.  </p><h3>Are there benefits to taking part in the research? </h3><p>You will receive basic data structure instruction at no cost to yourself. This research may contribute to improved educational software, which would benefit any organization with extensive training needs.</p><h3>What other options are there?</h3><p>If you do not want to participate in the study by working with the software, then you do not have to. If you are a student at UIC or an employee at UIC, lack of participation will not affect your relationship with UIC.</p><h3>What about privacy and confidentiality? </h3><p>The only people who will know that you are a research participant are members of the research team. No information about you, or provided by you during the research will be disclosed to others without your written permission, except:<ul><li>if necessary to protect your rights or welfare (for example, if you are injured and need emergency care or when the UIC Institutional Review Board monitors the research or consent process); or</li><li>if required by law.</li></ul></p><p>When the results of the research are published or discussed in conferences, no information will be included that would reveal your identity.  Any information that is obtained in connection with this study and that can be identified with you will remain confidential and will be disclosed only with your permission or as required by law. Should we wish to include any part of your individual record, as opposed to group aggregates, in a public presentation, we will contact you to obtain your permission to do so.</p><p>Because collecting and analyzing data is a time consuming activity, research teams at UIC, or at other universities or research laboratories may ask us for access to the data. If we decide to share the data with them, we will do so only after any reference to your personal identity has been eliminated from the data. If you object to your data possibly being shared with other research teams, you can withhold your consent for that specific usage. Withholding your consent in that regard does not prevent you from participating in this study in any way.</p><h3>What are the costs for participating in this research?</h3><p>There are no costs to you to participate in this research.</p><h3>Will I be reimbursed for any of my expenses or paid for my participation in this research?</h3><p>You will not be reimbursed for participating in this research.</p><h3>Can I withdraw or be removed from the study? </h3><p>You can choose whether to be in this study or not.  If you volunteer to be in this study, you may withdraw at any time without consequences of any kind.</p><h3>Who should I contact if I have questions? </h3><p>The researcher conducting this study is Dr. Barbara Di Eugenio.  You may ask any questions you have for the research team by phone or by email.   Phone: 312/996-7566. Email: bdieugen@cs.uic.edu.</p><h3>What are my rights as a research participant?</h3><p>If you feel you have not been treated according to the descriptions in this form, or you have any questions about your rights as a research participant, you may call the UIC Office for the Protection of Research Subjects (OPRS) at 312-996-1711 (Chicago, IL area) or 1-866-789-6215 (toll-free) or e-mail OPRS at uicirb@uic.edu.</p><h3>What if I am a university student?</h3><p>You may choose not to participate or to stop your participation in this research at any time. This will not affect your class standing or grades at your university.  The investigator may also end your participation in the research.  If this happens, your class standing or grades will not be affected.  You will not be offered or receive any special consideration if you participate in this research.</p><h3>What if I am a university employee?</h3><p>Your participation in this research is in no way a part of your university duties, and your refusal to participate will not in any way affect your employment with the university, or the benefits, privileges, or opportunities associated with your employment at the university.  You will not be offered or receive any special consideration if you participate in this research.</p><p><strong>Remember:</strong> Your participation in this research is voluntary. Your decision whether or not to participate will not affect your current or future relations with UIC, your university, your instructor or Dr. Barbara Di Eugenio. If you decide to participate, you are free to withdraw at any time without affecting that relationship.</p><p>You may print a copy of this form to keep for your records.</p><h3>Consent of Participant</h3><p>I have read (or someone has read to me) the above information. I have been informed that I may ask questions by phone or email. I agree to participate in this research.  I have been informed that I may print a copy of this form for my records.</p><p>It has been explained to me that my data, <strong>without any identifying personal information</strong>, may be shared with other research teams, at UIC or other universities and research laboratories. I consent to this further use of my data.<p>";

    public void Clear() {
        this.m_FirstNameTb.setText("");
        this.m_LastNameTb.setText("");
        this.m_EmailTb.setText("");
        this.m_YearOfBirthCombo.getSelectionModel().select(20);
        this.m_ProfessionCombo.getSelectionModel().select(0);
        this.m_SchoolTb.setText("");
        this.m_AgreeToResearch.SetCheckState(ExplicitCheckBox.CheckState.Cs_None);
        this.m_AgreeToSharing.SetCheckState(ExplicitCheckBox.CheckState.Cs_None);
        this.m_CreateBtn.setDisable(true);
    }

    public boolean Init(PluginViewFx view, IPanelCallback callback) {
        this.m_View = view;
        this.m_Callback = callback;
        StackPane stackPane = new StackPane();
        BorderPane bp = new BorderPane();
        this.getChildren().add((Object)bp);
        CreateUserPanel.setRightAnchor((Node)bp, (Double)0.0);
        CreateUserPanel.setTopAnchor((Node)bp, (Double)0.0);
        CreateUserPanel.setBottomAnchor((Node)bp, (Double)0.0);
        CreateUserPanel.setLeftAnchor((Node)bp, (Double)0.0);
        bp.setCenter((Node)stackPane);
        Label l = null;
        this.m_DataDir = this.m_View.GetOwner().m_AppDataStore.GetValue("DataDir");
        Image bgImage = new Image("file://" + this.m_DataDir + "/Resources/MainLoginBackground.jpg");
        ImageView imageView = new ImageView();
        imageView.setImage(bgImage);
        imageView.setFitWidth(640.0);
        imageView.setFitHeight(480.0);
        stackPane.getChildren().add((Object)imageView);
        GridPane gridPane = new GridPane();
        stackPane.getChildren().add((Object)gridPane);
        gridPane.setPrefSize(200.0, 200.0);
        gridPane.setAlignment(Pos.CENTER);
        int iRowNum = 1;
        this.m_MessageLabel = new Label();
        this.m_MessageLabel.setTextFill((Paint)Color.RED);
        gridPane.add((Node)this.m_MessageLabel, 0, iRowNum++);
        GridPane.setColumnSpan((Node)this.m_MessageLabel, (Integer)2);
        l = new Label();
        l.setText("First Name");
        this.m_FirstNameTb = new TextField();
        gridPane.addRow(iRowNum++, new Node[]{l, this.m_FirstNameTb});
        l = new Label();
        l.setText("Last Name");
        this.m_LastNameTb = new TextField();
        gridPane.addRow(iRowNum++, new Node[]{l, this.m_LastNameTb});
        l = new Label();
        l.setText("Email");
        this.m_EmailTb = new TextField();
        gridPane.addRow(iRowNum++, new Node[]{l, this.m_EmailTb});
        l = new Label();
        l.setText("Yeah of Birth");
        this.m_YearOfBirthCombo = new ComboBox();
        this.m_YearOfBirthCombo.setMaxWidth(Double.MAX_VALUE);
        int i = 2014;
        while (i > 1910) {
            this.m_YearOfBirthCombo.getItems().add((Object)new ComboBoxItem(String.valueOf(i), String.valueOf(i)));
            --i;
        }
        this.m_YearOfBirthCombo.getSelectionModel().select(20);
        gridPane.addRow(iRowNum++, new Node[]{l, this.m_YearOfBirthCombo});
        l = new Label();
        l.setText("Profession");
        this.m_ProfessionCombo = new ComboBox();
        this.m_ProfessionCombo.getItems().addAll((Object[])new ComboBoxItem[]{new ComboBoxItem("Student", "Student"), new ComboBoxItem("Instructor", "Instructor"), new ComboBoxItem("Researcher", "Researcher"), new ComboBoxItem("Other", "Other")});
        this.m_ProfessionCombo.setMaxWidth(Double.MAX_VALUE);
        this.m_ProfessionCombo.getSelectionModel().select(0);
        gridPane.addRow(iRowNum++, new Node[]{l, this.m_ProfessionCombo});
        l = new Label();
        l.setText("School (if applicable)");
        this.m_SchoolTb = new TextField();
        gridPane.addRow(iRowNum++, new Node[]{l, this.m_SchoolTb});
        this.m_ShowTermsLabel = new Label();
        this.m_ShowTermsLabel.setText("Click for Terms of Use");
        this.m_ShowTermsLabel.setAlignment(Pos.BOTTOM_RIGHT);
        this.m_ShowTermsLabel.setTextFill((Paint)Color.BLUE);
        this.m_ShowTermsLabel.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        gridPane.add((Node)this.m_ShowTermsLabel, 0, iRowNum++);
        GridPane.setColumnSpan((Node)this.m_ShowTermsLabel, (Integer)2);
        this.m_ShowTermsLabel.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
                    Stage dialogStage = new Stage();
                    WebView webCtrl = new WebView();
                    webCtrl.getEngine().loadContent(CreateUserPanel.TermsOfUseString);
                    dialogStage.initModality(Modality.WINDOW_MODAL);
                    dialogStage.setScene(new Scene((Parent)((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().children(new Node[]{webCtrl})).alignment(Pos.CENTER).padding(new Insets(5.0))).build()));
                    dialogStage.setWidth(640.0);
                    dialogStage.setHeight(480.0);
                    dialogStage.show();
                    CreateUserPanel.this.m_CreateBtn.setDisable(false);
                }
            }
        });
        this.m_ShowTermsLabel.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                CreateUserPanel.this.m_ShowTermsLabel.setTextFill((Paint)Color.LIGHTBLUE);
            }
        });
        this.m_ShowTermsLabel.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                CreateUserPanel.this.m_ShowTermsLabel.setTextFill((Paint)Color.BLUE);
            }
        });
        this.m_AgreeToResearch = new ExplicitCheckBox();
        this.m_AgreeToResearch.Init("I agree to participate in this research", "Yes", "No");
        gridPane.add((Node)this.m_AgreeToResearch, 0, iRowNum++);
        GridPane.setColumnSpan((Node)this.m_AgreeToResearch, (Integer)2);
        this.m_AgreeToSharing = new ExplicitCheckBox();
        this.m_AgreeToSharing.Init("I agree to allow my data to be shared", "Yes", "No");
        gridPane.add((Node)this.m_AgreeToSharing, 0, iRowNum++);
        GridPane.setColumnSpan((Node)this.m_AgreeToSharing, (Integer)2);
        this.m_CreateBtn = new Button();
        this.m_CreateBtn.setOnAction((EventHandler)this);
        this.m_CreateBtn.setText("Create User");
        this.m_CreateBtn.setMaxWidth(Double.MAX_VALUE);
        gridPane.add((Node)this.m_CreateBtn, 0, iRowNum++);
        GridPane.setColumnSpan((Node)this.m_CreateBtn, (Integer)2);
        this.m_CreateBtn.setDisable(true);
        return true;
    }

    public void handle(ActionEvent arg0) {
        String errMsg = "";
        String firstName = this.m_FirstNameTb.getText();
        String lastName = this.m_LastNameTb.getText();
        String profession = ((ComboBoxItem)this.m_ProfessionCombo.getSelectionModel().getSelectedItem()).m_Tag;
        String school = this.m_SchoolTb.getText();
        int iYearOfBirth = Integer.parseInt(((ComboBoxItem)this.m_YearOfBirthCombo.getSelectionModel().getSelectedItem()).m_Tag);
        String emailAddr = this.m_EmailTb.getText();
        if (firstName.length() == 0) {
            errMsg = "Please enter a first name";
        } else if (lastName.length() == 0) {
            errMsg = "Please enter a last name";
        } else if (emailAddr.lastIndexOf(46) <= emailAddr.indexOf(64) || emailAddr.indexOf(64) == -1) {
            errMsg = "Please enter a valid email address";
        } else if (this.m_AgreeToResearch.GetCheckState() != ExplicitCheckBox.CheckState.Cs_None && this.m_AgreeToSharing.GetCheckState() != ExplicitCheckBox.CheckState.Cs_None) {
            CreateUserRequest req = new CreateUserRequest();
            req.first_name = firstName;
            req.last_name = lastName;
            req.profession = profession;
            req.school = school;
            req.year_of_birth = iYearOfBirth;
            req.email_addr = emailAddr;
            req.agree_to_research = this.m_AgreeToResearch.GetCheckState() == ExplicitCheckBox.CheckState.Cs_Yes;
            req.agree_to_data_sharing = this.m_AgreeToSharing.GetCheckState() == ExplicitCheckBox.CheckState.Cs_Yes;
            CreateUserResponse res = PluginInstance.m_ChiQatServer.CreateUser(req);
            if (res != null) {
                if (res.result.compareToIgnoreCase("S_OK") == 0) {
                    this.m_Callback.OnComplete(this, "ShowMessage", "Thank you for registering, your username and password will be emailed to you shortly");
                } else if (res.result.compareToIgnoreCase("E_EmailExists") == 0) {
                    errMsg = "The email address is already in use. Please login on the introduction screen";
                }
            } else {
                errMsg = "Cannot create user. Please check your Internet connection and try again later";
            }
        } else {
            errMsg = "Please state your intention of participating";
        }
        if (errMsg.length() > 0) {
            this.m_MessageLabel.setText(errMsg);
        }
    }

    private boolean checkServerVersion() {
        String error;
        String serverVersion = null;
        try {
            URL url = new URL(Parameters.getVersionServer());
            URLConnection connection = url.openConnection();
            BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            serverVersion = rd.readLine();
            rd.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (serverVersion == null) {
            error = "I can't establish communication with the iList server.";
            this.ShowMessageBox(error);
            return false;
        }
        if (!serverVersion.equals("1.0")) {
            error = "You are using iList client version TODO.\nThe server requires version " + serverVersion + " to work properly.\nPlease download the latest version of iList.";
            this.ShowMessageBox(error);
            return false;
        }
        return true;
    }

    public void ShowMessageBox(String msg) {
        Stage dialogStage = new Stage();
        dialogStage.initModality(Modality.WINDOW_MODAL);
        dialogStage.setScene(new Scene((Parent)((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().children(new Node[]{new Text(msg), new Button("Ok.")})).alignment(Pos.CENTER).padding(new Insets(5.0))).build()));
        dialogStage.show();
    }

    public class ComboBoxItem {
        public String m_Text = "";
        public String m_Tag = "";

        public ComboBoxItem() {
        }

        public ComboBoxItem(String text) {
            this.m_Text = text;
        }

        public ComboBoxItem(String text, String tag) {
            this.m_Text = text;
            this.m_Tag = tag;
        }

        public String toString() {
            return this.m_Text;
        }
    }
}

