/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.activitycontrollerplugin;

import edu.uic.cs.nlp.chiqat.framework.messages.LogMsg;
import edu.uic.cs.nlp.chiqat.framework.messages.User;
import edu.uic.cs.nlp.chiqat.framework.messages.UserLoginMessage;
import edu.uic.cs.nlp.chiqat.plugin.activitycontrollerplugin.IPanelCallback;
import edu.uic.cs.nlp.chiqat.plugin.activitycontrollerplugin.PluginInstance;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginViewFx;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBoxBuilder;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class LoginPanel
extends AnchorPane
implements EventHandler<ActionEvent> {
    protected TextField m_UserNameTb = null;
    protected PasswordField m_PwdField = null;
    protected User m_User = null;
    protected Label m_MessageLabel = null;
    protected boolean m_bDummyLogin = false;
    protected String m_DataDir = "";
    protected Label m_HintLink = null;
    private static String Hint_CreateAccount = "Click here to Create an Account";
    private static String Url_AccountCreator = "http://www.digitaltutor.net/signup.php";
    protected PluginViewFx m_View = null;
    protected IPanelCallback m_Callback = null;

    public boolean Init(PluginViewFx view, IPanelCallback callback) {
        this.m_Callback = callback;
        this.m_View = view;
        StackPane stackPane = new StackPane();
        BorderPane bp = new BorderPane();
        this.getChildren().add((Object)bp);
        LoginPanel.setRightAnchor((Node)bp, (Double)0.0);
        LoginPanel.setTopAnchor((Node)bp, (Double)0.0);
        LoginPanel.setBottomAnchor((Node)bp, (Double)0.0);
        LoginPanel.setLeftAnchor((Node)bp, (Double)0.0);
        bp.setCenter((Node)stackPane);
        this.m_DataDir = this.m_View.GetOwner().m_AppDataStore.GetValue("DataDir");
        Image bgImage = new Image("file://" + this.m_DataDir + "/Resources/MainLoginBackground.jpg");
        ImageView imageView = new ImageView();
        imageView.setImage(bgImage);
        imageView.setFitWidth(640.0);
        imageView.setFitHeight(480.0);
        stackPane.getChildren().add((Object)imageView);
        GridPane gridPane = new GridPane();
        stackPane.getChildren().add((Object)gridPane);
        gridPane.setPrefSize(200.0, 200.0);
        gridPane.setAlignment(Pos.CENTER);
        this.m_MessageLabel = new Label();
        this.m_MessageLabel.setTextFill((Paint)Color.RED);
        gridPane.add((Node)this.m_MessageLabel, 0, 0);
        GridPane.setColumnSpan((Node)this.m_MessageLabel, (Integer)2);
        this.m_MessageLabel.setAlignment(Pos.CENTER);
        Label userNameLabel = new Label();
        userNameLabel.setText("User Name");
        this.m_UserNameTb = new TextField();
        gridPane.addRow(1, new Node[]{userNameLabel, this.m_UserNameTb});
        Label passwordLabel = new Label();
        passwordLabel.setText("Password");
        this.m_PwdField = new PasswordField();
        gridPane.addRow(2, new Node[]{passwordLabel, this.m_PwdField});
        Button okButton = new Button();
        okButton.setOnAction((EventHandler)this);
        okButton.setText("Login");
        okButton.setMaxWidth(Double.MAX_VALUE);
        gridPane.add((Node)okButton, 0, 4);
        GridPane.setColumnSpan((Node)okButton, (Integer)2);
        this.m_HintLink = new Label();
        this.m_HintLink.setText("No hint");
        this.m_HintLink.setAlignment(Pos.BOTTOM_RIGHT);
        this.m_HintLink.setTextFill(Paint.valueOf((String)"blue"));
        this.m_HintLink.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.m_HintLink.setText(Hint_CreateAccount);
        this.m_HintLink.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && LoginPanel.this.m_HintLink.getText().compareTo(Hint_CreateAccount) == 0) {
                    LoginPanel.this.ShowAccountCreator();
                }
            }
        });
        this.m_HintLink.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                LoginPanel.this.m_HintLink.setTextFill((Paint)Color.LIGHTBLUE);
            }
        });
        this.m_HintLink.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                LoginPanel.this.m_HintLink.setTextFill((Paint)Color.BLUE);
            }
        });
        bp.setBottom((Node)this.m_HintLink);
        String defaultUserName = this.m_View.GetOwner().m_BluePrint.GetPluginArgument("DefaultUserName");
        String defaultPassword = this.m_View.GetOwner().m_BluePrint.GetPluginArgument("DefaultPassword");
        this.m_UserNameTb.setText(defaultUserName == null ? "" : defaultUserName);
        this.m_PwdField.setText(defaultPassword == null ? "" : defaultPassword);
        return true;
    }

    private void ShowAccountCreator() {
        this.m_Callback.OnComplete(this, "GotoCreateUser", "");
    }

    public void handle(ActionEvent arg0) {
        String pwdText;
        String unText = this.m_UserNameTb.getText();
        if (this.loginUser(unText, pwdText = this.m_PwdField.getText())) {
            UserLoginMessage msg = new UserLoginMessage();
            msg.m_User = this.m_User;
            msg.m_MessageId = "UserLoggedIn";
            this.m_View.GetOwner().PostMessage(msg);
            this.m_Callback.OnComplete(this, "LoggedIn", "");
        }
    }

    protected boolean loginUser(String userName, String password) {
        boolean bSuccess = false;
        if (this.m_bDummyLogin) {
            this.m_User = User.getLocalUser("http://digitaltutor.net", userName, password);
            bSuccess = this.m_User != null;
        } else {
            this.m_User = User.getAuthenticatedUser(PluginInstance.m_ChiQatServer, userName, password);
            if (this.m_User != null) {
                bSuccess = true;
            } else {
                this.m_MessageLabel.setText("Login Error - Ensure your user name and password are correct");
                System.out.println("Login Error");
            }
        }
        return bSuccess;
    }

    public void LogInfo(LogMsg.LogEntryLevel level, String msgType, boolean bDebug) {
        this.LogInfo(level, msgType, bDebug, "", "", "");
    }

    public void LogInfo(LogMsg.LogEntryLevel level, String msgType, boolean bDebug, String arg1) {
        this.LogInfo(level, msgType, bDebug, arg1, "", "");
    }

    public void LogInfo(LogMsg.LogEntryLevel level, String msgType, boolean bDebug, String arg1, String arg2) {
        this.LogInfo(level, msgType, bDebug, arg1, arg2, "");
    }

    public void LogInfo(LogMsg.LogEntryLevel level, String msgType, boolean bDebug, String arg1, String arg2, String arg3) {
        LogMsg msg = new LogMsg();
        msg.m_MessageId = "Log";
        msg.m_MsgType = msgType;
        msg.m_Level = level;
        msg.m_Arg1 = arg1;
        msg.m_Arg2 = arg2;
        msg.m_Arg3 = arg3;
        msg.m_bDebug = bDebug;
        this.m_View.GetOwner().PostMessage(msg);
    }

    public void ShowMessageBox(String msg) {
        Stage dialogStage = new Stage();
        dialogStage.initModality(Modality.WINDOW_MODAL);
        dialogStage.setScene(new Scene((Parent)((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().children(new Node[]{new Text(msg), new Button("Ok.")})).alignment(Pos.CENTER).padding(new Insets(5.0))).build()));
        dialogStage.show();
    }
}

