/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.adminplugin;

import edu.uic.cs.nlp.chiqat.plugin.adminplugin.PluginInstance;
import edu.uic.cs.nlp.chiqat.plugin.adminplugin.UserBrowserTable;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginViewFx;
import edu.uic.cs.nlp.chiqat.server.api.structs.GetUserControlInfoRequest;
import edu.uic.cs.nlp.chiqat.server.api.structs.GetUserControlInfoResponse;
import edu.uic.cs.nlp.chiqat.server.api.structs.SetUserControlInfoRequest;
import edu.uic.cs.nlp.chiqat.server.api.structs.SetUserControlInfoResponse;
import edu.uic.cs.nlp.chiqat.server.api.structs.UserControlInfo;
import edu.uic.cs.nlp.toolbox.CsvParser;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;

public class AdminView
extends PluginViewFx
implements EventHandler<ActionEvent> {
    public static int m_iTestNum = 0;
    protected BorderPane m_RootPane = null;
    protected UserBrowserTable m_UserBrowser = null;
    protected Button m_OkBtn = null;
    protected MenuBar m_MenuBar = null;
    protected Map<Integer, UserControlInfo> m_CurrentUsers = new HashMap<Integer, UserControlInfo>();

    @Override
    public boolean Init() {
        this.m_RootPane = new BorderPane();
        this.m_UserBrowser = new UserBrowserTable();
        this.m_RootPane.setCenter((Node)this.m_UserBrowser);
        this.m_MenuBar = new MenuBar();
        this.m_RootPane.setTop((Node)this.m_MenuBar);
        Menu mainMenu = new Menu("File");
        this.AddMenuItem(mainMenu, "Save", "SaveItem");
        this.AddMenuItem(mainMenu, "Refresh", "RefreshItem");
        this.AddMenuItem(mainMenu, "Import From CSV...", "ImportItem");
        this.AddMenuItem(mainMenu, "Close", "CloseItem");
        this.m_MenuBar.getMenus().add((Object)mainMenu);
        AdminView.setTopAnchor((Node)this.m_RootPane, (Double)0.0);
        AdminView.setBottomAnchor((Node)this.m_RootPane, (Double)0.0);
        AdminView.setLeftAnchor((Node)this.m_RootPane, (Double)0.0);
        AdminView.setRightAnchor((Node)this.m_RootPane, (Double)0.0);
        this.getChildren().add((Object)this.m_RootPane);
        this.m_RootPane.setPrefSize(400.0, 600.0);
        this.RefreshUserList();
        return true;
    }

    private void AddMenuItem(Menu mainMenu, String text, String idStr) {
        MenuItem menuItem = new MenuItem(text);
        mainMenu.getItems().add((Object)menuItem);
        menuItem.setId(idStr);
        menuItem.onActionProperty().set((Object)this);
    }

    public void handle(ActionEvent arg0) {
        String ctrlId = ((MenuItem)arg0.getTarget()).getId();
        if (ctrlId.compareTo("CloseItem") != 0) {
            if (ctrlId.compareTo("SaveItem") == 0) {
                this.CommitToServer();
            } else if (ctrlId.compareTo("RefreshItem") == 0) {
                this.RefreshUserList();
            } else if (ctrlId.compareTo("ImportItem") == 0) {
                this.ImportFromCsv();
            }
        }
    }

    public void ImportFromCsv() {
        File selectedFile;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import CSV File");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("CSV File", new String[]{"*.csv"}), new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"})});
        String defaultDirStr = "/C:/Temp";
        File defaultDirectory = new File(defaultDirStr);
        if (defaultDirectory.isDirectory()) {
            fileChooser.setInitialDirectory(defaultDirectory);
        }
        if ((selectedFile = fileChooser.showOpenDialog(this.getScene().getWindow())) != null) {
            String s = selectedFile.getPath();
            CsvParser parser = CsvParser.FromFile(s);
            this.ImportCsv(parser);
        }
    }

    protected void ImportCsv(CsvParser parser) {
        ArrayList<UserControlInfo> updatedUsers = new ArrayList<UserControlInfo>();
        int iNumEntries = parser.GetNumEntries();
        int i = 0;
        while (i < iNumEntries) {
            UserControlInfo info = new UserControlInfo();
            info.email = parser.Get(i, "email");
            if (parser.Get(i, "woe_access") != null) {
                info.woe_access = Integer.parseInt(parser.Get(i, "woe_access"));
            }
            updatedUsers.add(info);
            ++i;
        }
        if (updatedUsers.size() > 0) {
            SetUserControlInfoRequest req = new SetUserControlInfoRequest();
            req.users = updatedUsers;
            SetUserControlInfoResponse setUserControlInfoResponse = PluginInstance.m_ChiQatServer.SetUserControlInfo(req);
        }
    }

    protected void RefreshUserList() {
        GetUserControlInfoRequest req = new GetUserControlInfoRequest();
        GetUserControlInfoResponse res = PluginInstance.m_ChiQatServer.GetUserControlInfo(req);
        if (res != null && res.users != null) {
            this.m_UserBrowser.SetUserInfo(res.users);
            this.m_CurrentUsers.clear();
            for (UserControlInfo user : res.users) {
                this.m_CurrentUsers.put(user.id, user);
            }
        }
    }

    protected void CommitToServer() {
        List<UserControlInfo> updatedUsers = this.m_UserBrowser.GetUserInfo();
        int i = 0;
        while (i < updatedUsers.size()) {
            boolean bUpdated = false;
            UserControlInfo newInfo = updatedUsers.get(i);
            if (this.m_CurrentUsers.containsKey(newInfo.id)) {
                UserControlInfo currentInfo = this.m_CurrentUsers.get(newInfo.id);
                if (!updatedUsers.get(i).Equals(currentInfo)) {
                    bUpdated = true;
                }
            }
            if (!bUpdated) {
                updatedUsers.remove(i--);
            }
            ++i;
        }
        if (updatedUsers.size() > 0) {
            SetUserControlInfoRequest req = new SetUserControlInfoRequest();
            req.users = updatedUsers;
            SetUserControlInfoResponse setUserControlInfoResponse = PluginInstance.m_ChiQatServer.SetUserControlInfo(req);
        }
    }
}

