/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.adminplugin;

import edu.uic.cs.nlp.chiqat.plugin.adminplugin.UserBrowserItem;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.cell.CheckBoxTableCell;

class EditingCheckBoxCell
extends CheckBoxTableCell<UserBrowserItem, Boolean> {
    private CheckBox textField;

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createTextField();
            this.setText(null);
            this.setGraphic((Node)this.textField);
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setGraphic(null);
    }

    public void updateItem(Boolean item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(this.getString());
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
        } else {
            this.setText(this.getString());
            this.setGraphic(null);
        }
    }

    private void createTextField() {
        this.textField = new CheckBox(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (!arg2.booleanValue()) {
                    EditingCheckBoxCell.this.commitEdit(EditingCheckBoxCell.this.textField.isSelected());
                }
            }
        });
    }

    public boolean getValue() {
        return this.getItem() == null ? false : (Boolean)this.getItem();
    }

    private String getString() {
        return this.getItem() == null ? "" : ((Boolean)this.getItem()).toString();
    }
}

