/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.adminplugin;

import edu.uic.cs.nlp.chiqat.plugin.adminplugin.EditingCell;
import edu.uic.cs.nlp.chiqat.plugin.adminplugin.UserBrowserItem;
import edu.uic.cs.nlp.chiqat.server.api.structs.UserControlInfo;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;

public class UserBrowserTable
extends TableView<UserBrowserItem> {
    private final ObservableList<String> m_TrueFalseEntries = FXCollections.observableArrayList((Object[])new String[]{new String("True"), new String("False")});
    private final ObservableList<UserBrowserItem> m_Data = FXCollections.observableArrayList();

    public UserBrowserTable() {
        this.setEditable(true);
        Callback<TableColumn, TableCell> cellFactory = new Callback<TableColumn, TableCell>(){

            public TableCell call(TableColumn p) {
                return new EditingCell();
            }
        };
        Callback<TableColumn, CheckBoxTableCell> checkCellFactory = new Callback<TableColumn, CheckBoxTableCell>(){

            public CheckBoxTableCell call(TableColumn p) {
                return new CheckBoxTableCell();
            }
        };
        TableColumn emailCol = new TableColumn("Email");
        emailCol.setCellValueFactory((Callback)new PropertyValueFactory("email"));
        TableColumn idCol = new TableColumn("ID");
        idCol.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        TableColumn woeEnabledCol = new TableColumn("WOE Enabled");
        woeEnabledCol.setCellValueFactory((Callback)new PropertyValueFactory("woeEnabled"));
        woeEnabledCol.setCellFactory(ComboBoxTableCell.forTableColumn(this.m_TrueFalseEntries));
        woeEnabledCol.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<UserBrowserItem, String>>(){

            public void handle(TableColumn.CellEditEvent<UserBrowserItem, String> t) {
                ((UserBrowserItem)t.getTableView().getItems().get(t.getTablePosition().getRow())).setWoeEnabled(((String)t.getNewValue()).compareTo("True") == 0);
            }
        });
        TableColumn adminPrivilegesCol = new TableColumn("Admin Privileges");
        adminPrivilegesCol.setCellValueFactory((Callback)new PropertyValueFactory("adminPrivilege"));
        adminPrivilegesCol.setCellFactory(ComboBoxTableCell.forTableColumn(this.m_TrueFalseEntries));
        adminPrivilegesCol.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<UserBrowserItem, String>>(){

            public void handle(TableColumn.CellEditEvent<UserBrowserItem, String> t) {
                ((UserBrowserItem)t.getTableView().getItems().get(t.getTablePosition().getRow())).setAdminPrivilege(((String)t.getNewValue()).compareTo("True") == 0);
            }
        });
        TableColumn firstNameCol = new TableColumn("First Name");
        firstNameCol.setCellValueFactory((Callback)new PropertyValueFactory("firstName"));
        firstNameCol.setCellFactory((Callback)cellFactory);
        firstNameCol.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<UserBrowserItem, String>>(){

            public void handle(TableColumn.CellEditEvent<UserBrowserItem, String> t) {
                ((UserBrowserItem)t.getTableView().getItems().get(t.getTablePosition().getRow())).setFirstName((String)t.getNewValue());
            }
        });
        TableColumn lastNameCol = new TableColumn("Last Name");
        lastNameCol.setCellValueFactory((Callback)new PropertyValueFactory("lastName"));
        lastNameCol.setCellFactory((Callback)cellFactory);
        lastNameCol.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<UserBrowserItem, String>>(){

            public void handle(TableColumn.CellEditEvent<UserBrowserItem, String> t) {
                ((UserBrowserItem)t.getTableView().getItems().get(t.getTablePosition().getRow())).setLastName((String)t.getNewValue());
            }
        });
        this.getColumns().addAll((Object[])new TableColumn[]{idCol, emailCol, firstNameCol, lastNameCol, woeEnabledCol, adminPrivilegesCol});
        this.setItems(this.m_Data);
    }

    public void SetUserInfo(List<UserControlInfo> users) {
        this.m_Data.clear();
        for (UserControlInfo user : users) {
            UserBrowserItem item = new UserBrowserItem(user.id, user.first_name, user.last_name, user.email, (user.woe_access & 1) != 0, (user.privileges & 1) != 0);
            this.m_Data.add((Object)item);
        }
    }

    public List<UserControlInfo> GetUserInfo() {
        ArrayList<UserControlInfo> infos = new ArrayList<UserControlInfo>();
        int i = 0;
        while (i < this.m_Data.size()) {
            UserBrowserItem item = (UserBrowserItem)this.m_Data.get(i);
            UserControlInfo info = new UserControlInfo();
            info.email = item.getEmail();
            info.first_name = item.getFirstName();
            info.last_name = item.getLastName();
            info.id = item.getId();
            info.woe_access = item.getWoeEnabled() ? 1 : 0;
            info.privileges = item.getAdminPrivilege() ? 1 : 0;
            infos.add(info);
            ++i;
        }
        return infos;
    }
}

