/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.base;

import edu.uic.cs.nlp.chiqat.framework.AppDataStore;
import edu.uic.cs.nlp.chiqat.framework.BaseMessageReceiver;
import edu.uic.cs.nlp.chiqat.framework.BluePrintNode;
import edu.uic.cs.nlp.chiqat.framework.IMessageReceiver;
import edu.uic.cs.nlp.chiqat.framework.KeyValuePair;
import edu.uic.cs.nlp.chiqat.framework.Message;
import edu.uic.cs.nlp.chiqat.framework.PluginConnector;
import edu.uic.cs.nlp.chiqat.framework.messages.User;
import edu.uic.cs.nlp.chiqat.framework.messages.UserLoginMessage;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginController;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginMenuItemDefinition;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginViewDefinition;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginViewFx;
import java.util.ArrayList;
import java.util.List;

public abstract class BasePluginInstance
implements IMessageReceiver {
    protected List<PluginViewDefinition> m_ViewDefs = new ArrayList<PluginViewDefinition>();
    protected PluginConnector m_Connector = null;
    protected List<PluginViewFx> m_Views = new ArrayList<PluginViewFx>();
    protected List<PluginController> m_Controllers = new ArrayList<PluginController>();
    protected User m_User = null;
    protected BaseMessageReceiver m_Receiver = null;
    public List<PluginMenuItemDefinition> m_MenuItemDefs = new ArrayList<PluginMenuItemDefinition>();
    public BluePrintNode m_BluePrint = null;
    public AppDataStore m_AppDataStore = null;

    protected boolean Init(PluginConnector connector, List<KeyValuePair> args, BluePrintNode node, AppDataStore appDataStore, BaseMessageReceiver msgReceiver) {
        boolean bSuccess = false;
        if (connector != null && node != null) {
            this.m_Connector = connector;
            this.m_BluePrint = node;
            this.m_AppDataStore = appDataStore;
            bSuccess = true;
            this.m_Receiver = msgReceiver;
        }
        return bSuccess;
    }

    public abstract boolean Init(PluginConnector var1, List<KeyValuePair> var2, BluePrintNode var3, AppDataStore var4);

    public List<PluginViewDefinition> GetViewDefinitions() {
        return this.m_ViewDefs;
    }

    public boolean PostMessage(String dest, Message msg) {
        if (msg.m_DestPlugin == null || msg.m_DestPlugin == "") {
            msg.m_DestPlugin = dest;
        }
        return this.m_Connector.PostMessage(msg);
    }

    public boolean PostMessage(Message msg) {
        return this.m_Connector.PostMessage(msg);
    }

    public boolean SendMessage(String dest, Message msg) {
        if (msg.m_DestPlugin == null || msg.m_DestPlugin == "") {
            msg.m_DestPlugin = dest;
        }
        return this.m_Connector.PostMessage(msg);
    }

    public boolean LocalBroadcastMessage(Message msg) {
        return this.m_Connector.LocalBroadcastMessage(msg);
    }

    public boolean BroadcastMessage(Message msg) {
        return this.m_Connector.BroadcastMessage(msg);
    }

    public boolean Destroy() {
        if (this.m_Receiver != null) {
            this.m_Receiver.Shutdown();
        }
        return true;
    }

    protected void OnCreatingView(PluginViewFx view, PluginViewDefinition def) {
    }

    protected PluginViewFx OnCreateView(PluginViewDefinition def, String viewId) {
        PluginViewFx ret = null;
        try {
            ret = (PluginViewFx)((Object)def.m_ViewType.newInstance());
            this.OnCreatingView(ret, def);
            if (!ret.Init(this, def, viewId)) {
                return null;
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        if (ret != null) {
            this.m_Views.add(ret);
            this.OnViewCreated(ret);
        }
        return ret;
    }

    protected void OnViewCreated(PluginViewFx view) {
    }

    @Override
    public void OnMessage(Message msg) {
        for (PluginController pc : this.m_Controllers) {
            if (msg.m_DestControllerId != null && msg.m_DestControllerId != "" && pc.GetControllerId().compareTo(msg.m_DestControllerId) != 0) continue;
            pc.OnMessage(msg);
        }
        switch (msg.m_MessageId) {
            case "UserLoggedIn": {
                UserLoginMessage userMsg = (UserLoginMessage)msg;
                this.m_User = userMsg.m_User;
            }
        }
    }

    public User GetLoggedInUser() {
        return this.m_User;
    }

    public String GetInstanceId() {
        return this.m_BluePrint.CFG_PluginInstanceId;
    }

    public void RegisterController(PluginController controller) {
        for (PluginController ctrl : this.m_Controllers) {
            if (ctrl != controller) continue;
            return;
        }
        this.m_Controllers.add(controller);
    }
}

