/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.helpplugin;

import edu.uic.cs.nlp.chiqat.framework.Message;
import edu.uic.cs.nlp.chiqat.framework.messages.PlayWoeMsg;
import edu.uic.cs.nlp.chiqat.framework.messages.User;
import edu.uic.cs.nlp.chiqat.lessontoolbox.IInputInterface;
import edu.uic.cs.nlp.chiqat.lessontoolbox.LessonController;
import edu.uic.cs.nlp.chiqat.plugin.base.BasePluginInstance;
import edu.uic.cs.nlp.chiqat.plugin.helpplugin.UiOverviewView;
import edu.uic.cs.nlp.toolbox.MiscFuncs;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;

public class UiOverviewController
extends LessonController
implements EventHandler<ActionEvent>,
IInputInterface {
    public UiOverviewController(BasePluginInstance inst, String controllerId) {
        super(inst, controllerId);
    }

    @Override
    public void SetUser(User user) {
        this.m_User = user;
    }

    public void RegisterView(UiOverviewView v) {
        this.m_View = v;
    }

    @Override
    public void handle(ActionEvent e) {
        String com = "";
        if (e.getSource() instanceof Button) {
            com = ((Button)e.getSource()).getId();
        } else if (e.getSource() instanceof MenuItem) {
            MenuItem item = (MenuItem)e.getSource();
            com = item.getId();
        } else if (e.getSource() instanceof TextField) {
            TextField tf = (TextField)e.getSource();
            com = tf.getId();
        }
        long timestamp = System.currentTimeMillis();
        String session = this.m_User.getSession();
    }

    @Override
    public void OnSetProblem(String newPid) {
    }

    @Override
    public void OnExample() {
    }

    @Override
    public void OnSubmit() {
    }

    @Override
    public void OnRestart() {
    }

    private boolean ExecuteSpecialCommand(String commandText) {
        String strippedCmd;
        Map<String, String> args;
        boolean bSuccess = false;
        if (commandText.startsWith("::") && commandText.length() > 2 && (args = MiscFuncs.ParseQueryString(strippedCmd = commandText.substring(2, commandText.length()))).size() > 0) {
            this.ExecuteSpecialCommand(args);
            bSuccess = true;
        }
        bSuccess = false;
        return false;
    }

    private void ExecuteSpecialCommand(Map<String, String> args) {
        block20: {
            if (!args.containsKey("cmd")) break block20;
            String cmd = args.get("cmd");
            int iStateSpaceId = -1;
            if (args.containsKey("statespace")) {
                iStateSpaceId = MiscFuncs.IntTryParse(args.get("statespace"));
            }
            switch (cmd) {
                case "Print": {
                    if (!args.containsKey("msg")) break;
                    String msg = args.get("msg");
                    System.out.println("Special Comand: " + msg);
                    break;
                }
                case "SetBackgroundImage": {
                    if (!args.containsKey("path")) break;
                    String msg = args.get("path");
                    break;
                }
                case "Operation": {
                    if (!args.containsKey("data")) break;
                    String dataStr = args.get("data");
                    boolean bl = !args.containsKey("record") || args.get("record").compareToIgnoreCase("false") != 0;
                    break;
                }
                case "MoveNode": {
                    if (!args.containsKey("x") || !args.containsKey("y")) break;
                    int iX = MiscFuncs.IntTryParse(args.get("x"));
                    int iY = MiscFuncs.IntTryParse(args.get("y"));
                    if (iX <= 0 || iY <= 0 || !args.containsKey("val")) break;
                    String string = args.get("val");
                    break;
                }
                case "BlockOperation": {
                    String dataStr = args.get("data");
                    boolean bRecord = !args.containsKey("record") || args.get("record").compareToIgnoreCase("false") != 0;
                    dataStr = dataStr.replace(";", ";\n");
                }
            }
        }
    }

    public UiOverviewView GetOverviewView() {
        return (UiOverviewView)this.m_View;
    }

    public void OnTutorMessage() {
    }

    @Override
    public void EnableInput(boolean bEnable) {
        this.EnableInput(bEnable, 0);
    }

    @Override
    public void EnableInput(boolean bEnable, int iDelayMs) {
        ((UiOverviewView)this.m_View).EnableProblemInput(bEnable, iDelayMs);
    }

    @Override
    public void CloseLesson() {
        if (this.m_View != null) {
            this.m_View.Close();
        }
    }

    public void StartWalkthrough() {
        String woePath = "WalkThrough.woe";
        if (!woePath.isEmpty()) {
            String woeDir = String.valueOf(this.m_PluginInstance.m_AppDataStore.GetValue("DataDir")) + "/Resources/Help/ChiQatTutorial/";
            String woeFile = String.valueOf(woeDir) + woePath;
            PlayWoeMsg msg = new PlayWoeMsg();
            msg.m_FilePath = woeFile;
            msg.m_MessageId = "PlayWoe";
            msg.m_PlaybackInstanceId = this.m_PluginInstance.m_BluePrint.CFG_PluginInstanceId;
            msg.m_PlaybackControllerId = this.m_View.GetController().GetControllerId();
            this.m_PluginInstance.PostMessage(msg);
        }
    }

    @Override
    public void OnMessage(Message msg) {
        super.OnMessage(msg);
        switch (msg.m_MessageId) {
            case "SetBackgroundImage": {
                this.GetOverviewView().SetBackgroundImage(msg.m_StringData);
                break;
            }
            case "SetSecondaryBackgroundImage": {
                this.GetOverviewView().SetSecondaryBackgroundImage(msg.m_StringData);
            }
        }
    }
}

