/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin;

import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.controller.LinkedListController;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;

public abstract class CommandPanel
extends BorderPane {
    private static final long serialVersionUID = 1L;
    protected LinkedListController m_Controller = null;
    protected GridPane m_ButtonPanel;
    protected Button m_ButtonExecute;
    protected Button m_ButtonUndo;
    protected Button m_ButtonRedo;

    public CommandPanel(LinkedListController controller) {
        this.setOpacity(1.0);
        this.m_Controller = controller;
        this.m_ButtonExecute = new Button("Execute");
        this.m_ButtonUndo = new Button("Undo");
        this.m_ButtonRedo = new Button("Redo");
        this.m_ButtonExecute.setId("execute");
        this.m_ButtonUndo.setId("undo");
        this.m_ButtonRedo.setId("redo");
        this.m_ButtonExecute.setOnAction((EventHandler)controller);
        this.m_ButtonUndo.setOnAction((EventHandler)controller);
        this.m_ButtonRedo.setOnAction((EventHandler)controller);
        this.m_ButtonUndo.setDisable(true);
        this.m_ButtonRedo.setDisable(true);
        this.m_ButtonPanel = new GridPane();
        ColumnConstraints col1 = new ColumnConstraints();
        col1.setPercentWidth(50.0);
        ColumnConstraints col2 = new ColumnConstraints();
        col2.setPercentWidth(50.0);
        this.m_ButtonPanel.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2});
        this.m_ButtonPanel.setOpacity(1.0);
        this.setBottom((Node)this.m_ButtonPanel);
    }

    public void enableUndo(boolean enabled) {
        this.m_ButtonUndo.setDisable(!enabled);
    }

    public void enableRedo(boolean enabled) {
        this.m_ButtonRedo.setDisable(!enabled);
    }

    public void enableExecute(boolean enabled) {
        this.m_ButtonExecute.setDisable(!enabled);
        if (enabled) {
            this.focusCommandInput();
        }
    }

    public abstract String getText();

    public abstract void setText(String var1);

    public abstract void showTemplates();

    public abstract void restoreCommandText();

    public abstract void OnCommandTextAccepted();

    public abstract void focusCommandInput();
}

