/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin;

import edu.uic.cs.nlp.chiqat.framework.messages.LogMsg;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.CommandPanel;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.ITextPasteHandler;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.TextAreaEx;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.controller.LinkedListController;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.parser.IListParser;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.parser.ParseException;
import ilist.statement.Block;
import ilist.statement.Statement;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;

public class CommandPanelEditor
extends CommandPanel {
    private static final long serialVersionUID = 1L;
    private TextAreaEx m_TextArea = new TextAreaEx();
    private Block m_Block;
    private String m_PreviousCommandText;

    public CommandPanelEditor(LinkedListController controller) {
        super(controller);
        this.m_TextArea.setPrefHeight(200.0);
        this.m_TextArea.SetOnPaste(new ITextPasteHandler(){

            @Override
            public void OnPaste(String str) {
                CommandPanelEditor.this.m_Controller.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Command Editor Paste", false, str);
            }
        });
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)this.m_TextArea);
        scrollPane.setPrefHeight(200.0);
        this.setCenter((Node)scrollPane);
        this.m_ButtonExecute.setId("executeBlock");
        this.m_ButtonPanel.add((Node)this.m_ButtonUndo, 0, 0);
        this.m_ButtonPanel.add((Node)this.m_ButtonExecute, 1, 0);
        this.m_ButtonUndo.setMaxWidth(Double.MAX_VALUE);
        this.m_ButtonExecute.setMaxWidth(Double.MAX_VALUE);
    }

    @Override
    public String getText() {
        return this.m_TextArea.getText();
    }

    @Override
    public void setText(String text) {
        this.m_TextArea.setText(text == null ? "" : text);
    }

    @Override
    public void restoreCommandText() {
        this.m_TextArea.setText(this.m_PreviousCommandText == null ? "" : this.m_PreviousCommandText);
    }

    @Override
    public void showTemplates() {
    }

    public void parse() {
        this.m_Block = null;
        IListParser.initParser(this.m_TextArea.getText());
        try {
            this.m_Block = IListParser.Start();
        }
        catch (ParseException e) {
            System.out.println("Sorry, I can't understand your command.");
        }
        if (this.m_Block != null && this.m_Block.size() == 0) {
            this.m_Block = null;
        } else if (this.m_Block != null) {
            String txt;
            this.m_PreviousCommandText = txt = this.m_Block.toString();
            this.m_TextArea.setText(txt);
        }
    }

    public Statement createStatement() {
        if (this.m_Block == null) {
            this.parse();
        }
        Block result = this.m_Block;
        this.m_Block = null;
        return result;
    }

    @Override
    public void focusCommandInput() {
    }

    @Override
    public void OnCommandTextAccepted() {
    }
}

