/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin;

import edu.uic.cs.nlp.chiqat.framework.messages.LogMsg;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.CommandPanel;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.ITextPasteHandler;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.TextFieldEx;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.controller.LinkedListController;
import ilist.statement.ConstToData;
import ilist.statement.DataToData;
import ilist.statement.Declaration;
import ilist.statement.DeleteNode;
import ilist.statement.NextToNext;
import ilist.statement.NextToVar;
import ilist.statement.NodeCreation;
import ilist.statement.NullToNext;
import ilist.statement.NullToVar;
import ilist.statement.RemoveVariable;
import ilist.statement.SimpleParser;
import ilist.statement.Statement;
import ilist.statement.VarToNext;
import ilist.statement.VarToVar;
import java.util.Vector;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;

public class CommandPanelLine
extends CommandPanel {
    private static final long serialVersionUID = 1L;
    private TextFieldEx m_InputLine = null;
    private Button m_TemplateBtn = null;
    private ContextMenu m_TemplateMenu = null;
    private SimpleParser parser = new SimpleParser();

    public CommandPanelLine(LinkedListController controller) {
        super(controller);
        this.m_InputLine = new TextFieldEx();
        this.m_InputLine.setOnAction(controller);
        this.m_InputLine.SetOnPaste(new ITextPasteHandler(){

            @Override
            public void OnPaste(String str) {
                CommandPanelLine.this.m_Controller.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Command Line Paste", false, str);
            }
        });
        this.m_InputLine.setId("executeLine");
        this.setCenter((Node)this.m_InputLine);
        this.m_TemplateBtn = new Button("Templates");
        this.m_TemplateBtn.setId("templates");
        this.m_TemplateBtn.setId("templates");
        this.m_ButtonExecute.setId("executeLine");
        this.m_TemplateBtn.setOnAction((EventHandler)controller);
        this.m_ButtonPanel.add((Node)this.m_TemplateBtn, 0, 0);
        this.m_ButtonPanel.add((Node)this.m_ButtonExecute, 1, 0);
        this.m_ButtonPanel.add((Node)this.m_ButtonUndo, 0, 1);
        this.m_ButtonPanel.add((Node)this.m_ButtonRedo, 1, 1);
        this.m_TemplateBtn.setMaxWidth(Double.MAX_VALUE);
        this.m_ButtonExecute.setMaxWidth(Double.MAX_VALUE);
        this.m_ButtonUndo.setMaxWidth(Double.MAX_VALUE);
        this.m_ButtonRedo.setMaxWidth(Double.MAX_VALUE);
        this.m_TemplateMenu = new ContextMenu();
        Vector<Statement> sv = new Vector<Statement>();
        sv.add(new Declaration("?"));
        sv.add(new NodeCreation("?"));
        sv.add(new NullToVar("?"));
        sv.add(new VarToVar("?", "?"));
        sv.add(new NextToVar("?", "?"));
        sv.add(new ConstToData("?", "?"));
        sv.add(new DataToData("?", "?"));
        sv.add(new NullToNext("?"));
        sv.add(new VarToNext("?", "?"));
        sv.add(new NextToNext("?", "?"));
        sv.add(new DeleteNode("?"));
        sv.add(new RemoveVariable("?"));
        for (Statement s : sv) {
            String template = s.toString();
            MenuItem menuItem = new MenuItem(template);
            menuItem.setOnAction((EventHandler)controller);
            menuItem.setId("template:" + template);
            this.m_TemplateMenu.getItems().add((Object)menuItem);
        }
    }

    @Override
    public String getText() {
        return this.m_InputLine.getText();
    }

    @Override
    public void setText(String text) {
        this.m_InputLine.setText(text);
    }

    @Override
    public void restoreCommandText() {
    }

    @Override
    public void showTemplates() {
        this.m_TemplateMenu.show((Node)this.m_InputLine, Side.LEFT, 0.0, 0.0);
    }

    @Override
    public void focusCommandInput() {
        this.m_InputLine.requestFocus();
    }

    @Override
    public void OnCommandTextAccepted() {
        this.setText("");
    }
}

