/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin;

import edu.uic.cs.nlp.chiqat.lessontoolbox.LessonController;
import edu.uic.cs.nlp.chiqat.lessontoolbox.LessonView;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.ListPanel;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.OperationPanel;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.controller.LinkedListController;
import ilist.model.LinkedListModel;
import ilist.model.StateSpace;
import ilist.problem.Problem;
import ilist.problem.ProblemSet;
import ilist.problem.Scenario;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;

public class LinkedListView
extends LessonView {
    private LinkedListModel m_Model = null;
    private ProblemSet problems = null;
    private GridPane m_ListPanelContainer;
    private OperationPanel m_OperationPanel;
    private Vector<ListPanel> listPanels;

    @Override
    public boolean Init() {
        super.Init((LessonController)this.m_Controller, (LessonController)this.m_Controller);
        this.m_OperationPanel = new OperationPanel((LinkedListController)this.m_Controller);
        this.m_OperationPanel.setMinWidth(200.0);
        this.m_OperationPanel.setPrefWidth(200.0);
        this.m_OperationPanel.setMaxWidth(200.0);
        this.m_ListPanelContainer = new GridPane();
        this.m_ListPanelContainer.setStyle("-fx-background-color: CCEECC;");
        this.m_ListPanelContainer.getColumnConstraints().clear();
        ColumnConstraints lpContainerCol1 = new ColumnConstraints();
        lpContainerCol1.setPercentWidth(100.0);
        this.m_ListPanelContainer.getColumnConstraints().add((Object)lpContainerCol1);
        this.listPanels = new Vector();
        this.AddInputEnabledControl((Node)this.m_ListPanelContainer);
        this.AddInputEnabledControl((Node)this.m_OperationPanel.commandPanel);
        this.SetPrimaryPaneContent((Node)this.m_ListPanelContainer);
        this.SetSecondaryPaneContent((Node)this.m_OperationPanel);
        ArrayList<String> pIds = new ArrayList<String>();
        for (Problem p : this.problems) {
            pIds.add(p.getId());
        }
        this.m_ControlPanel.SetProblems(pIds);
        return true;
    }

    public void SetProblemSet(ProblemSet p) {
        this.problems = p;
    }

    public Class<?> commandPanelClass() {
        return this.m_OperationPanel.commandPanelClass();
    }

    private void setNodeInitLocations() {
        Vector<Scenario> scenarios = this.m_Model.getProblem().getScenarios();
        int i = 0;
        while (i < scenarios.size()) {
            Map<String, Point> locations = scenarios.elementAt(i).getInitLocations();
            this.listPanels.elementAt(i).SetNodeLocations(locations);
            ++i;
        }
    }

    public void SetBackgroundImage(String imagePath) {
        for (ListPanel lp : this.listPanels) {
            lp.SetBackgroundImage(imagePath);
        }
    }

    private void updateListPanelView() {
        int numScenarios = this.m_Model.getStateSpaces().size();
        int numPanels = this.listPanels.size();
        if (numScenarios != this.listPanels.size()) {
            this.listPanels.clear();
            numPanels = 0;
            this.m_ListPanelContainer.getChildren().clear();
            this.m_ListPanelContainer.getRowConstraints().clear();
            while (numPanels < numScenarios) {
                ListPanel lp = new ListPanel(0, this.m_Model.getStateSpaces().elementAt(++numPanels - 1), this.m_DataDir);
                lp.SetController((LessonController)this.m_Controller);
                lp.setStyle(String.valueOf(lp.getStyle()) + ";-fx-border-width: 1;-fx-border-color: black;-fx-border-style: solid;");
                this.listPanels.add(lp);
                lp.SetBackgroundImage("Resources/LinkedList/StandardBackground.png");
                RowConstraints lpContainerRow = new RowConstraints();
                lpContainerRow.setPercentHeight((double)(100 / numScenarios));
                this.m_ListPanelContainer.getRowConstraints().add((Object)lpContainerRow);
                this.m_ListPanelContainer.add((Node)lp, 0, numPanels - 1);
            }
            if (numScenarios > 1) {
                int i = 0;
                while (i < numScenarios) {
                    ListPanel lp = this.listPanels.elementAt(i);
                    lp.SetScenarioLabel(Integer.toString(i + 1));
                    ++i;
                }
            } else if (numScenarios == 1) {
                this.listPanels.firstElement().SetScenarioLabel(null);
            }
        }
        Vector<StateSpace> ss = this.m_Model.getStateSpaces();
        int n = ss.size();
        int i = 0;
        while (i < n) {
            StateSpace s = ss.elementAt(i);
            ListPanel lp = this.listPanels.elementAt(i);
            lp.SyncToSpace(s);
            ++i;
        }
    }

    public String getCommandText() {
        return this.m_OperationPanel.getCommandText();
    }

    public void setCommandText(String text) {
        this.m_OperationPanel.setCommandText(text);
    }

    public void restoreCommandText() {
        this.m_OperationPanel.restoreCommandText();
    }

    public void showTemplates() {
        this.m_OperationPanel.showTemplates();
    }

    public void enableUndo(boolean enabled) {
        this.m_OperationPanel.enableUndo(enabled);
    }

    public void enableRedo(boolean enabled) {
        this.m_OperationPanel.enableRedo(enabled);
    }

    public void enableExecute(boolean enabled) {
        this.m_OperationPanel.enableExecute(enabled);
    }

    public String getCommandInterfaceType() {
        return this.m_OperationPanel.getCommandInterfaceType();
    }

    public void SetModel(LinkedListModel model) {
        Problem prob;
        if (model != null && (this.m_Model == null || this.m_Model.getProblem() != model.getProblem()) && (prob = model.getProblem()) != null) {
            this.m_ScratchPanel.SetText(prob.getText(), 0, 0);
            this.m_OperationPanel.setCommandInterface(model.getProblem().getCommandInterface());
            this.m_OperationPanel.setCommandText(null);
        }
        this.m_Model = model;
        this.m_OperationPanel.updateView(model.getOperationSequence());
        this.updateListPanelView();
    }

    public void rearrangeContent() {
        this.setNodeInitLocations();
    }

    @Override
    public void HighlightNode(String nodeId, boolean bSet, boolean bPulse, boolean bSize, boolean bBrightness) {
        super.HighlightNode(nodeId, bSet, bPulse, bSize, bBrightness);
        for (ListPanel lp : this.listPanels) {
            if (!lp.ContainsNodeText(nodeId)) continue;
            lp.HighlightNodeByText(nodeId, bSet, bPulse, bSize, bBrightness);
        }
    }

    public void SetNodePositionByValue(String nodeVal, int iPanelId, int iX, int iY) {
        if (iPanelId >= 0 && iPanelId < this.listPanels.size()) {
            ListPanel panel = this.listPanels.get(iPanelId);
            panel.SetNodePositionByValue(nodeVal, iX, iY);
        } else {
            int i = 0;
            while (i < this.listPanels.size()) {
                ListPanel panel = this.listPanels.get(i);
                if (panel != null) {
                    panel.SetNodePositionByValue(nodeVal, iX, iY);
                }
                ++i;
            }
        }
    }

    public void OnCommandTextAccepted() {
        this.m_OperationPanel.OnCommandTextAccepted();
    }
}

