/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin;

import edu.uic.cs.nlp.chiqat.framework.messages.LogMsg;
import edu.uic.cs.nlp.chiqat.lessontoolbox.LessonController;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.PluginInstance;
import edu.uic.cs.nlp.toolbox.MiscFuncs;
import edu.uic.cs.nlp.toolbox.Rect;
import edu.uic.cs.nlp.ui.graph.Connector;
import edu.uic.cs.nlp.ui.graph.FPoint;
import edu.uic.cs.nlp.ui.graph.FRect;
import edu.uic.cs.nlp.ui.graph.FxGraphComponentInfo;
import edu.uic.cs.nlp.ui.graph.FxGraphCtrl;
import edu.uic.cs.nlp.ui.graph.FxGraphNode;
import edu.uic.cs.nlp.ui.graph.FxGraphNodeDef;
import edu.uic.cs.nlp.ui.graph.GraphEventType;
import edu.uic.cs.nlp.ui.graph.IFxGraphEventHandler;
import edu.uic.cs.nlp.ui.graph.ImageCache;
import edu.uic.cs.nlp.ui.graph.NodeConnection;
import ilist.model.GNode;
import ilist.model.StateSpace;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class ListPanel
extends FxGraphCtrl
implements IFxGraphEventHandler {
    private DirectedGraph<GNode, DefaultEdge> m_Graph = null;
    private HashMap<GNode, FxGraphNode> m_Widgets = new HashMap();
    private HashMap<String, Point> m_NodeLocations = new HashMap();
    private static final FPoint ConnectionPos_VarOut = new FPoint(0.97f, 0.5f);
    private static final FPoint ConnectionPos_NodeIn = new FPoint(0.03f, 0.5f);
    private static final FPoint ConnectionPos_NodeOut = new FPoint(0.75f, 0.5f);
    private String m_DataDir = "";
    private LessonController m_Controller = null;
    static int s_iNodeId = 1;
    protected FxGraphComponentInfo m_SelectedComponent = null;

    public ListPanel(int iCreateFlags, StateSpace stateSpace, String dataDir) {
        super(iCreateFlags);
        this.m_DataDir = dataDir;
        ImageCache imageCache = PluginInstance.s_ImageCache;
        this.SetConnectionImage(imageCache.GetImage("file://" + dataDir + "/Resources/ConnectionArrow.png"));
        this.SetImages(imageCache.GetImage("file://" + dataDir + "/Resources/LinkedList/Node-1.png"), imageCache.GetImage("file://" + dataDir + "/Resources/LinkedList/Node-1.png"), imageCache.GetImage("file://" + dataDir + "/Resources/Connector.png"), imageCache.GetImage("file://" + dataDir + "/Resources/ConnectorSelected.png"), 0);
        this.SetImages(imageCache.GetImage("file://" + dataDir + "/Resources/LinkedList/Variable-1.png"), imageCache.GetImage("file://" + dataDir + "/Resources/LinkedList/Variable-1.png"), imageCache.GetImage("file://" + dataDir + "/Resources/Connector.png"), imageCache.GetImage("file://" + dataDir + "/Resources/ConnectorSelected.png"), 1);
        this.SetGraphEventHandler(this);
    }

    public void SetController(LessonController controller) {
        this.m_Controller = controller;
    }

    public void SetScenarioLabel(String string) {
    }

    public void SetBackgroundImage(String path) {
        if (!MiscFuncs.IsAbsolutePath(path)) {
            path = "file://" + this.m_DataDir + "/" + path;
        }
        ImageCache imageCache = PluginInstance.s_ImageCache;
        BackgroundImage img = new BackgroundImage(imageCache.GetImage(path), null, null, null, null);
        Background bkg = new Background(new BackgroundImage[]{img});
        this.setBackground(bkg);
    }

    public void SyncToSpace(StateSpace space) {
        FxGraphNodeDef w;
        FxGraphNode ctrl;
        this.m_Graph = space.getGraph();
        this.SaveNodeLocations();
        List<FxGraphNode> oldNodes = this.GetNodeListCopy();
        ArrayList<GNode> oldWidgets = new ArrayList<GNode>();
        ArrayList<GNode> allGNodes = new ArrayList<GNode>();
        for (GNode gNode : space.getVariables()) {
            allGNodes.add(gNode);
        }
        for (GNode gNode : space.getNodes()) {
            allGNodes.add(gNode);
        }
        for (GNode gNode : space.getVariables()) {
            FxGraphNode fxGraphNode = ctrl = this.m_Widgets.containsKey(gNode) ? this.m_Widgets.get(gNode) : null;
            if (ctrl != null) continue;
            w = ListPanel.CreateListNode(gNode.getLabel(), "color:0x0000ffff", true);
            w.m_iImageSetId = 1;
            this.MoveNodeDefToFit(w, true, allGNodes);
            ctrl = this.AddGraphNode(w);
            this.m_Widgets.put(gNode, ctrl);
        }
        for (GNode gNode : space.getNodes()) {
            FxGraphNode fxGraphNode = ctrl = this.m_Widgets.containsKey(gNode) ? this.m_Widgets.get(gNode) : null;
            if (ctrl != null) continue;
            w = ListPanel.CreateListNode(gNode.getLabel(), "color:0x0000ffff", false);
            w.m_iImageSetId = 0;
            this.MoveNodeDefToFit(w, false, allGNodes);
            ctrl = this.AddGraphNode(w);
            this.m_Widgets.put(gNode, ctrl);
        }
        for (GNode gNode : allGNodes) {
            int i = 0;
            while (i < oldNodes.size()) {
                FxGraphNode ctrl2;
                FxGraphNode fxGraphNode = ctrl2 = this.m_Widgets.containsKey(gNode) ? this.m_Widgets.get(gNode) : null;
                if (oldNodes.get(i) == ctrl2) {
                    oldNodes.remove(i);
                    --i;
                }
                ++i;
            }
        }
        for (GNode gNode : this.m_Widgets.keySet()) {
            boolean bExists = false;
            for (GNode n2 : allGNodes) {
                if (gNode != n2) continue;
                bExists = true;
                break;
            }
            if (bExists) continue;
            oldWidgets.add(gNode);
        }
        for (GNode gNode : oldWidgets) {
            boolean bRemoved = false;
            for (GNode n2 : allGNodes) {
                if (gNode.toString().compareTo(n2.toString()) != 0) continue;
                FxGraphNode fxNode = this.m_Widgets.get(gNode);
                this.m_Widgets.remove(gNode);
                this.m_Widgets.put(n2, fxNode);
                oldNodes.remove((Object)fxNode);
                bRemoved = true;
                break;
            }
            if (bRemoved) continue;
            this.m_Widgets.remove(gNode);
        }
        for (FxGraphNode fxGraphNode : oldNodes) {
            this.m_Widgets.remove((Object)fxGraphNode);
            this.RemoveNode(fxGraphNode);
        }
        this.SyncNodeConnectionsToGraph();
        this.RestoreNodeLocations();
    }

    protected void MoveNodeDefToFit(FxGraphNodeDef def, boolean bIsVariable, List<GNode> allGNodes) {
        def.m_iLeft = bIsVariable ? 20 : 200;
        def.m_iTop = 30;
        boolean bFit = false;
        block0: while (!bFit) {
            bFit = true;
            for (GNode node : allGNodes) {
                FxGraphNode graphNode = this.m_Widgets.get(node);
                if (graphNode == null) continue;
                Rect rectA = new Rect();
                rectA.m_dLeft = def.m_iLeft;
                rectA.m_dTop = def.m_iTop;
                rectA.m_dRight = def.m_iLeft + def.m_iWidth;
                rectA.m_dBottom = def.m_iTop + def.m_iHeight;
                Rect rectB = new Rect();
                rectB.m_dLeft = graphNode.getLayoutX();
                rectB.m_dTop = graphNode.getLayoutY();
                rectB.m_dRight = graphNode.getLayoutX() + graphNode.getWidth();
                rectB.m_dBottom = graphNode.getLayoutY() + graphNode.getHeight();
                if (!MiscFuncs.DoRectsIntersect(rectA, rectB)) continue;
                bFit = false;
                def.m_iTop += 10;
                continue block0;
            }
        }
    }

    protected void SyncNodeConnectionsToGraph() {
        int i = 0;
        while (i < this.m_Connections.size()) {
            NodeConnection c = (NodeConnection)this.m_Connections.get(i);
            FxGraphComponentInfo srcInfo = c.m_SrcInfo;
            FxGraphComponentInfo destInfo = c.m_DestInfo;
            boolean bValid = false;
            for (DefaultEdge e : this.m_Graph.edgeSet()) {
                GNode sourceGNode = (GNode)this.m_Graph.getEdgeSource((Object)e);
                GNode targetGNode = (GNode)this.m_Graph.getEdgeTarget((Object)e);
                if (!this.m_Widgets.containsKey(sourceGNode) || !this.m_Widgets.containsKey(targetGNode)) continue;
                int iSrcNodeId = this.m_Widgets.get(sourceGNode).GetNodeId();
                int iDestNodeId = this.m_Widgets.get(targetGNode).GetNodeId();
                if (iSrcNodeId != srcInfo.m_iNodeId || iDestNodeId != destInfo.m_iNodeId) continue;
                bValid = true;
                break;
            }
            if (!bValid) {
                this.RemoveConnection(c);
            }
            ++i;
        }
        for (DefaultEdge e : this.m_Graph.edgeSet()) {
            GNode sourceGNode = (GNode)this.m_Graph.getEdgeSource((Object)e);
            GNode targetGNode = (GNode)this.m_Graph.getEdgeTarget((Object)e);
            if (!this.m_Widgets.containsKey(sourceGNode) || !this.m_Widgets.containsKey(targetGNode)) continue;
            FxGraphNode srcNode = this.m_Widgets.get(sourceGNode);
            FxGraphNode destNode = this.m_Widgets.get(targetGNode);
            if (srcNode == null || destNode == null) continue;
            this.AddConnection(new FxGraphComponentInfo(srcNode.GetNodeId(), srcNode.GetConnectorIdByTag(0)), new FxGraphComponentInfo(destNode.GetNodeId(), destNode.GetConnectorIdByTag(1)), false);
        }
    }

    public void SetNodeLocations(Map<String, Point> locations) {
        for (GNode n : this.m_Widgets.keySet()) {
            Point p = locations.get(n.getId());
            if (p == null) continue;
            this.m_Widgets.get(n).setLayoutX(p.x);
            this.m_Widgets.get(n).setLayoutY(p.y);
        }
        this.UpdateAllConnectionPositions();
    }

    private void RestoreNodeLocations() {
        this.SetNodeLocations(this.m_NodeLocations);
    }

    private void SaveNodeLocations() {
        for (GNode n : this.m_Widgets.keySet()) {
            int iX = (int)this.m_Widgets.get(n).getLayoutX();
            int iY = (int)this.m_Widgets.get(n).getLayoutY();
            this.m_NodeLocations.put(n.getId(), new Point(iX, iY));
        }
    }

    public static FxGraphNodeDef CreateListNode(String text, String style, boolean bIsVariable) {
        FxGraphNodeDef node = new FxGraphNodeDef();
        node.m_Text = text;
        node.m_iHeight = 50;
        node.m_iWidth = 75;
        node.m_iLeft = 20;
        node.m_iTop = 20;
        node.m_iNodeId = s_iNodeId++;
        node.m_Style = style;
        node.m_TextArea = new FRect(0.1f, 0.1f, 0.45f, 0.9f);
        Connector con = null;
        if (bIsVariable) {
            con = new Connector();
            con.m_Position = ConnectionPos_VarOut;
            con.m_iTag = 0;
            node.m_Connectors.add(con);
        } else {
            con = new Connector();
            con.m_Position = ConnectionPos_NodeIn;
            con.m_iTag = 1;
            node.m_Connectors.add(con);
            con = new Connector();
            con.m_Position = ConnectionPos_NodeOut;
            con.m_iTag = 0;
            node.m_Connectors.add(con);
        }
        return node;
    }

    @Override
    public void OnGraphEvent(Object sender, GraphEventType evtType, FxGraphComponentInfo info) {
        if (evtType == GraphEventType.NodeConnectorSelected) {
            if (this.m_SelectedComponent != null && info.m_iConnectorId != -1 && info.m_iNodeId != -1 && this.m_SelectedComponent.m_iConnectorId != -1 && this.m_SelectedComponent.m_iNodeId != -1) {
                this.OnConnectionAttempted(this.m_SelectedComponent, info);
            }
            this.m_SelectedComponent = new FxGraphComponentInfo(info);
        } else if (evtType != GraphEventType.NodeConnectorClicked) {
            this.m_SelectedComponent = null;
        }
    }

    private void OnConnectionAttempted(FxGraphComponentInfo src, FxGraphComponentInfo dest) {
        System.out.println("Connection attempted - (" + src.m_iNodeId + ":" + src.m_iConnectorId + ") - (" + dest.m_iNodeId + ":" + dest.m_iConnectorId + ")");
        this.AddConnection(src, dest, false);
    }

    public FxGraphNode GetNodeByText(String txt) {
        for (FxGraphNode node : this.m_Nodes) {
            if (node.GetNodeDef().m_Text.compareToIgnoreCase(txt) != 0) continue;
            return node;
        }
        return null;
    }

    public boolean ContainsNodeText(String nodeTxt) {
        return this.GetNodeByText(nodeTxt) != null;
    }

    public void HighlightNodeByText(String nodeTxt, boolean bSet, boolean bPulse, boolean bSize, boolean bBrightness) {
        FxGraphNode node = this.GetNodeByText(nodeTxt);
        node.Highlight(bSet, bPulse, bSize, bBrightness);
    }

    public void SetNodePositionByValue(String nodeVal, int iX, int iY) {
        FxGraphNode node = this.GetNodeByText(nodeVal);
        if (node != null) {
            node.setLayoutX(iX);
            node.setLayoutY(iY);
            this.UpdateAllConnectionPositions();
        }
    }

    @Override
    public void OnNodeClicked(Object sender, FxGraphComponentInfo info) {
        super.OnNodeClicked(sender, info);
        this.m_Controller.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Node Clicked", false, "" + info.m_iNodeId);
    }
}

