/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin;

import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.CommandPanel;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.CommandPanelEditor;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.CommandPanelLine;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.controller.LinkedListController;
import ilist.model.OperationSequence;
import ilist.statement.Statement;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;

public class OperationPanel
extends BorderPane {
    private static final long serialVersionUID = 1L;
    protected Label m_TestLabel = null;
    protected TextArea sequenceArea = null;
    public CommandPanel commandPanel;
    private CommandPanelLine comPanelLine;
    private CommandPanelEditor comPanelEditor;

    public OperationPanel(LinkedListController controller) {
        this.setOpacity(1.0);
        this.sequenceArea = new TextArea();
        this.sequenceArea.setEditable(false);
        this.sequenceArea.setWrapText(true);
        this.setCenter((Node)this.sequenceArea);
        this.comPanelLine = new CommandPanelLine(controller);
        this.comPanelEditor = new CommandPanelEditor(controller);
        this.commandPanel = this.comPanelLine;
        this.setBottom((Node)this.commandPanel);
    }

    public void updateView(OperationSequence sequence) {
        this.sequenceArea.setText("");
        for (Statement s : sequence.getStatements()) {
            if (s.GetTag() != -1) continue;
            this.sequenceArea.setText(String.valueOf(this.sequenceArea.getText()) + s.toString() + "\n");
        }
    }

    public void setCommandInterface(String panelType) {
        if ("line".equals(panelType)) {
            this.commandPanel = this.comPanelLine;
        } else if ("editor".equals(panelType)) {
            this.commandPanel = this.comPanelEditor;
        }
        this.setBottom((Node)this.commandPanel);
    }

    public String getCommandInterfaceType() {
        if (this.commandPanel == this.comPanelLine) {
            return "line";
        }
        if (this.commandPanel == this.comPanelEditor) {
            return "editor";
        }
        return "?";
    }

    public String getCommandText() {
        return this.commandPanel.getText();
    }

    public void setCommandText(String text) {
        this.commandPanel.setText(text);
    }

    public void restoreCommandText() {
        this.commandPanel.restoreCommandText();
    }

    public void showTemplates() {
        if (this.commandPanel == this.comPanelLine) {
            this.comPanelLine.showTemplates();
        }
    }

    public Class<?> commandPanelClass() {
        return ((Object)((Object)this.commandPanel)).getClass();
    }

    public void enableUndo(boolean enabled) {
        this.commandPanel.enableUndo(enabled);
    }

    public void enableRedo(boolean enabled) {
        this.commandPanel.enableRedo(enabled);
    }

    public void enableExecute(boolean enabled) {
        this.commandPanel.enableExecute(enabled);
    }

    public void OnCommandTextAccepted() {
        this.commandPanel.OnCommandTextAccepted();
    }
}

