/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.constraints;

import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.constraints.Constraint;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.constraints.GCDeleted;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.constraints.GCGarbage;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.constraints.GCLoop;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.constraints.GCLost;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.constraints.GCPointer;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.constraints.GCUndefined;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.constraints.GCValues;
import ilist.model.LinkedListModel;
import ilist.problem.Problem;
import java.util.Vector;

public class Evaluator {
    private static Evaluator instance;
    private Vector<Constraint> constraints = new Vector();
    private Vector<Constraint> relevant = new Vector();
    private Vector<Constraint> satisfied = new Vector();
    private Vector<Constraint> unsatisfied = new Vector();

    private Evaluator() {
        this.constraints.add(new GCValues());
        this.constraints.add(new GCLoop());
        this.constraints.add(new GCUndefined());
        this.constraints.add(new GCGarbage());
        this.constraints.add(new GCDeleted());
        this.constraints.add(new GCLost());
        this.constraints.add(new GCPointer());
    }

    public static Evaluator getInstance() {
        if (instance == null) {
            instance = new Evaluator();
        }
        return instance;
    }

    public boolean evaluate(LinkedListModel model) {
        if (model.getProblem() == Problem.EMPTY) {
            return true;
        }
        this.relevant.clear();
        this.satisfied.clear();
        this.unsatisfied.clear();
        for (Constraint c : this.constraints) {
            if (!c.isRelevant(model)) continue;
            this.relevant.add(c);
            if (c.isSatisfied(model)) {
                this.satisfied.add(c);
                continue;
            }
            this.unsatisfied.add(c);
        }
        return this.unsatisfied.isEmpty();
    }

    public Vector<String> feedback() {
        Vector<String> v = new Vector<String>();
        for (Constraint c : this.unsatisfied) {
            v.add(c.feedback());
        }
        return v;
    }
}

