/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.constraints;

import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.constraints.GMultiListConstraint;
import ilist.misc.Util;
import ilist.model.GNode;
import ilist.model.LinkedListModel;
import ilist.model.StateSpace;
import java.util.List;
import java.util.Vector;

class GCPointer
extends GMultiListConstraint {
    private Vector<Vector<String>> pointers = new Vector();
    private Vector<Vector<String>> badPointers = new Vector();

    public GCPointer() {
        this.pointers = new Vector();
        this.badPointers = new Vector();
        int i = 0;
        while (i < 4) {
            this.pointers.add(new Vector());
            this.badPointers.add(new Vector());
            ++i;
        }
    }

    @Override
    public boolean isRelevant(LinkedListModel model, int scenario) {
        if (!model.isFinal()) {
            return false;
        }
        boolean y = false;
        this.pointers.elementAt(scenario).clear();
        this.badPointers.elementAt(scenario).clear();
        for (String pointer : model.getProblem().getIdealSolution().getImportantPointers()) {
            if (model.getStateSpaces().elementAt(scenario).findVariable(pointer) == null) continue;
            y = true;
            this.pointers.elementAt(scenario).add(pointer);
        }
        return y;
    }

    @Override
    public boolean isSatisfied(LinkedListModel model, int scenario) {
        boolean y = true;
        StateSpace studentSpace = model.getStateSpaces().elementAt(scenario);
        StateSpace idealSpace = model.getProblem().getIdealSolution().getStateSpaces().elementAt(scenario);
        for (String pointer : this.pointers.elementAt(scenario)) {
            GNode n1 = studentSpace.findNext(studentSpace.findVariable(pointer));
            GNode n2 = idealSpace.findNext(idealSpace.findVariable(pointer));
            if (!(n1 == null && n2 != null || n1 != null && n2 == null) && (n1 == null || n2 == null || n1.equals(n2))) continue;
            y = false;
            this.badPointers.elementAt(scenario).add(pointer);
        }
        return y;
    }

    @Override
    public String feedback(int scenario) {
        int n = this.badPointers.elementAt(scenario).size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return "Variable " + this.badPointers.elementAt(scenario).firstElement() + " points to something wrong.";
        }
        return "Variables " + Util.englishList((List<String>)this.badPointers.elementAt(scenario)) + " point to something wrong.";
    }
}

