/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.constraints;

import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.constraints.Constraint;
import ilist.model.LinkedListModel;

abstract class GMultiListConstraint
extends Constraint {
    GMultiListConstraint() {
    }

    public abstract boolean isRelevant(LinkedListModel var1, int var2);

    public abstract boolean isSatisfied(LinkedListModel var1, int var2);

    public abstract String feedback(int var1);

    @Override
    public boolean isRelevant(LinkedListModel model) {
        if (!model.isFinal()) {
            return false;
        }
        this.numScenarios = model.getStateSpaces().size();
        boolean y = true;
        int i = 0;
        while (i < this.numScenarios) {
            y = this.isRelevant(model, i) && y;
            ++i;
        }
        return y;
    }

    @Override
    public boolean isSatisfied(LinkedListModel model) {
        boolean y = true;
        int i = 0;
        while (i < this.numScenarios) {
            y = this.isSatisfied(model, i) && y;
            ++i;
        }
        return y;
    }

    @Override
    public String feedback() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.numScenarios) {
            String sFeedback = this.feedback(i);
            if (sFeedback != null) {
                if (this.numScenarios > 1) {
                    sb.append("In scenario #" + (i + 1) + ", ");
                }
                sb.append(String.valueOf(sFeedback) + "\n");
            }
            ++i;
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
        return null;
    }
}

