/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.constraints;

import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.constraints.GMultiListConstraint;
import ilist.misc.Util;
import ilist.model.LinkedListModel;
import ilist.model.StateSpace;
import java.util.List;
import java.util.Vector;

abstract class GSSListConstraint
extends GMultiListConstraint {
    protected Vector<Vector<String>> heads = new Vector();
    protected Vector<Vector<String>> badHeads = new Vector();

    public GSSListConstraint() {
        this.heads = new Vector();
        this.badHeads = new Vector();
        int i = 0;
        while (i < 4) {
            this.heads.add(new Vector());
            this.badHeads.add(new Vector());
            ++i;
        }
    }

    @Override
    public boolean isRelevant(LinkedListModel model, int scenario) {
        this.heads.elementAt(scenario).clear();
        this.badHeads.elementAt(scenario).clear();
        if (!model.isFinal()) {
            return false;
        }
        boolean y = false;
        StateSpace studentSolutionSpace = model.getStateSpaces().elementAt(scenario);
        for (String h : model.getProblem().getIdealSolution().getImportantHeads()) {
            if (studentSolutionSpace.findVariable(h) == null) continue;
            y = true;
            this.heads.elementAt(scenario).add(h);
        }
        return y;
    }

    protected String feedback(String singularEnd, String pluralEnd, int scenario) {
        int n = this.badHeads.elementAt(scenario).size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return "The list " + this.badHeads.elementAt(scenario).firstElement() + " " + singularEnd;
        }
        return "The lists " + Util.englishList((List<String>)this.badHeads.elementAt(scenario)) + " " + pluralEnd;
    }
}

