/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.controller;

import edu.uic.cs.nlp.chiqat.framework.Message;
import edu.uic.cs.nlp.chiqat.framework.messages.LogMsg;
import edu.uic.cs.nlp.chiqat.framework.messages.PlayWoeMsg;
import edu.uic.cs.nlp.chiqat.framework.messages.StopWoeMsg;
import edu.uic.cs.nlp.chiqat.framework.messages.User;
import edu.uic.cs.nlp.chiqat.lessontoolbox.IInputInterface;
import edu.uic.cs.nlp.chiqat.lessontoolbox.LessonController;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.LinkedListView;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.PluginInstance;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.constraints.Evaluator;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback.FeedbackManager;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.logger.Logger;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.parser.IListParser;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.parser.ParseException;
import edu.uic.cs.nlp.toolbox.MiscFuncs;
import ilist.misc.Constants;
import ilist.misc.Parameters;
import ilist.model.LinkedListModel;
import ilist.model.MultiModel;
import ilist.problem.Problem;
import ilist.problem.ProblemSet;
import ilist.statement.Block;
import ilist.statement.SimpleParser;
import ilist.statement.Statement;
import ilist.supermodel.ActionNode;
import ilist.supermodel.SuperModel;
import ilist.supermodel.SuperModelFactory;
import ilist.supermodel.SuperModelSet;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;

public class LinkedListController
extends LessonController
implements EventHandler<ActionEvent>,
IInputInterface {
    public static final String COM_PROACTIVE_FEEDBACK = "proactive-feedback";
    private boolean m_bModelOnly = false;
    private MultiModel m_MultiModel;
    private SuperModelSet m_SuperModels;
    private FeedbackManager m_FeedbackManager;
    private Logger m_Logger;
    private SimpleParser m_Parser = new SimpleParser();

    public LinkedListController(PluginInstance owner, String controllerId) {
        this(owner, controllerId, null, false);
    }

    public LinkedListController(PluginInstance owner, String controllerId, User user, boolean modelOnly) {
        super(owner, controllerId);
        this.m_User = user;
        this.m_bModelOnly = modelOnly;
        this.m_MultiModel = new MultiModel();
        this.m_SuperModels = SuperModelFactory.loadSuperModelSet(SuperModelFactory.class.getResourceAsStream("data/supermodels.obj.gz"));
    }

    @Override
    public void Destroy() {
        if (this.m_Logger != null) {
            this.m_Logger.Close();
        }
        if (this.m_FeedbackManager != null) {
            this.m_FeedbackManager.Destroy();
        }
    }

    @Override
    public void SetUser(User user) {
        super.SetUser(user);
        this.InitialiseModel();
    }

    public void RegisterView(LinkedListView v) {
        super.RegisterView(v);
        this.m_View = v;
    }

    protected void InitialiseModel() {
        SuperModel superMod = this.m_SuperModels.getSuperModel(this.m_MultiModel.getProblem());
        superMod.start(this.m_User.getSession(), System.currentTimeMillis(), this.m_MultiModel.getCurrentModel());
        if (!this.m_bModelOnly) {
            this.GetLinkListView().SetModel(this.m_MultiModel.getCurrentModel());
            this.GetLinkListView().SetProblemSet(ProblemSet.getInstance());
            this.updateView();
            this.m_Logger = new Logger(Parameters.getLogServer(), this.m_User.getId(), this.m_User.getSession());
            this.m_FeedbackManager = new FeedbackManager(this.m_User, this.GetLinkListView(), this.m_Logger, this);
            this.m_FeedbackManager.display("", Constants.WELCOME_MESSAGE);
        }
    }

    @Override
    public void handle(ActionEvent e) {
        String com = "";
        if (e.getSource() instanceof Button) {
            com = ((Button)e.getSource()).getId();
        } else if (e.getSource() instanceof MenuItem) {
            MenuItem item = (MenuItem)e.getSource();
            com = item.getId();
        } else if (e.getSource() instanceof TextField) {
            TextField tf = (TextField)e.getSource();
            com = tf.getId();
        }
        long timestamp = System.currentTimeMillis();
        String session = this.m_User.getSession();
        Problem currentProblem = this.m_MultiModel.getCurrentModel().getProblem();
        this.m_Logger.log(currentProblem.getId(), "event", com);
        if (com.startsWith("setProblem:")) {
            String newPid = com.replaceAll("setProblem:", "");
            this.OnSetProblem(newPid);
        } else if (com.equals("restart")) {
            this.OnRestart();
        } else if (com.equals("done")) {
            this.OnSubmit();
        } else if (com.startsWith("execute") || com.startsWith("executeLine")) {
            String currentProblemID = currentProblem.getId();
            String commandText = this.GetLinkListView().getCommandText();
            this.GetLinkListView().OnCommandTextAccepted();
            if (currentProblemID != null && commandText != null) {
                this.m_Logger.log(currentProblemID, "raw command:" + this.GetLinkListView().commandPanelClass(), commandText);
                if (commandText.length() > 0) {
                    this.ExecuteStatement(commandText);
                }
            }
        } else if (com.equals("undo")) {
            this.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Undo Operation Requested", false);
            this.Undo(timestamp);
        } else if (com.equals("redo")) {
            this.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Redo Operation Requested", false);
            this.Redo(timestamp);
        } else if (com.equals("templates")) {
            this.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Template Help Requested", false);
            this.GetLinkListView().showTemplates();
        } else if (com.startsWith("template:")) {
            this.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Template Help Item Selected", false, com.substring(9));
            this.GetLinkListView().setCommandText(com.substring(9));
        } else if (com.equals("problems")) {
            this.GetLinkListView().showProblemMenu();
        } else if (com.equals("example")) {
            this.OnExample();
        }
    }

    @Override
    public void OnSetProblem(String newPid) {
        Problem currentProblem = this.m_MultiModel.getCurrentModel().getProblem();
        long timestamp = System.currentTimeMillis();
        String session = this.m_User.getSession();
        this.StopWoe();
        Problem previousProblem = currentProblem;
        currentProblem = ProblemSet.getInstance().get(newPid);
        this.m_MultiModel.setProblem(currentProblem);
        this.m_SuperModels.getSuperModel(currentProblem).start(session, timestamp, this.m_MultiModel.getCurrentModel());
        this.updateView();
        this.rearrangeView();
        String message = !currentProblem.equals(previousProblem) ? "Starting problem " + newPid + "." : "Restarting problem " + newPid + ".";
        this.m_FeedbackManager.display(newPid, message);
        this.m_FeedbackManager.proactiveFeedbackDelay(this.m_SuperModels.getSuperModel(currentProblem), session);
    }

    @Override
    public void OnExample() {
        super.OnExample();
        Problem currentProblem = this.m_MultiModel.getCurrentModel().getProblem();
        this.CreateBlankProblem();
        String woePath = currentProblem.GetWoePath();
        if (!woePath.isEmpty()) {
            String woeDir = String.valueOf(this.m_PluginInstance.m_AppDataStore.GetValue("DataDir")) + "/Resources/LinkedList/Woe/";
            String woeFile = String.valueOf(woeDir) + woePath;
            PlayWoeMsg msg = new PlayWoeMsg();
            msg.m_PlaybackInstanceId = this.m_PluginInstance.m_BluePrint.CFG_PluginInstanceId;
            msg.m_PlaybackControllerId = this.m_View.GetController().GetControllerId();
            msg.m_FilePath = woeFile;
            msg.m_MessageId = "PlayWoe";
            this.m_PluginInstance.PostMessage(msg);
        }
    }

    public void StopWoe() {
        StopWoeMsg msg = new StopWoeMsg();
        msg.m_PlaybackInstanceId = this.m_PluginInstance.m_BluePrint.CFG_PluginInstanceId;
        msg.m_PlaybackControllerId = this.m_View.GetController().GetControllerId();
        msg.m_MessageId = "StopWoe";
        this.m_PluginInstance.PostMessage(msg);
    }

    @Override
    public void OnTutorial() {
        super.OnTutorial();
        this.CreateBlankProblem();
        String tutorialName = this.m_User.GetUserControlInfo().IsWoeEnabled() ? "Tutorial-Woe1.woe" : "Tutorial-NoWoe1.woe";
        String tutorialPath = String.valueOf(this.m_PluginInstance.m_AppDataStore.GetValue("DataDir")) + "/Resources/LinkedList/Tutorial/" + tutorialName;
        PlayWoeMsg msg = new PlayWoeMsg();
        msg.m_PlaybackInstanceId = this.m_PluginInstance.m_BluePrint.CFG_PluginInstanceId;
        msg.m_PlaybackControllerId = this.m_View.GetController().GetControllerId();
        msg.m_FilePath = tutorialPath;
        msg.m_MessageId = "PlayWoe";
        this.m_PluginInstance.PostMessage(msg);
    }

    @Override
    public void OnSubmit() {
        super.OnSubmit();
        Problem currentProblem = this.m_MultiModel.getCurrentModel().getProblem();
        LinkedListModel currentModel = this.m_MultiModel.getCurrentModel();
        currentModel.setFinal(true);
        boolean success = Evaluator.getInstance().evaluate(currentModel);
        this.m_FeedbackManager.evaluatorFeedback(currentModel, Evaluator.getInstance().feedback());
        if (success) {
            this.GetLinkListView().enableDone(false);
            this.m_User.setSolvedProblem(currentProblem.getId());
            this.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Solution Submitted", false, "Correct");
        } else {
            this.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Solution Submitted", false, "Incorrect");
        }
        currentModel.setFinal(false);
    }

    @Override
    public void OnRestart() {
        super.OnRestart();
        Problem currentProblem = this.m_MultiModel.getCurrentModel().getProblem();
        long timestamp = System.currentTimeMillis();
        String session = this.m_User.getSession();
        this.m_MultiModel.setProblem(currentProblem);
        this.m_SuperModels.getSuperModel(currentProblem).start(session, timestamp, this.m_MultiModel.getCurrentModel());
        this.updateView();
        this.rearrangeView();
        this.m_FeedbackManager.display(currentProblem.getId(), "Restarting problem " + currentProblem.getId() + ".");
        this.m_FeedbackManager.proactiveFeedbackDelay(this.m_SuperModels.getSuperModel(currentProblem), session);
    }

    @Override
    protected void Redo(long timestamp) {
        super.Redo(timestamp);
        Problem currentProblem = this.m_MultiModel.getCurrentModel().getProblem();
        String session = this.m_User.getSession();
        this.m_MultiModel.redo();
        this.m_SuperModels.getSuperModel(currentProblem).redo(session, timestamp);
        this.updateView();
    }

    @Override
    protected void Undo(long timestamp) {
        super.Undo(timestamp);
        Problem currentProblem = this.m_MultiModel.getCurrentModel().getProblem();
        String session = this.m_User.getSession();
        this.m_MultiModel.undo();
        this.m_SuperModels.getSuperModel(currentProblem).undo(session, timestamp);
        this.updateView();
    }

    @Override
    public void CreateBlankProblem(int iStateSpaces) {
        this.m_MultiModel.Reset(iStateSpaces);
        this.updateView();
        this.rearrangeView();
    }

    @Override
    public void ExecuteStatement(String commandText) {
        if (commandText.startsWith("::")) {
            this.ExecuteSpecialCommand(commandText);
        } else {
            super.ExecuteStatement(commandText);
            this.ExecuteOperation(commandText, true);
        }
    }

    protected void ExecuteOperation(String operationStr, boolean bRecord) {
        this.ExecuteOperation(operationStr, bRecord, -1);
    }

    protected void ExecuteOperation(String operationStr, boolean bRecord, int iStateSpaceId) {
        Statement st = this.ParseToStatement(operationStr);
        Problem currentProblem = this.m_MultiModel.getCurrentModel().getProblem();
        String currentProblemID = currentProblem.getId();
        String session = this.m_User.getSession();
        long timestamp = System.currentTimeMillis();
        if (st != null) {
            this.m_Logger.log(currentProblemID, "parsed command", st.toString());
            String error = this.m_MultiModel.execute(st, bRecord, iStateSpaceId);
            if (error == null) {
                this.m_Logger.log(currentProblemID, "executed command", st.toString());
                this.updateView();
                SuperModel sm = this.m_SuperModels.getSuperModel(currentProblem);
                sm.add(session, timestamp, new ActionNode(st), this.m_MultiModel.getCurrentModel());
                this.m_FeedbackManager.reactiveFeedback(currentProblemID, sm);
                this.m_FeedbackManager.proactiveFeedbackDelay(this.m_SuperModels.getSuperModel(currentProblem), session);
            } else {
                this.m_FeedbackManager.executionError(currentProblemID, error);
            }
        } else {
            this.m_Logger.log(currentProblemID, "parse failed", "parse failed");
            this.m_FeedbackManager.parseError(currentProblemID, operationStr, this.m_MultiModel.getCurrentModel());
        }
    }

    private Statement ParseToStatement(String operationStr) {
        Statement st = null;
        if (operationStr.contains("\n")) {
            Block block = null;
            IListParser.initParser(operationStr);
            try {
                block = IListParser.Start();
            }
            catch (ParseException e) {
                System.out.println("Sorry, I can't understand your command.");
            }
            if (block != null && block.size() == 0) {
                block = null;
            } else if (block != null) {
                String txt = block.toString();
                st = block;
            }
        } else {
            st = this.m_Parser.parse(operationStr.toUpperCase());
        }
        return st;
    }

    private boolean ExecuteSpecialCommand(String commandText) {
        String strippedCmd;
        Map<String, String> args;
        boolean bSuccess = false;
        if (commandText.startsWith("::") && commandText.length() > 2 && (args = MiscFuncs.ParseQueryString(strippedCmd = commandText.substring(2, commandText.length()))).size() > 0) {
            this.ExecuteSpecialCommand(args);
            bSuccess = true;
        }
        bSuccess = false;
        return false;
    }

    private void ExecuteSpecialCommand(Map<String, String> args) {
        block26: {
            if (!args.containsKey("cmd")) break block26;
            String cmd = args.get("cmd");
            int iStateSpaceId = -1;
            if (args.containsKey("statespace")) {
                iStateSpaceId = MiscFuncs.IntTryParse(args.get("statespace"));
            }
            switch (cmd) {
                case "Print": {
                    if (!args.containsKey("msg")) break;
                    String msg = args.get("msg");
                    System.out.println("Special Comand: " + msg);
                    break;
                }
                case "SetBackgroundImage": {
                    if (!args.containsKey("path")) break;
                    String path = args.get("path");
                    this.GetLinkListView().SetBackgroundImage(path);
                    break;
                }
                case "Redo": {
                    this.Redo(System.currentTimeMillis());
                    break;
                }
                case "Undo": {
                    this.Undo(System.currentTimeMillis());
                    break;
                }
                case "Operation": {
                    if (!args.containsKey("data")) break;
                    String dataStr = args.get("data");
                    boolean bRecord = !args.containsKey("record") || args.get("record").compareToIgnoreCase("false") != 0;
                    this.ExecuteOperation(dataStr, bRecord, iStateSpaceId);
                    break;
                }
                case "MoveNode": {
                    if (!args.containsKey("x") || !args.containsKey("y")) break;
                    int iX = MiscFuncs.IntTryParse(args.get("x"));
                    int iY = MiscFuncs.IntTryParse(args.get("y"));
                    if (iX <= 0 || iY <= 0 || !args.containsKey("val")) break;
                    String nodeVal = args.get("val");
                    this.GetLinkListView().SetNodePositionByValue(nodeVal, iStateSpaceId, iX, iY);
                    break;
                }
                case "BlockOperation": {
                    String dataStr = args.get("data").replace("%26", "&");
                    boolean bRecord = !args.containsKey("record") || args.get("record").compareToIgnoreCase("false") != 0;
                    dataStr = dataStr.replace(";", ";\n");
                    this.ExecuteOperation(dataStr, bRecord, iStateSpaceId);
                }
            }
        }
    }

    public void OnFeedbackTime() {
        Problem currentProblem = this.m_MultiModel.getCurrentModel().getProblem();
        String session = this.m_User.getSession();
        this.m_FeedbackManager.startProactiveInteraction(this.m_SuperModels.getSuperModel(currentProblem), session);
    }

    protected void updateView() {
        this.GetLinkListView().SetModel(this.m_MultiModel.getCurrentModel());
        this.GetLinkListView().enableExecute(true);
        if (this.m_MultiModel.isUndoStackEmpty()) {
            this.GetLinkListView().enableUndo(false);
            this.GetLinkListView().enableDone(false);
            this.GetLinkListView().enableRestart(false);
        } else {
            this.GetLinkListView().enableUndo(true);
            if (this.m_MultiModel.getProblem() != Problem.EMPTY) {
                this.GetLinkListView().enableDone(true);
                this.GetLinkListView().enableRestart(true);
            }
            if ("editor".equals(this.GetLinkListView().getCommandInterfaceType())) {
                this.GetLinkListView().enableExecute(false);
            }
        }
        if (this.m_MultiModel.isRedoStackEmpty()) {
            this.GetLinkListView().enableRedo(false);
        } else {
            this.GetLinkListView().enableRedo(true);
            if ("editor".equals(this.GetLinkListView().getCommandInterfaceType())) {
                this.GetLinkListView().restoreCommandText();
            }
        }
        String idStr = this.m_MultiModel.getProblem().getId();
        this.GetLinkListView().EnableExamples(!idStr.isEmpty() && !idStr.startsWith("0"));
    }

    protected void rearrangeView() {
        this.GetLinkListView().rearrangeContent();
    }

    public LinkedListView GetLinkListView() {
        return (LinkedListView)this.m_View;
    }

    public void OnTutorMessage() {
    }

    @Override
    public void EnableInput(boolean bEnable) {
        this.EnableInput(bEnable, 0);
    }

    @Override
    public void EnableInput(boolean bEnable, int iDelayMs) {
        ((LinkedListView)this.m_View).EnableProblemInput(bEnable, iDelayMs);
    }

    @Override
    public void CloseLesson() {
        this.m_View.Close();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void OnMessage(Message msg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[4] lbl27 : CaseStatement: default:\u000a, @NONE, blocks:[4] lbl27 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

