/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback;

import edu.uic.cs.nlp.chiqat.framework.messages.User;
import edu.uic.cs.nlp.chiqat.lessontoolbox.ITutorDialogue;
import edu.uic.cs.nlp.chiqat.lessontoolbox.TutorMessage;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.LinkedListView;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.controller.LinkedListController;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback.FStateComparator;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback.FeedbackTimer;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback.ProactiveTutor;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback.ReactiveTemplates;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.logger.Logger;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.syntax.SyntaxCheckerFactory;
import ilist.model.LinkedListModel;
import ilist.model.StateSpace;
import ilist.supermodel.ActionNode;
import ilist.supermodel.SolutionPath;
import ilist.supermodel.StateNode;
import ilist.supermodel.SuperModel;
import java.util.ArrayList;
import java.util.Vector;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.TextSpec;

public class FeedbackManager
implements ITutorDialogue {
    private User user;
    private Logger logger;
    private LinkedListView view;
    private FeedbackTimer feedbackTimer;
    private ProactiveTutor proactiveTutor;
    private Realiser realiser;

    public FeedbackManager(User user, LinkedListView view, Logger logger, LinkedListController controller) {
        this.user = user;
        this.view = view;
        this.logger = logger;
        if (logger == null) {
            System.err.println("Warning: logger is null.");
        }
        this.realiser = new Realiser();
        this.proactiveTutor = new ProactiveTutor(view, logger);
        this.feedbackTimer = new FeedbackTimer(controller);
    }

    public void Destroy() {
        this.feedbackTimer.stop();
    }

    public void display(String problem, String message) {
        this.display(problem, message, 0, "generic");
    }

    public void display(String problem, String message, int level, String type) {
        if (this.logger != null) {
            this.logger.log(problem, "message:level " + level + " type " + type, message);
        }
        if (this.view != null) {
            this.feedbackTimer.pause();
            TutorMessage tutorMsg = new TutorMessage();
            tutorMsg.m_Tutor = this;
            tutorMsg.m_Text = message;
            tutorMsg.m_iIconLevel = level;
            boolean bl = tutorMsg.m_bModal = level < 0;
            tutorMsg.m_VisualAction = tutorMsg.m_iIconLevel < 0 ? TutorMessage.VisualState.Thinking : (tutorMsg.m_iIconLevel > 0 ? TutorMessage.VisualState.Good : TutorMessage.VisualState.You);
            this.view.DisplayFeedback(tutorMsg);
            this.feedbackTimer.resume();
            if (this.logger != null) {
                this.logger.log(problem, "message:end", "");
            }
        } else {
            System.out.println(message);
        }
    }

    public void parseError(String problem, String commandText, LinkedListModel model) {
        String feedback = null;
        if (model.getProblem().getCommandInterface().equals("line")) {
            ArrayList<String> variables = new ArrayList<String>(model.getStateSpaces().firstElement().variableList());
            feedback = SyntaxCheckerFactory.getInstance().check(commandText, variables, 12);
        }
        if (feedback == null) {
            feedback = "Sorry, I can't understand\n" + commandText;
        }
        this.display(problem, feedback, -1, "syntax");
    }

    public void executionError(String problem, String error) {
        this.display(problem, error, -1, "execution");
    }

    public void evaluatorFeedback(LinkedListModel model, Vector<String> feedback) {
        String problem = model.getProblem().getId();
        if (feedback.isEmpty()) {
            this.display(problem, "Good job!\nYou have solved problem " + problem + ".", 1, "final");
        } else {
            int level = -feedback.size();
            StringBuilder sb = new StringBuilder();
            sb.append("Uhm, there is a problem with this solution.\n");
            for (String s : feedback) {
                sb.append(String.valueOf(s) + "\n");
            }
            this.display(problem, sb.toString(), level, "final");
        }
    }

    public void reactiveFeedback(String problem, SuperModel sm) {
        SolutionPath path = sm.getCurrentSolutionPath(this.user.getSession());
        ActionNode lastAction = path.getLastAction();
        StateNode lastState = path.getLastState();
        StateNode previousState = path.getPenultimateState();
        double ga = -100.0;
        double gs1 = -100.0;
        double gs2 = -100.0;
        if (lastAction != null) {
            ga = lastAction.getGoodness();
        }
        if (previousState != null) {
            gs1 = previousState.getGoodness();
        }
        if (lastState != null) {
            gs2 = lastState.getGoodness();
        }
        double stateFrequency = lastState.getFrequency();
        String goodnessLog = "g(a) = " + ga + ", g(s1) = " + gs1 + ", g(s2) = " + gs2 + " d = " + (gs2 - gs1) + ", f = " + stateFrequency;
        if (this.logger != null) {
            this.logger.log(problem, "move:goodness", goodnessLog);
        }
        double currentTimeToExit = path.getTimeLag();
        double studentOffset = path.getPreviousTimeOffset();
        double meanTimeToExit = previousState.meanPreviousTimeToExit();
        double stdevTimeToExit = previousState.stdevPreviousTimeToExit();
        String tteLog = "currentTTE = " + currentTimeToExit + ", meanTTE = " + meanTimeToExit + ", stdTTE = " + stdevTimeToExit + ", offset = " + studentOffset;
        if (this.logger != null) {
            this.logger.log(problem, "move:time to exit", tteLog);
        }
        boolean timeUncertain = false;
        if ((currentTimeToExit - meanTimeToExit) / stdevTimeToExit > 1.0 + studentOffset) {
            timeUncertain = true;
        }
        boolean undoUncertain = false;
        if (previousState.getUndoCount() > 0) {
            undoUncertain = true;
        }
        String uncertainLog = "timeUncertain = " + timeUncertain + ", undoUncertain = " + undoUncertain;
        if (this.logger != null) {
            this.logger.log(problem, "move:uncertainty", uncertainLog);
        }
        if (gs2 >= 0.0 && stateFrequency >= 3.0) {
            double d = gs2 - gs1;
            if (gs2 == 0.0) {
                String fb = "Mmmhh... Probably you can't go very far from here...";
                String rfb = this.comparePreviousAndCurrentState(sm);
                this.display(problem, String.valueOf(fb) + rfb, -1 + (int)(d * 100.0), "reactive");
            } else if (d >= 0.0 && (timeUncertain || undoUncertain)) {
                String fb = "Good move!\n";
                String rfb = this.comparePreviousAndCurrentState(sm);
                this.display(problem, String.valueOf(fb) + rfb, 1 + (int)(d * 100.0), "reactive");
            }
        }
    }

    private String comparePreviousAndCurrentState(SuperModel sm) {
        SolutionPath path = sm.getCurrentSolutionPath(this.user.getSession());
        StateSpace s1 = path.getPenultimateRawState().getStateSpace();
        StateSpace s2 = path.getLastRawState().getStateSpace();
        FStateComparator fc = new FStateComparator(s1, s2);
        ReactiveTemplates rt = new ReactiveTemplates(fc.getSet1(), fc.getSet2(), fc.getCommon(), fc.getEntityTypes());
        TextSpec ts = rt.generate();
        String comp = this.realiser.realise(ts);
        return comp;
    }

    public void startProactiveInteraction(SuperModel sm, String session) {
        this.proactiveTutor.startProactiveInteraction(sm, session);
    }

    public void proactiveFeedbackDelay(SuperModel sm, String session) {
        this.feedbackTimer.stop();
        if (!this.proactiveTutor.proactiveFeedbackConditions(sm, session)) {
            return;
        }
        SolutionPath path = sm.getCurrentSolutionPath(session);
        this.proactiveTutor.setReferenceState(path.getLastRawState().getStateSpace());
        StateNode lastState = path.getLastState();
        double tm = lastState.meanTimeToExit();
        double tsd = lastState.stdevTimeToExit();
        double tMin = Math.max(5.0, tm - tsd);
        double tMax = Math.max(tMin, tm + tsd);
        double studentCorrectness = path.getStudentCorrectness();
        double stateCriticality = lastState.getCriticality();
        double delay = path.getLength() == 1 ? tMax : tMin + (tMax - tMin) * studentCorrectness * (1.0 - stateCriticality);
        this.feedbackTimer.setDelay((int)(delay * 1000.0));
        this.feedbackTimer.start();
        if (this.logger != null) {
            this.logger.log(sm.getId(), "proactive delay", "delay = " + delay + ", tMin = " + tMin + ", tMax = " + tMax + ", B = " + studentCorrectness + ", C = " + stateCriticality);
        }
    }

    @Override
    public TutorMessage OnUserResponse(String responseStr) {
        return null;
    }
}

