/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback;

import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.controller.LinkedListController;
import edu.uic.cs.nlp.ui.misc.IFxUiTimerHandler;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;

public class FeedbackTimer
implements IFxUiTimerHandler {
    protected LinkedListController m_Controller = null;
    protected Timer m_Timer = null;
    protected TimerTask m_TimerTask = null;
    protected int m_iDurationMs = 1000;
    protected int m_iInitialDelayMs = 0;
    protected boolean m_bIsRunning = false;
    private long startTime = 0L;
    private boolean isPaused = false;

    public FeedbackTimer(LinkedListController controller) {
        this.m_Controller = controller;
    }

    protected void StartTimer() {
        this.m_bIsRunning = true;
        if (this.m_Timer != null) {
            this.StopTimer();
        }
        this.m_Timer = new Timer();
        this.m_TimerTask = new TimerTask(){

            @Override
            public void run() {
                FeedbackTimer.this.StopTimer();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FeedbackTimer.this.OnTimerHandler();
                    }
                });
            }
        };
        this.m_Timer.scheduleAtFixedRate(this.m_TimerTask, this.m_iInitialDelayMs, (long)this.m_iDurationMs);
    }

    protected void StopTimer() {
        if (this.m_Timer != null) {
            this.m_Timer.cancel();
            this.m_bIsRunning = false;
            this.m_Timer = null;
        }
    }

    public void setDelay(int delay) {
        boolean bWasRunning = this.m_bIsRunning;
        this.StopTimer();
        this.m_iInitialDelayMs = delay;
        if (bWasRunning) {
            this.StartTimer();
        }
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.StartTimer();
        this.isPaused = false;
    }

    public void pause() {
        if (this.m_bIsRunning) {
            this.StopTimer();
            this.isPaused = true;
        }
    }

    public void stop() {
        this.StopTimer();
        this.startTime = 0L;
        this.isPaused = false;
    }

    public void resume() {
        if (this.isPaused) {
            int newDelay;
            int originalDelay = this.m_iInitialDelayMs;
            int elapsedTime = (int)(System.currentTimeMillis() - this.startTime);
            this.startTime = System.currentTimeMillis();
            this.m_iInitialDelayMs = newDelay = Math.max(5000, originalDelay - elapsedTime);
            this.StartTimer();
            this.isPaused = false;
        }
    }

    @Override
    public void OnTimerHandler() {
        this.m_Controller.OnFeedbackTime();
    }
}

