/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback;

import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback.FRelation;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback.FRelationSet;
import java.util.ArrayList;
import simplenlg.features.Form;
import simplenlg.features.Tense;
import simplenlg.realiser.CoordinateSPhraseSpec;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.PPPhraseSpec;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.TextSpec;
import simplenlg.realiser.VPPhraseSpec;

public class ProactiveQuestionTemplates {
    private FRelationSet present;
    private FRelationSet future;
    private FRelationSet common;
    private FRelationSet entityTypes;

    public static void main(String[] argv) {
        Realiser r = new Realiser();
        SPhraseSpec s1 = new SPhraseSpec();
        s1.setSubject("we");
        s1.setHead("want");
        VPPhraseSpec s2 = new VPPhraseSpec();
        s1.addComplement(s2);
        s2.setHead("declare");
        s2.setForm(Form.INFINITIVE);
        NPPhraseSpec np = new NPPhraseSpec("T");
        np.addModifier("new");
        np.addModifier("variable");
        np.setDeterminer("a");
        s2.addComplement(np);
        TextSpec t1 = new TextSpec();
        t1.setParagraph();
        t1.addSpec(s1);
        String text = r.realise(t1);
        System.out.println(text);
    }

    public ProactiveQuestionTemplates(FRelationSet present, FRelationSet future, FRelationSet common, FRelationSet entityTypes) {
        this.present = present;
        this.future = future;
        this.common = common;
        this.entityTypes = entityTypes;
    }

    public TextSpec generate() {
        TextSpec t1 = new TextSpec();
        t1.setParagraph();
        t1.addSpec(this.tNewVariable());
        t1.addSpec(this.tNewNode());
        t1.addSpec(this.tDeletedNode());
        t1.addSpec(this.tDataChange());
        t1.addSpec(this.tPointsTo());
        return t1;
    }

    private TextSpec tNewVariable() {
        FRelationSet rsType;
        TextSpec t1 = new TextSpec();
        FRelationSet rsExists = this.future.search(FRelation.EXISTS, null, null);
        FRelationSet rs = rsExists.leftJoinOnArg1(rsType = this.entityTypes.search(FRelation.ENTITY_TYPE, null, FRelation.TYPE_VARIABLE));
        if (!rs.isEmpty()) {
            SPhraseSpec s0 = new SPhraseSpec();
            s0.setSubject("we");
            s0.setHead("want");
            VPPhraseSpec s1 = new VPPhraseSpec();
            s0.addComplement(s1);
            s1.setHead("declare");
            s1.setForm(Form.INFINITIVE);
            for (FRelation r : rs) {
                NPPhraseSpec np = new NPPhraseSpec(r.getArg1());
                np.addModifier("new");
                np.addModifier("variable");
                np.setDeterminer("a");
                s1.addComplement(np);
            }
            t1.addSpec(s0);
        }
        return t1;
    }

    private TextSpec tNewNode() {
        FRelationSet rsType;
        TextSpec t1 = new TextSpec();
        FRelationSet rsExists = this.future.search(FRelation.EXISTS, null, null);
        FRelationSet rs = rsExists.leftJoinOnArg1(rsType = this.entityTypes.search(FRelation.ENTITY_TYPE, null, FRelation.TYPE_NODE));
        if (!rs.isEmpty()) {
            SPhraseSpec s0 = new SPhraseSpec();
            s0.setSubject("we");
            s0.setHead("want");
            VPPhraseSpec s1 = new VPPhraseSpec();
            s0.addComplement(s1);
            s1.setHead("create");
            s1.setForm(Form.INFINITIVE);
            for (FRelation r : rs) {
                if (!this.present.search(FRelation.EXISTS, r.getArg1(), null).isEmpty()) continue;
                NPPhraseSpec np = new NPPhraseSpec("node");
                np.addModifier("new");
                np.setDeterminer("a");
                s1.addComplement(np);
            }
            t1.addSpec(s0);
        }
        return t1;
    }

    private TextSpec tDeletedNode() {
        TextSpec t1 = new TextSpec();
        FRelationSet rsExists = this.present.search(FRelation.EXISTS, null, null);
        FRelationSet rsType = this.entityTypes.search(FRelation.ENTITY_TYPE, null, FRelation.TYPE_NODE);
        FRelationSet rs = rsExists.leftJoinOnArg1(rsType);
        ArrayList<FRelation> deletedNodes = new ArrayList<FRelation>();
        for (FRelation r : rs) {
            if (this.future.searchOne(FRelation.EXISTS, r.getArg1(), null) != null) continue;
            deletedNodes.add(r);
        }
        if (!deletedNodes.isEmpty()) {
            SPhraseSpec s0 = new SPhraseSpec();
            s0.setSubject("we");
            s0.setHead("want");
            VPPhraseSpec s1 = new VPPhraseSpec();
            s0.addComplement(s1);
            s1.setHead("delete");
            s1.setForm(Form.INFINITIVE);
            for (FRelation r : deletedNodes) {
                FRelation pointedByRel = this.present.searchOne(FRelation.POINTS_TO, null, r.getArg1());
                NPPhraseSpec np1 = new NPPhraseSpec("node");
                np1.setDeterminer("the");
                SPhraseSpec rel1 = new SPhraseSpec();
                rel1.setHead("point");
                rel1.setPassive(true);
                rel1.setTense(Tense.PRESENT);
                rel1.setSubject(this.tEntity(pointedByRel.getArg1()));
                np1.addComplement(rel1);
                SPhraseSpec rel2 = new SPhraseSpec();
                rel2.setHead("contain");
                rel2.setTense(Tense.PRESENT);
                FRelation pastContent = this.present.searchOne(FRelation.CONTENT, r.getArg1(), null);
                rel2.setComplement(pastContent.getArg2());
                np1.addComplement(rel2);
                s1.setComplement(np1);
            }
            t1.addSpec(s0);
        }
        return t1;
    }

    private TextSpec tDataChange() {
        TextSpec t1 = new TextSpec();
        FRelationSet rs = this.present.search(FRelation.CONTENT, null, null);
        for (FRelation r1 : rs) {
            FRelation r2 = this.future.searchOne(FRelation.CONTENT, r1.getArg1(), null);
            if (r2 == null) continue;
            SPhraseSpec s0 = new SPhraseSpec();
            s0.setSubject("we");
            s0.setHead("want");
            VPPhraseSpec s1 = new VPPhraseSpec();
            s0.addComplement(s1);
            s1.setHead("change");
            s1.setForm(Form.INFINITIVE);
            NPPhraseSpec np0 = new NPPhraseSpec("value");
            np0.setDeterminer("the");
            s1.setComplement(np0);
            NPPhraseSpec np1 = new NPPhraseSpec("node");
            np1.setDeterminer("the");
            PPPhraseSpec pp0 = new PPPhraseSpec("of", (Object)np1);
            np0.addModifier(pp0);
            String content1 = r1.getArg2();
            if ("?".equals(content1)) {
                PPPhraseSpec pp1 = new PPPhraseSpec("with");
                NPPhraseSpec np2 = new NPPhraseSpec("content");
                np2.addModifier("undefined");
                pp1.addComplement(np2);
                np1.addComplement(pp1);
            } else {
                SPhraseSpec rel1 = new SPhraseSpec();
                rel1.setHead("contain");
                rel1.setTense(Tense.PRESENT);
                rel1.setComplement(content1);
                np1.addComplement(rel1);
            }
            PPPhraseSpec pp2 = new PPPhraseSpec("to", r2.getArg2());
            s1.addModifier(pp2);
            t1.addSpec(s0);
        }
        return t1;
    }

    private TextSpec tPointsTo() {
        TextSpec t1 = new TextSpec();
        FRelationSet rs = this.present.search(FRelation.POINTS_TO, null, null);
        for (FRelation r1 : rs) {
            for (FRelation r2 : this.future.search(FRelation.POINTS_TO, r1.getArg1(), null)) {
                SPhraseSpec s1 = new SPhraseSpec();
                s1 = new SPhraseSpec();
                s1.setHead("point to");
                s1.setTense(Tense.PRESENT);
                s1.setProgressive(true);
                s1.setSubject(this.tEntity(r1.getArg1()));
                s1.setComplement(this.tEntity(r1.getArg2()));
                SPhraseSpec s2 = new SPhraseSpec();
                s2.setSubject("we");
                s2.setHead("want");
                s2.setComplement("it");
                VPPhraseSpec s2b = new VPPhraseSpec();
                s2b.setHead("point to");
                s2b.setForm(Form.INFINITIVE);
                s2b.setComplement(this.tEntity(r2.getArg2()));
                s2.addModifier(s2b);
                CoordinateSPhraseSpec s3 = new CoordinateSPhraseSpec(s1, s2);
                s3.setConjunction(",");
                t1.addSpec(s3);
            }
        }
        return t1;
    }

    private NPPhraseSpec tEntity(String entity) {
        NPPhraseSpec np = new NPPhraseSpec();
        if (this.entityTypes.searchOne(FRelation.ENTITY_TYPE, entity, FRelation.TYPE_VARIABLE) != null) {
            np.setHead(entity);
            np.addModifier(this.oneOf("variable", "pointer"));
        } else if (this.entityTypes.searchOne(FRelation.ENTITY_TYPE, entity, FRelation.TYPE_NODE) != null) {
            String content;
            FRelation rContent = this.common.searchOne(FRelation.CONTENT, entity, null);
            if (rContent == null) {
                rContent = this.future.searchOne(FRelation.CONTENT, entity, null);
            }
            if (rContent == null) {
                rContent = this.present.searchOne(FRelation.CONTENT, entity, null);
            }
            if (!"?".equals(content = rContent.getArg2())) {
                np.setHead(rContent.getArg2());
                np.addModifier("node");
            } else {
                np.setHead("node");
                np.setDeterminer("a");
                PPPhraseSpec pp = new PPPhraseSpec();
                pp.setHead("with");
                NPPhraseSpec np2 = new NPPhraseSpec();
                np2.setHead("content");
                np2.addModifier("undefined");
                pp.setComplement(np2);
                np.setComplement(pp);
            }
        } else {
            np.setHead(entity);
        }
        return np;
    }

    private <T> T oneOf(T ... items) {
        return items[(int)((double)items.length * Math.random())];
    }
}

