/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback;

import edu.uic.cs.nlp.chiqat.lessontoolbox.ITutorDialogue;
import edu.uic.cs.nlp.chiqat.lessontoolbox.TutorMessage;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.LinkedListView;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback.FStateComparator;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback.ProactiveFeedbackTemplates;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback.ProactiveQuestionTemplates;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.logger.Logger;
import ilist.misc.Util;
import ilist.model.StateSpace;
import ilist.supermodel.ActionNode;
import ilist.supermodel.ActionRecord;
import ilist.supermodel.SolutionPath;
import ilist.supermodel.StateNode;
import ilist.supermodel.SuperModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.TextSpec;

public class ProactiveTutor
implements EventHandler<ActionEvent>,
ITutorDialogue {
    public static final String COM_PROACTIVE_FEEDBACK = "proactive-feedback";
    private static final Comparator<ActionRecord> probabilityComparator = new Comparator<ActionRecord>(){

        @Override
        public int compare(ActionRecord o1, ActionRecord o2) {
            if (o1.probability == o2.probability) {
                return 0;
            }
            if (o1.probability > o2.probability) {
                return -1;
            }
            return 1;
        }
    };
    private static final Comparator<ActionRecord> fgoodnessComparator = new Comparator<ActionRecord>(){

        @Override
        public int compare(ActionRecord o1, ActionRecord o2) {
            if (o1.fgoodness == o2.fgoodness) {
                return 0;
            }
            if (o1.fgoodness > o2.fgoodness) {
                return -1;
            }
            return 1;
        }
    };
    private ArrayList<ActionRecord> badActions = new ArrayList();
    private ArrayList<ActionRecord> mediocreActions = new ArrayList();
    private ArrayList<ActionRecord> bestThree = new ArrayList();
    private ArrayList<ChoiceRecord> choices = new ArrayList();
    private ArrayList<String> sChoices = new ArrayList();
    private Realiser realiser = new Realiser();
    private LinkedListView view;
    private StateSpace referenceState;
    private String currentProblem;
    private Logger logger;

    public ProactiveTutor(LinkedListView view, Logger logger) {
        this.view = view;
        this.logger = logger;
    }

    public void handle(ActionEvent e) {
        String com = "";
        if (e.getSource() instanceof Button) {
            com = ((Button)e.getSource()).getId();
        } else if (e.getSource() instanceof MenuItem) {
            MenuItem item = (MenuItem)e.getSource();
            com = item.getId();
        } else if (e.getSource() instanceof TextField) {
            TextField tf = (TextField)e.getSource();
            com = tf.getId();
        }
    }

    public void startProactiveInteraction(SuperModel sm, String session) {
        this.currentProblem = sm.getId();
        if (this.isCurrentStateConsistent(sm, session)) {
            this.evaluateFutureActions(sm.futureActions(session));
            String tutorQuestion = this.generateQuestion();
            String message = String.valueOf(Util.stripHTML(tutorQuestion)) + "\n" + Util.renderNumberedList(this.sChoices);
            if (this.logger != null) {
                this.logger.log(this.currentProblem, "message:type proactive-question", message);
            }
            TutorMessage tutMsg = new TutorMessage();
            tutMsg.m_Tutor = this;
            tutMsg.m_Answers = this.sChoices;
            tutMsg.m_Text = Util.stripHTML(tutorQuestion);
            tutMsg.m_VisualAction = TutorMessage.VisualState.Thinking;
            this.view.DisplayFeedback(tutMsg);
        }
    }

    private boolean isCurrentStateConsistent(SuperModel sm, String session) {
        SolutionPath path = sm.getCurrentSolutionPath(session);
        StateSpace currentStudentState = path.getLastRawState().getStateSpace();
        if (currentStudentState == this.referenceState) {
            return true;
        }
        if (this.logger != null) {
            this.logger.log(this.currentProblem, "warning", "State inconsistency for proactive feedback");
        }
        return false;
    }

    public boolean proactiveFeedbackConditions(SuperModel sm, String session) {
        this.currentProblem = sm.getId();
        SolutionPath path = sm.getCurrentSolutionPath(session);
        StateNode currentState = path.getLastState();
        double goodness = currentState.getGoodness();
        double criticality = currentState.getCriticality();
        boolean result = goodness > 0.0 && criticality > 0.0;
        if (this.logger != null) {
            this.logger.log(this.currentProblem, "proactive conditions", String.valueOf(result) + ", g = " + goodness + ", c = " + criticality);
        }
        return result;
    }

    private void evaluateFutureActions(ArrayList<ActionRecord> actions) {
        double goodness;
        this.bestThree.clear();
        this.badActions.clear();
        this.mediocreActions.clear();
        this.choices.clear();
        this.sChoices.clear();
        for (ActionRecord a : actions) {
            goodness = a.modelState2.getGoodness();
            if (!(goodness > 0.0)) continue;
            if (this.bestThree.size() < 3) {
                this.bestThree.add(a);
                Collections.sort(this.bestThree, fgoodnessComparator);
                continue;
            }
            ActionRecord worst = this.bestThree.get(2);
            if (!(goodness >= worst.modelState2.getGoodness())) continue;
            this.bestThree.set(2, a);
            Collections.sort(this.bestThree, fgoodnessComparator);
        }
        for (ActionRecord a : actions) {
            goodness = a.modelState2.getGoodness();
            if (goodness == 0.0) {
                this.badActions.add(a);
                continue;
            }
            this.mediocreActions.add(a);
        }
        Collections.sort(this.bestThree, fgoodnessComparator);
        Collections.sort(this.badActions, probabilityComparator);
        Collections.sort(this.mediocreActions, probabilityComparator);
        int n = 0;
        if (!this.bestThree.isEmpty()) {
            ActionRecord a = this.bestThree.get(0);
            ChoiceRecord c = new ChoiceRecord();
            c.actionRecord = a;
            c.actionString = new ActionNode(a.action, a.mapping).toString();
            c.score = 1;
            this.choices.add(c);
            ++n;
        }
        int j = 0;
        while (j < this.badActions.size() && n < 4) {
            ActionRecord a = this.badActions.get(j);
            ChoiceRecord c = new ChoiceRecord();
            c.actionRecord = a;
            c.actionString = new ActionNode(a.action, a.mapping).toString();
            c.score = -1;
            this.choices.add(c);
            ++n;
            ++j;
        }
        Collections.shuffle(this.choices);
        for (ChoiceRecord c : this.choices) {
            this.sChoices.add(c.actionString);
        }
    }

    private String generateQuestion() {
        if (!this.bestThree.isEmpty()) {
            ActionRecord best = this.bestThree.get(0);
            return this.proactiveQuestion(best.studentState1, best.studentState2);
        }
        return null;
    }

    private String proactiveQuestion(StateSpace currentState, StateSpace futureState) {
        FStateComparator fc = new FStateComparator(currentState, futureState);
        ProactiveQuestionTemplates rt = new ProactiveQuestionTemplates(fc.getSet1(), fc.getSet2(), fc.getCommon(), fc.getEntityTypes());
        TextSpec ts = rt.generate();
        String body = this.realiser.realise(ts);
        String result = "<p>Let's see what we can do now...</p><p>" + body + "</p><p>How would you do that?</p>";
        return result;
    }

    private String getFeedback(int answerNum) {
        String result = null;
        ChoiceRecord answer = this.choices.get(answerNum);
        if (answer.score > 0) {
            result = "That sounds right! I suggest you to try it now.";
        } else {
            FStateComparator fc = new FStateComparator(answer.actionRecord.studentState1, answer.actionRecord.studentState2);
            ProactiveFeedbackTemplates pft = new ProactiveFeedbackTemplates(fc.getSet1(), fc.getSet2(), fc.getCommon(), fc.getEntityTypes());
            TextSpec ts = pft.generate();
            String comparison = this.realiser.realise(ts);
            String prefix = answer.score < 0 ? "Uhmm... This is probably not a good idea. Here is what will happen if you do what you suggested. " : "This might work, although there may be better alternatives at this point. Here is what will happen if you do what you suggested. ";
            result = String.valueOf(prefix) + comparison;
        }
        return result;
    }

    private int getAnswerScore(int answerNum) {
        return this.choices.get((int)answerNum).score;
    }

    public void setReferenceState(StateSpace ref) {
        this.referenceState = ref;
    }

    @Override
    public TutorMessage OnUserResponse(String userResStr) {
        return this.OnStudentResponse(userResStr);
    }

    protected TutorMessage OnStudentResponse(String userResStr) {
        TutorMessage msg = new TutorMessage();
        int iAnswerId = -1;
        int i = 0;
        while (i < this.sChoices.size()) {
            if (this.sChoices.get(i).compareToIgnoreCase(userResStr) == 0) {
                iAnswerId = i;
                break;
            }
            ++i;
        }
        if (iAnswerId == -1) {
            msg.m_Text = "Please, give me an answer!";
        } else {
            msg.m_bDisableStudentChoices = true;
            msg.m_bGrayOutQuestion = true;
            msg.m_FeedbackStr = this.getFeedback(iAnswerId);
            msg.m_iIconLevel = this.getAnswerScore(iAnswerId);
            msg.m_VisualAction = msg.m_iIconLevel < 0 ? TutorMessage.VisualState.Thinking : (msg.m_iIconLevel > 0 ? TutorMessage.VisualState.Good : TutorMessage.VisualState.You);
            msg.m_Text = "Your answer was: " + this.sChoices.get(iAnswerId) + "\n" + msg.m_FeedbackStr;
            msg.m_Text = msg.m_Text.replace("\n", "\n\n");
            msg.m_Answers = this.sChoices;
            if (this.logger != null) {
                this.logger.log(this.currentProblem, "message:type proactive-feedback", msg.m_Text);
            }
        }
        this.view.DisplayFeedback(msg);
        return msg;
    }

    private class ChoiceRecord {
        ActionRecord actionRecord;
        String actionString;
        int score;

        private ChoiceRecord() {
        }
    }
}

