/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback;

import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback.FRelation;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback.FRelationSet;
import java.util.ArrayList;
import simplenlg.features.Tense;
import simplenlg.realiser.CoordinateSPhraseSpec;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.PPPhraseSpec;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.TextSpec;

public class ReactiveTemplates {
    private FRelationSet past;
    private FRelationSet present;
    private FRelationSet common;
    private FRelationSet entityTypes;

    public static void main(String[] argv) {
        long time1 = System.currentTimeMillis();
        Realiser r = new Realiser();
        long time2 = System.currentTimeMillis();
        SPhraseSpec s1 = new SPhraseSpec();
        s1 = new SPhraseSpec();
        s1.setHead("target");
        s1.setPassive(true);
        s1.setTense(Tense.PAST);
        s1.setProgressive(true);
        s1.setSubject("X");
        s1.setComplement("Y");
        SPhraseSpec s2 = new SPhraseSpec();
        s2.addFrontModifier("now");
        s2.setHead("be");
        s2.setSubject("it");
        s2.setComplement("abandoned");
        CoordinateSPhraseSpec s3 = new CoordinateSPhraseSpec(s1, s2);
        s3.setConjunction("but");
        TextSpec t1 = new TextSpec();
        t1.setParagraph();
        t1.addSpec(s3);
        t1.addSpec(s3);
        t1.addSpec(s3);
        long time3 = System.currentTimeMillis();
        String text = r.realise(t1);
        long time4 = System.currentTimeMillis();
        System.out.println("init: " + (time2 - time1));
        System.out.println("spec: " + (time3 - time2));
        System.out.println("realize: " + (time4 - time3));
        System.out.println(text);
    }

    public ReactiveTemplates(FRelationSet past, FRelationSet present, FRelationSet common, FRelationSet entityTypes) {
        this.past = past;
        this.present = present;
        this.common = common;
        this.entityTypes = entityTypes;
    }

    public TextSpec generate() {
        TextSpec t1 = new TextSpec();
        t1.setParagraph();
        t1.addSpec(this.tNewVariable());
        t1.addSpec(this.tNewNode());
        t1.addSpec(this.tDeletedNode());
        t1.addSpec(this.tDataChange());
        t1.addSpec(this.tPointsTo());
        t1.addSpec(this.tLostNode());
        return t1;
    }

    private TextSpec tNewVariable() {
        FRelationSet rsType;
        TextSpec t1 = new TextSpec();
        FRelationSet rsExists = this.present.search(FRelation.EXISTS, null, null);
        FRelationSet rs = rsExists.leftJoinOnArg1(rsType = this.entityTypes.search(FRelation.ENTITY_TYPE, null, FRelation.TYPE_VARIABLE));
        if (!rs.isEmpty()) {
            SPhraseSpec s1 = new SPhraseSpec();
            s1.setSubject("you");
            s1.setHead("declare");
            s1.setPerfect(true);
            for (FRelation r : rs) {
                NPPhraseSpec np = new NPPhraseSpec(r.getArg1());
                np.addModifier("new");
                np.addModifier("variable");
                np.setDeterminer("a");
                s1.addComplement(np);
            }
            t1.addSpec(s1);
        }
        return t1;
    }

    private TextSpec tNewNode() {
        FRelationSet rsType;
        TextSpec t1 = new TextSpec();
        FRelationSet rsExists = this.present.search(FRelation.EXISTS, null, null);
        FRelationSet rs = rsExists.leftJoinOnArg1(rsType = this.entityTypes.search(FRelation.ENTITY_TYPE, null, FRelation.TYPE_NODE));
        if (!rs.isEmpty()) {
            SPhraseSpec s1 = new SPhraseSpec();
            s1.setSubject("you");
            s1.setHead("create");
            s1.setPerfect(true);
            for (FRelation r : rs) {
                if (!this.past.search(FRelation.EXISTS, r.getArg1(), null).isEmpty()) continue;
                NPPhraseSpec np = new NPPhraseSpec("node");
                np.addModifier("new");
                np.setDeterminer("a");
                s1.addComplement(np);
            }
            t1.addSpec(s1);
        }
        return t1;
    }

    private TextSpec tDeletedNode() {
        TextSpec t1 = new TextSpec();
        FRelationSet rsExists = this.past.search(FRelation.EXISTS, null, null);
        FRelationSet rsType = this.entityTypes.search(FRelation.ENTITY_TYPE, null, FRelation.TYPE_NODE);
        FRelationSet rs = rsExists.leftJoinOnArg1(rsType);
        ArrayList<FRelation> deletedNodes = new ArrayList<FRelation>();
        for (FRelation r : rs) {
            if (this.present.searchOne(FRelation.EXISTS, r.getArg1(), null) != null) continue;
            deletedNodes.add(r);
        }
        if (!deletedNodes.isEmpty()) {
            SPhraseSpec s1 = new SPhraseSpec();
            s1.setSubject("you");
            s1.setHead("delete");
            s1.setPerfect(true);
            for (FRelation r : deletedNodes) {
                FRelation pointedByRel = this.past.searchOne(FRelation.POINTS_TO, null, r.getArg1());
                NPPhraseSpec np1 = new NPPhraseSpec("node");
                np1.setDeterminer("the");
                SPhraseSpec rel1 = new SPhraseSpec();
                rel1.setHead("point");
                rel1.setPassive(true);
                rel1.setTense(Tense.PAST);
                rel1.setSubject(this.tEntity(pointedByRel.getArg1()));
                np1.addComplement(rel1);
                SPhraseSpec rel2 = new SPhraseSpec();
                rel2.setHead("contain");
                rel2.setTense(Tense.PAST);
                FRelation pastContent = this.past.searchOne(FRelation.CONTENT, r.getArg1(), null);
                rel2.setComplement(pastContent.getArg2());
                np1.addComplement(rel2);
                s1.setComplement(np1);
            }
            t1.addSpec(s1);
        }
        return t1;
    }

    private TextSpec tDataChange() {
        TextSpec t1 = new TextSpec();
        FRelationSet rs = this.past.search(FRelation.CONTENT, null, null);
        for (FRelation r1 : rs) {
            FRelation r2 = this.present.searchOne(FRelation.CONTENT, r1.getArg1(), null);
            if (r2 == null) continue;
            SPhraseSpec s1 = new SPhraseSpec();
            s1.setHead("contain");
            NPPhraseSpec np1 = new NPPhraseSpec("node");
            np1.setDeterminer("the");
            String content1 = r1.getArg2();
            if ("?".equals(content1)) {
                PPPhraseSpec pp1 = new PPPhraseSpec("with");
                NPPhraseSpec np2 = new NPPhraseSpec("content");
                np2.addModifier("undefined");
                pp1.addComplement(np2);
                np1.addComplement(pp1);
            } else {
                SPhraseSpec rel1 = new SPhraseSpec();
                rel1.setHead("contain");
                rel1.setTense(Tense.PAST);
                rel1.setComplement(content1);
                np1.addComplement(rel1);
            }
            s1.setComplement(r2.getArg2());
            s1.setPremodifier("now");
            s1.setSubject(np1);
            t1.addSpec(s1);
        }
        return t1;
    }

    private TextSpec tPointsTo() {
        TextSpec t1 = new TextSpec();
        FRelationSet rs = this.past.search(FRelation.POINTS_TO, null, null);
        for (FRelation r1 : rs) {
            for (FRelation r2 : this.present.search(FRelation.POINTS_TO, r1.getArg1(), null)) {
                SPhraseSpec s1 = new SPhraseSpec();
                s1 = new SPhraseSpec();
                s1.setHead("point to");
                s1.setTense(Tense.PAST);
                s1.setProgressive(true);
                s1.setSubject(this.tEntity(r1.getArg1()));
                s1.setComplement(this.tEntity(r1.getArg2()));
                SPhraseSpec s2 = new SPhraseSpec();
                s2.addFrontModifier("now");
                s2.setHead(s1.getHead());
                s2.setSubject("it");
                s2.setComplement(this.tEntity(r2.getArg2()));
                CoordinateSPhraseSpec s3 = new CoordinateSPhraseSpec(s1, s2);
                s3.setConjunction(",");
                t1.addSpec(s3);
            }
        }
        return t1;
    }

    private TextSpec tLostNode() {
        TextSpec t1 = new TextSpec();
        FRelationSet rs = this.past.search(FRelation.POINTS_TO, null, null);
        for (FRelation r1 : rs) {
            if (this.entityTypes.searchOne(FRelation.ENTITY_TYPE, r1.getArg2(), FRelation.TYPE_NODE) == null || this.present.searchOne(FRelation.POINTS_TO, null, r1.getArg2()) != null || this.common.searchOne(FRelation.POINTS_TO, null, r1.getArg2()) != null || this.present.searchOne(FRelation.EXISTS, r1.getArg2(), null) == null && this.common.searchOne(FRelation.EXISTS, r1.getArg2(), null) == null) continue;
            SPhraseSpec s1 = new SPhraseSpec();
            s1.setHead("target");
            s1.setPassive(true);
            s1.setTense(Tense.PAST);
            s1.setProgressive(true);
            s1.setSubject(this.tEntity(r1.getArg1()));
            s1.setComplement(this.tEntity(r1.getArg2()));
            SPhraseSpec s2 = new SPhraseSpec();
            s2.addFrontModifier("now");
            s2.setHead("be");
            s2.setSubject("it");
            s2.setComplement("abandoned");
            CoordinateSPhraseSpec s3 = new CoordinateSPhraseSpec(s1, s2);
            s3.setConjunction("but");
            t1.addSpec(s3);
        }
        return t1;
    }

    private NPPhraseSpec tEntity(String entity) {
        NPPhraseSpec np = new NPPhraseSpec();
        if (this.entityTypes.searchOne(FRelation.ENTITY_TYPE, entity, FRelation.TYPE_VARIABLE) != null) {
            np.setHead(entity);
            np.addModifier(this.oneOf("variable", "pointer"));
        } else if (this.entityTypes.searchOne(FRelation.ENTITY_TYPE, entity, FRelation.TYPE_NODE) != null) {
            String content;
            FRelation rContent = this.common.searchOne(FRelation.CONTENT, entity, null);
            if (rContent == null) {
                rContent = this.present.searchOne(FRelation.CONTENT, entity, null);
            }
            if (rContent == null) {
                rContent = this.past.searchOne(FRelation.CONTENT, entity, null);
            }
            if (!"?".equals(content = rContent.getArg2())) {
                np.setHead(rContent.getArg2());
                np.addModifier("node");
            } else {
                np.setHead("node");
                np.setDeterminer("a");
                PPPhraseSpec pp = new PPPhraseSpec();
                pp.setHead("with");
                NPPhraseSpec np2 = new NPPhraseSpec();
                np2.setHead("content");
                np2.addModifier("undefined");
                pp.setComplement(np2);
                np.setComplement(pp);
            }
        } else {
            np.setHead(entity);
        }
        return np;
    }

    private <T> T oneOf(T ... items) {
        return items[(int)((double)items.length * Math.random())];
    }
}

