/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.logger;

import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.logger.LogElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.concurrent.BlockingQueue;

class LogConsumer
implements Runnable {
    private boolean m_bRunning = true;
    private boolean m_bShuttingDown = false;
    private URL logServerURL;
    BlockingQueue<LogElement> queue;

    public LogConsumer(String serverURL, BlockingQueue<LogElement> queue) {
        this.queue = queue;
        try {
            this.logServerURL = new URL(serverURL);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public void Shutdown() {
        this.m_bShuttingDown = true;
        this.queue.add(new LogElement(true));
    }

    @Override
    public void run() {
        int iSendRetries = 10;
        try {
            while (!this.m_bShuttingDown || !this.queue.isEmpty()) {
                boolean success;
                LogElement e = this.queue.take();
                if (e.m_bEmpty || (success = this.sendLogElement(e))) continue;
                this.queue.put(e);
                Thread.sleep(100L);
                if (this.m_bRunning || --iSendRetries > 0) continue;
                this.queue.clear();
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.m_bRunning = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sendLogElement(LogElement logElement) {
        try {
            String line;
            String encodedSession = URLEncoder.encode(logElement.session, "UTF-8");
            String encodedMessageNum = URLEncoder.encode(Long.toString(logElement.message_num), "UTF-8");
            String encodedUser = URLEncoder.encode(logElement.user, "UTF-8");
            String encodedTime = URLEncoder.encode(Long.toString(logElement.time), "UTF-8");
            String encodedProblem = URLEncoder.encode(logElement.problem, "UTF-8");
            String encodedType = URLEncoder.encode(logElement.type, "UTF-8");
            String encodedData = URLEncoder.encode(logElement.data, "UTF-8");
            URLConnection connection = this.logServerURL.openConnection();
            connection.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
            out.write("session=" + encodedSession + "&message_num=" + encodedMessageNum + "&user=" + encodedUser + "&time=" + encodedTime + "&problem=" + encodedProblem + "&type=" + encodedType + "&data=" + encodedData);
            out.close();
            BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            do {
                if ((line = rd.readLine()) != null) continue;
                rd.close();
                return false;
            } while (!"1".equals(line));
            rd.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

