/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.syntax;

import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.syntax.SyntaxCheckerI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.PriorityQueue;
import java.util.Scanner;
import java.util.Stack;

public class SyntaxCheckerCPP
extends SyntaxCheckerI {
    int del_token_penalty = 4;
    int penalty_twiddle = 2;
    int penalty_mismatch = 3;
    int penalty_del = 4;
    int penalty_add = 4;
    int penalty_missing_space = 2;
    int undef_name_as_def = 5;
    int def_name_as_undef = 2;
    int not_stmt_penalty = 4;
    ArrayList<Tokish> tokIdeas;
    SymType[][] G = new SymType[][]{{SymType.DECL, SymType.NODE, SymType.STAR, SymType.UNAME}, {SymType.DECL, SymType.NODE, SymType.STAR, SymType.UNAME, SymType.ASN, SymType.PEXP}, {SymType.PEXP, SymType.NULL}, {SymType.PEXP, SymType.DNAME}, {SymType.PEXP, SymType.DNAME, SymType.ARROW, SymType.LINK}, {SymType.PEXP, SymType.NEW, SymType.NODE}, {SymType.PLVAL, SymType.DNAME}, {SymType.PLVAL, SymType.DNAME, SymType.ARROW, SymType.LINK}, {SymType.PASN, SymType.PLVAL, SymType.ASN, SymType.PEXP}, {SymType.DLTSTMT, SymType.DELETE, SymType.PLVAL}, {SymType.DEXP, SymType.NUM}, {SymType.DEXP, SymType.DNAME, SymType.ARROW, SymType.DATA}, {SymType.DASN, SymType.DNAME, SymType.ARROW, SymType.DATA, SymType.ASN, SymType.DEXP}, {SymType.DNAME, SymType.NAME}, {SymType.UNAME, SymType.NAME}, {SymType.DLTSTMT, SymType.DELETE, SymType.NOTPLVAL}, {SymType.PASN, SymType.PLVAL, SymType.ASN, SymType.NOTPEXP}, {SymType.PEXP, SymType.PEXP, SymType.ARROW, SymType.LINK}, {SymType.PLVAL, SymType.PEXP, SymType.ARROW, SymType.LINK}, {SymType.PEXP, SymType.PEXP, SymType.DOT, SymType.LINK}, {SymType.DASN, SymType.DNAME, SymType.ARROW, SymType.DATA, SymType.ASN, SymType.NOTDEXP}, {SymType.PLVAL, SymType.NOTPLVAL, SymType.ARROW, SymType.LINK}, {SymType.PLVAL, SymType.NUM}, {SymType.PEXP, SymType.NUM}, {SymType.PASN, SymType.PEXP, SymType.ASN, SymType.PEXP}, {SymType.DLTSTMT, SymType.DELETE, SymType.STAR, SymType.PLVAL}, {SymType.PEXP, SymType.PLVAL, SymType.ARROW, SymType.NOTNODEFIELD}, {SymType.PLVAL, SymType.PLVAL, SymType.ARROW, SymType.NOTNODEFIELD}, {SymType.DEXP, SymType.PLVAL, SymType.ARROW, SymType.NOTNODEFIELD}, {SymType.DECL, SymType.NODE, SymType.UNAME}, {SymType.DECL, SymType.NODE, SymType.UNAME, SymType.ASN, SymType.PEXP}};
    int[] GRPenalty;
    String[] GRErrMsg;

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in, "UTF-8");
        scanner.useLocale(new Locale("en", "US"));
        SyntaxCheckerCPP sc = new SyntaxCheckerCPP();
        String s = scanner.nextLine();
        String t = scanner.nextLine();
        String[] A = t.split("\\|");
        ArrayList<String> IDs = new ArrayList<String>();
        int i = 0;
        while (i < A.length) {
            String ait = A[i].trim();
            if (ait.length() > 0) {
                IDs.add(ait);
            }
            ++i;
        }
        String res = ((SyntaxCheckerI)sc).check(s, IDs, 12);
        System.out.println(res == null ? "OK" : res);
    }

    @Override
    public String check(String line, ArrayList<String> IDs, int threshold) {
        String language = "C++";
        String m = this.constructCheck(line, language);
        if (m == null) {
            m = this.singleStmtCheck(line, language);
        }
        if (m == null) {
            String src = line.split(";")[0];
            PartialParse pp = this.findParse(src, 0, src.length(), IDs, threshold);
            if (pp == null) {
                m = "There's a syntax error here, and I can't figure out what you were trying to do.";
            } else if (pp.weight > 0) {
                m = this.explainError(pp, src, pp.origLex);
            }
        }
        return m;
    }

    public String constructCheck(String line, String language) {
        String res = null;
        if (line.matches(".*\\?[^:]*$")) {
            res = "I don't think that ? belongs.";
        } else if (line.matches(".*(\\b(for|while|if)\\b|(\\?.*:)).*")) {
            String construct = "INTERNAL ERROR!";
            if (line.matches(".*for.*")) {
                construct = "for loops";
            } else if (line.matches(".*while.*")) {
                construct = "while loops";
            } else if (line.matches(".*if.*")) {
                construct = "if's";
            } else if (line.matches(".*\\?.*:.*")) {
                construct = "?:-expressions";
            }
            res = "Of course " + construct + " are allowed in " + language + " programs, but iList doesn't " + " allow them here becaues we're trying to " + " get you thinking a certain way to help with " + " more difficult problems later on.";
        } else if (line.matches(".*\\(\\S+\\).*")) {
            res = "iList doesn't allow ( )'s here.  We're trying to  get you thinking a certain way to help with  more difficult problems later on.";
        } else if (language.equals("C++") && line.matches(".*(\\bcout\\b|<<|>>).*")) {
            res = "Input/Output doesn't really play a role here.";
        }
        return res;
    }

    public String singleStmtCheck(String line, String language) {
        String s2;
        String[] sl = line.split(";+");
        String string = s2 = sl.length > 1 ? sl[1].trim() : null;
        if (s2 == null || s2.equals("")) {
            return null;
        }
        if (s2.length() <= 2 && sl.length == 2) {
            return "Is the \"" + s2 + "\" after the ; a typo?  Only one simple statement is allowed here.";
        }
        return "Only one simple statement is allowed here.  Multiple statements must go on separate lines.";
    }

    String lex2string(Sym s, String src) {
        String res = "";
        if (s.pred != null) {
            res = this.lex2string(s.pred, src);
        }
        String rest = s.t == SymType.NAME && s.pretendTxt != src.substring(s.ib, s.ie) && s.pretendTxt != "" ? String.valueOf(s.t.toString()) + "[" + s.pretendTxt + "]:" + src.substring(s.ib, s.ie) : String.valueOf(s.t.toString()) + ":" + src.substring(s.ib, s.ie);
        if (res == "") {
            return rest;
        }
        return String.valueOf(res) + " " + rest;
    }

    SyntaxCheckerCPP() {
        int[] nArray = new int[31];
        nArray[15] = 5;
        nArray[16] = 5;
        nArray[17] = 1;
        nArray[18] = 1;
        nArray[19] = 1;
        nArray[20] = 5;
        nArray[21] = 5;
        nArray[22] = 3;
        nArray[23] = 3;
        nArray[24] = 3;
        nArray[25] = 3;
        nArray[26] = 5;
        nArray[27] = 5;
        nArray[28] = 5;
        nArray[29] = 3;
        nArray[30] = 3;
        this.GRPenalty = nArray;
        String[] stringArray = new String[31];
        stringArray[15] = "Delete takes a pointer to the node you want to delete.\n";
        stringArray[16] = "If you have a pointer on the left-hand-side of an assignment, you need a pointer expression on the right-hand-side.\n";
        stringArray[17] = "iList doesn't allow chaining ->'s, e.g. \"p->link->data\".\nIt's valid, but we want you to think a different way.\n";
        stringArray[18] = "iList doesn't allow chaining ->'s, e.g. \"p->link->data\".\nIt's valid, but we want you to think a different way.\n";
        stringArray[19] = "iList doesn't allow chaining .'s, e.g. \"p.link.link\".\nIt's valid, but we want you to think a different way.\n";
        stringArray[20] = "If you have a data-value on the left-hand-side of an assignment, you need a data-value expression on the right-hand-side.\n";
        stringArray[21] = "\"->link\" only makes sense if what comes before is a Node pointer.\n";
        stringArray[22] = "You're using a number like it's a Node pointer object.\n";
        stringArray[23] = "You're using a number like it's a Node pointer object.\n";
        stringArray[24] = "You can't assign to pointer constants like NULL\n";
        stringArray[25] = "You should give delete a pointer to a Node, not the Node itself, so there's no need to dereference with *.\n";
        stringArray[26] = "\"data\" and \"link\" are the only things that can appear to the right of \"->\", they are the only Node fields.\n";
        stringArray[27] = "\"data\" and \"link\" are the only things that can appear to the right of \"->\", they are the only Node fields.\n";
        stringArray[28] = "\"data\" and \"link\" are the only things that can appear to the right of \"->\", they are the only Node fields.\n";
        stringArray[29] = "The only variables we need here are pointers to Nodes, i.e. \"Node *\" rather than \"Node\".";
        stringArray[30] = "The only variables we need here are pointers to Nodes, i.e. \"Node *\" rather than \"Node\".";
        this.GRErrMsg = stringArray;
        this.tokIdeas = new ArrayList();
        this.tokIdeas.add(new Tokish(SymType.NODE, "Node", 0));
        this.tokIdeas.add(new Tokish(SymType.NODE, "Node()", 0));
        this.tokIdeas.add(new Tokish(SymType.STAR, "*", 0));
        this.tokIdeas.add(new Tokish(SymType.STAR, "8", 2));
        this.tokIdeas.add(new Tokish(SymType.ARROW, "->", 0));
        this.tokIdeas.add(new Tokish(SymType.DOT, ".", 0));
        this.tokIdeas.add(new Tokish(SymType.LINK, "link", 0));
        this.tokIdeas.add(new Tokish(SymType.LINK, "next", 2));
        this.tokIdeas.add(new Tokish(SymType.NULL, "null", 0));
        this.tokIdeas.add(new Tokish(SymType.NULL, "0", 2));
        this.tokIdeas.add(new Tokish(SymType.NEW, "new", 0));
        this.tokIdeas.add(new Tokish(SymType.ASN, "=", 0));
        this.tokIdeas.add(new Tokish(SymType.DELETE, "delete", 0));
        this.tokIdeas.add(new Tokish(SymType.DATA, "data", 0));
    }

    boolean mps(String a, int i, String b, int j) {
        return a.regionMatches(true, i, b, j, 1);
    }

    public PartialParse findParse(String src, int i, int j, ArrayList<String> IDs, int threshold) {
        LikelyLex L = new LikelyLex(src, i, j, this.tokIdeas, IDs);
        PriorityQueue<PartialParse> Q = new PriorityQueue<PartialParse>(10, new PPCmp());
        while (true) {
            PartialLex pl = L.next();
            PartialParse pp = Q.peek();
            if (pl == null && pp == null) {
                return null;
            }
            if (pl != null && pp != null) {
                if (pl.weight < pp.weight) {
                    pp = new PartialParse(pl.soFar, L.nextID++, src);
                } else {
                    L.Q.add(pl);
                    Q.poll();
                }
            } else if (pp == null) {
                pp = new PartialParse(pl.soFar, L.nextID++, src);
            }
            if (pp.weight > threshold) {
                return null;
            }
            if (pp.complete()) {
                return pp;
            }
            pp.makeParseStep(src, Q, IDs, L);
        }
    }

    String errorHelper(Sym T, String src, String message) {
        if (T.t.term == 1) {
            if (T.weight > 0 && T.getAssumedTxt(src) != "") {
                message = String.valueOf(message) + "* Did you mean \"" + T.getAssumedTxt(src) + "\" instead of \"" + T.getActualTxt(src) + "\"?\n";
            }
            return message;
        }
        Sym[] symArray = T.child;
        int n = T.child.length;
        int n2 = 0;
        while (n2 < n) {
            Sym c = symArray[n2];
            message = this.errorHelper(c, src, message);
            ++n2;
        }
        String nmsg = "";
        if (this.GRPenalty[T.ruleNum] != 0) {
            nmsg = this.GRErrMsg[T.ruleNum];
        }
        if (T.nameErrorTag == 1) {
            nmsg = "Variable name " + T.getActualTxt(src) + " is undeclared! ";
        }
        if (T.nameErrorTag == 2) {
            nmsg = "Variable name " + T.getActualTxt(src) + " is already declared! ";
        }
        if (message.indexOf(nmsg, 0) == -1) {
            message = String.valueOf(message) + "* " + nmsg;
        }
        return message;
    }

    public String explainError(PartialParse pp, String src, Sym origLex) {
        Sym T = pp.Q.get(0);
        boolean isStmt = T.t.term == 0;
        String message = "";
        if (!isStmt && pp.weight == this.not_stmt_penalty) {
            message = String.valueOf(message) + (T.t.description == null ? "What you've written is syntactically correct so far.\n" : "This is a syntactically correct " + T.t.description + ".\n") + "But it's not a proper statement - i.e. it won't " + "actually have any effect.  It's like \"x+3;\", " + "three will be added to x, but nothing will " + "actually be done with the value.";
        } else {
            message = String.valueOf(message) + "OK, there are some problems with this input.\n";
            if (T.t.description != null) {
                message = String.valueOf(message) + "You're trying to write a " + T.t.description + ", right?\n";
            }
            Stack<Sym> S = new Stack<Sym>();
            Sym x = origLex;
            while (x != null) {
                if (x.t == SymType.DEL) {
                    if (S.size() != 0 && ((Sym)S.peek()).ib == x.ie) {
                        Sym y = (Sym)S.pop();
                        S.push(new Sym(SymType.DEL, x.ib, y.ie, null, 0, 0, null));
                    } else {
                        S.push(x);
                    }
                }
                x = x.pred;
            }
            if (S.size() > 0) {
                Sym z = (Sym)S.pop();
                message = String.valueOf(message) + "* Maybe the \"" + src.substring(z.ib, z.ie) + "\"";
                while (S.size() != 0) {
                    z = (Sym)S.pop();
                    message = String.valueOf(message) + " and \"" + src.substring(z.ib, z.ie) + "\"";
                }
                message = String.valueOf(message) + " shouldn't be there?\n";
            }
            message = this.errorHelper(T, src, message);
        }
        return message;
    }

    public class LikelyLex {
        ArrayList<Tokish> tokIdeasLocal;
        PriorityQueue<PartialLex> Q;
        int nextID;

        public LikelyLex(String src, int si, int sj, ArrayList<Tokish> tokIdeas, ArrayList<String> IDs) {
            this.tokIdeasLocal = new ArrayList(tokIdeas.size() + IDs.size());
            int kk = 0;
            int ii = 0;
            while (ii < tokIdeas.size()) {
                this.tokIdeasLocal.add(kk, tokIdeas.get(ii));
                ++ii;
                ++kk;
            }
            int jj = 0;
            while (jj < IDs.size()) {
                this.tokIdeasLocal.add(kk, new Tokish(SymType.NAME, IDs.get(jj), 0));
                ++jj;
                ++kk;
            }
            this.Q = new PriorityQueue<PartialLex>(10, new PLCmp());
            this.nextID = 0;
            this.Q.add(new PartialLex(src, si, sj, null, 0, 0, null, 0, this.nextID++, null, ""));
        }

        public PartialLex next() {
            while (this.Q.size() != 0) {
                boolean charMatch;
                PartialLex p = this.Q.poll();
                if (p == null || p.complete()) {
                    return p;
                }
                if (!p.midTok()) {
                    PartialLex next;
                    while (p.si < p.sj && p.src.charAt(p.si) == ' ') {
                        ++p.si;
                    }
                    if (p.si == p.sj) {
                        return p;
                    }
                    if (p.si > p.sj) continue;
                    for (Tokish T : this.tokIdeasLocal) {
                        next = new PartialLex(p.src, p.si, p.sj, T.txt, 0, T.txt.length(), T.t, p.weight + T.weight, this.nextID++, p.soFar, T.txt);
                        this.Q.add(next);
                    }
                    if (Character.isDigit(p.src.charAt(p.si))) {
                        int k = p.si + 1;
                        while (k < p.sj && Character.isDigit(p.src.charAt(k))) {
                            ++k;
                        }
                        Sym s = new Sym(SymType.NUM, p.si, k, p.soFar, 0, p.weight, "");
                        next = new PartialLex(p.src, k, p.sj, null, 0, 0, null, p.weight, this.nextID++, s, "");
                        this.Q.add(next);
                    }
                    if (Character.isLetter(p.src.charAt(p.si))) {
                        int k = p.si + 1;
                        while (k < p.sj && Character.isLetterOrDigit(p.src.charAt(k))) {
                            ++k;
                        }
                        boolean nf = false;
                        for (Tokish T : this.tokIdeasLocal) {
                            boolean bl = nf = nf || T.txt.compareToIgnoreCase(p.src.substring(p.si, k)) == 0 && T.weight == 0;
                        }
                        int penalty = nf ? 3 : 0;
                        Sym s = new Sym(SymType.NAME, p.si, k, p.soFar, penalty, p.weight + penalty, "");
                        PartialLex next2 = new PartialLex(p.src, k, p.sj, null, 0, 0, null, p.weight + penalty, this.nextID++, s, "");
                        this.Q.add(next2);
                    }
                    Sym s = new Sym(SymType.DEL, p.si, p.si + 1, p.soFar, SyntaxCheckerCPP.this.del_token_penalty, p.weight + SyntaxCheckerCPP.this.del_token_penalty, "");
                    PartialLex next3 = new PartialLex(p.src, p.si + 1, p.sj, null, 0, 0, null, s.agregateWeight, this.nextID++, s, "");
                    this.Q.add(next3);
                    continue;
                }
                if (p.ti == p.tj) {
                    Sym s;
                    if (p.initi == p.si) continue;
                    if (Character.isLetterOrDigit(p.src.charAt(p.initi)) && p.si < p.sj && Character.isLetterOrDigit(p.src.charAt(p.si))) {
                        p.weight += SyntaxCheckerCPP.this.penalty_missing_space;
                    }
                    p.soFar = s = new Sym(p.targetType, p.initi, p.si, p.soFar, p.weight - (p.soFar == null ? 0 : p.soFar.agregateWeight), p.weight, p.pretendTxt);
                    p.targetType = null;
                    p.target = null;
                    this.Q.add(p);
                    continue;
                }
                boolean bl = charMatch = p.si < p.sj && SyntaxCheckerCPP.this.mps(p.src, p.si, p.target, p.ti);
                if (charMatch) {
                    this.Q.add(p.lexStep(1, 1, 0, this.nextID++));
                }
                if (p.target.length() == 1) continue;
                if (!charMatch && p.si + 1 < p.sj && p.ti + 1 < p.tj && SyntaxCheckerCPP.this.mps(p.src, p.si + 1, p.target, p.ti) && SyntaxCheckerCPP.this.mps(p.src, p.si, p.target, p.ti + 1)) {
                    this.Q.add(p.lexStep(2, 2, SyntaxCheckerCPP.this.penalty_twiddle, this.nextID++));
                }
                this.Q.add(p.lexStep(1, 0, SyntaxCheckerCPP.this.penalty_del, this.nextID++));
                this.Q.add(p.lexStep(0, 1, SyntaxCheckerCPP.this.penalty_add, this.nextID++));
                if (charMatch) continue;
                this.Q.add(p.lexStep(1, 1, SyntaxCheckerCPP.this.penalty_mismatch, this.nextID++));
            }
            return null;
        }
    }

    public class PLCmp
    implements Comparator<PartialLex> {
        @Override
        public int compare(PartialLex a, PartialLex b) {
            if (a.id == b.id) {
                return 0;
            }
            if (a.weight < b.weight || a.weight == b.weight && (a.si > b.si || a.si == b.si && a.id < b.id)) {
                return -1;
            }
            return 1;
        }

        public boolean equals(PartialLex a, PartialLex b) {
            return a.id == b.id;
        }
    }

    public class PPCmp
    implements Comparator<PartialParse> {
        @Override
        public int compare(PartialParse a, PartialParse b) {
            if (a.id == b.id) {
                return 0;
            }
            if (a.weight < b.weight || a.weight == b.weight && (a.curr > b.curr || a.curr == b.curr && a.id < b.id)) {
                return -1;
            }
            return 1;
        }

        public boolean equals(PartialParse a, PartialParse b) {
            return a.id == b.id;
        }
    }

    public class PartialLex {
        String src;
        int si;
        int sj;
        int initi;
        String target;
        int ti;
        int tj;
        String pretendTxt;
        SymType targetType;
        int weight;
        int id;
        Sym soFar;

        PartialLex(String _src, int _si, int _sj, String _target, int _ti, int _tj, SymType _targetType, int _weight, int _id, Sym _soFar, String _pretendTxt) {
            this.src = _src;
            this.si = _si;
            this.sj = _sj;
            this.target = _target;
            this.ti = _ti;
            this.tj = _tj;
            this.targetType = _targetType;
            this.weight = _weight;
            this.id = _id;
            this.soFar = _soFar;
            this.pretendTxt = _pretendTxt;
            this.initi = this.si;
        }

        boolean complete() {
            return this.targetType == null && this.si == this.sj;
        }

        boolean midTok() {
            return this.targetType != null;
        }

        PartialLex lexStep(int sdelta, int tdelta, int wdelta, int newID) {
            PartialLex t = new PartialLex(this.src, this.si + sdelta, this.sj, this.target, this.ti + tdelta, this.tj, this.targetType, this.weight + wdelta, newID, this.soFar, this.pretendTxt);
            t.initi = this.initi;
            return t;
        }
    }

    public class PartialParse {
        ArrayList<Sym> Q;
        Sym origLex;
        Sym[] toks;
        int curr;
        int weight;
        int id;
        boolean completed;

        PartialParse(ArrayList<Sym> _Q, Sym[] _toks, int _curr, int _weight, Sym _origLex, int nextID) {
            this.Q = _Q;
            this.toks = _toks;
            this.curr = _curr;
            this.weight = _weight;
            this.origLex = _origLex;
            this.id = nextID;
            this.completed = false;
        }

        PartialParse(Sym s, int nextID, String src) {
            this.Q = new ArrayList();
            this.curr = 0;
            this.weight = s.agregateWeight;
            this.id = nextID;
            this.completed = false;
            this.origLex = s;
            int N = 0;
            int dels = 0;
            Sym tmp = s;
            while (tmp != null) {
                ++N;
                if (tmp.t == SymType.DEL) {
                    ++dels;
                }
                tmp = tmp.pred;
            }
            this.toks = new Sym[N - dels];
            tmp = s;
            while (tmp != null) {
                if (tmp.t != SymType.DEL) {
                    this.toks[--N - dels] = tmp;
                }
                tmp = tmp.pred;
            }
        }

        public boolean complete() {
            return this.completed;
        }

        public void makeParseStep(String src, PriorityQueue<PartialParse> PPQ, ArrayList<String> IDs, LikelyLex L) {
            boolean actfound = false;
            if (this.curr < this.toks.length) {
                actfound = true;
                ArrayList Qp = (ArrayList)this.Q.clone();
                Qp.add(this.toks[this.curr]);
                PPQ.add(new PartialParse(Qp, this.toks, this.curr + 1, this.weight, this.origLex, L.nextID++));
            }
            int r = 0;
            while (r < SyntaxCheckerCPP.this.G.length) {
                int N = SyntaxCheckerCPP.this.G[r].length - 1;
                int I = this.Q.size();
                int n = N;
                int i = I - 1;
                while (n > 0 && i >= 0 && SyntaxCheckerCPP.this.G[r][n].match(this.Q.get((int)i).t)) {
                    --n;
                    --i;
                }
                if (n == 0) {
                    actfound = true;
                    int penalty = SyntaxCheckerCPP.this.GRPenalty[r];
                    int nameErrorTag = 0;
                    if (SyntaxCheckerCPP.this.G[r][0] == SymType.DNAME || SyntaxCheckerCPP.this.G[r][0] == SymType.UNAME) {
                        String name = this.Q.get(I - 1).getAssumedTxt(src);
                        boolean idecl = false;
                        for (String x : IDs) {
                            boolean bl = idecl = idecl || x.equals(name);
                        }
                        if (SyntaxCheckerCPP.this.G[r][0] == SymType.DNAME && !idecl) {
                            penalty += SyntaxCheckerCPP.this.undef_name_as_def;
                            nameErrorTag = 1;
                        }
                        if (SyntaxCheckerCPP.this.G[r][0] == SymType.UNAME && idecl) {
                            penalty += SyntaxCheckerCPP.this.def_name_as_undef;
                            nameErrorTag = 2;
                        }
                    }
                    Sym ns = new Sym(SyntaxCheckerCPP.this.G[r][0], this.Q, I - N, I, r, this.weight + penalty);
                    ns.nameErrorTag = nameErrorTag;
                    ArrayList Qp = (ArrayList)this.Q.clone();
                    int t = I - 1;
                    while (t >= I - N) {
                        Qp.remove(t);
                        --t;
                    }
                    Qp.add(ns);
                    PPQ.add(new PartialParse(Qp, this.toks, this.curr, this.weight + penalty, this.origLex, L.nextID++));
                }
                ++r;
            }
            if (!actfound && this.Q.size() == 1 && this.curr == this.toks.length) {
                this.completed = true;
                SymType S = this.Q.get((int)0).t;
                if (S != SymType.DECL && S != SymType.PASN && S != SymType.DASN && S != SymType.DLTSTMT) {
                    this.weight += SyntaxCheckerCPP.this.not_stmt_penalty;
                }
                PPQ.add(this);
            }
        }
    }

    class Sym {
        SymType t;
        int ib;
        int ie;
        Sym pred;
        int weight;
        int agregateWeight;
        String pretendTxt;
        int ruleNum;
        Sym[] child;
        int nameErrorTag = 0;

        public Sym(SymType st, int i, int j, Sym p, int w, int aw, String txt) {
            this.t = st;
            this.ib = i;
            this.ie = j;
            this.pred = p;
            this.weight = w;
            this.agregateWeight = aw;
            this.pretendTxt = txt;
        }

        public Sym(SymType _t, ArrayList<Sym> Q, int i, int j, int _ruleNum, int w) {
            this.t = _t;
            this.ib = Q.get((int)i).ib;
            this.ie = Q.get((int)(j - 1)).ie;
            this.ruleNum = _ruleNum;
            this.child = new Sym[j - i];
            int k = i;
            while (k < j) {
                this.child[k - i] = Q.get(k);
                ++k;
            }
            this.weight = this.agregateWeight = w;
            this.pred = null;
            this.pretendTxt = null;
        }

        String getActualTxt(String src) {
            return src.substring(this.ib, this.ie);
        }

        String getAssumedTxt(String src) {
            if (this.t == SymType.NAME && this.pretendTxt != src.substring(this.ib, this.ie) && this.pretendTxt != "") {
                return this.pretendTxt;
            }
            if (this.t == SymType.NUM || this.t == SymType.NAME) {
                return src.substring(this.ib, this.ie);
            }
            return this.t.txt;
        }
    }

    static enum SymType {
        NODE("Node", 1),
        STAR("*", 1),
        ARROW("->", 1),
        DOT(".", 1),
        LINK("link", 1),
        NULL("null", 1),
        NEW("new", 1),
        ASN("=", 1),
        DELETE("delete", 1),
        DATA("data", 1),
        NUM("", 1),
        NAME("", 1),
        DEL("", 1),
        DECL("", 0, "variable declaration"),
        PEXP("", 2, "pointer expression"),
        PLVAL("", 2, "pointer expression"),
        PASN("", 0, "pointer assignment statement"),
        DLTSTMT("", 0, "delete statement"),
        DEXP("", 2, "data expression"),
        DASN("", 0, "data assignment statement"),
        DNAME("", 2, "previously declared variable name"),
        UNAME("", 2, "new variable name"),
        NOTPLVAL("", -1),
        NOTPEXP("", -1),
        NOTDEXP("", -1),
        NOTNODEFIELD("", -1);

        private int term;
        private String txt;
        private String description = null;

        private SymType(String s, int t) {
            this.txt = s;
            this.term = t;
        }

        private SymType(String s, int t, String desc) {
            this.txt = s;
            this.term = t;
            this.description = desc;
        }

        private boolean match(SymType t) {
            if (this.term != -1) {
                return this == t;
            }
            if (this == NOTPLVAL) {
                return t != PLVAL;
            }
            if (this == NOTPEXP) {
                return t != PEXP;
            }
            if (this == NOTDEXP) {
                return t != DEXP;
            }
            if (this == NOTNODEFIELD) {
                return t != DATA && t != LINK;
            }
            return false;
        }
    }

    public class Tokish {
        public SymType t;
        public String txt;
        public int weight;

        public Tokish(SymType _t, String _txt, int _weight) {
            this.t = _t;
            this.txt = _txt;
            this.weight = _weight;
        }
    }
}

