/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.loggerplugin;

import edu.uic.cs.nlp.chiqat.framework.messages.User;
import edu.uic.cs.nlp.chiqat.plugin.loggerplugin.LogEntry;
import edu.uic.cs.nlp.chiqat.plugin.loggerplugin.PluginInstance;
import edu.uic.cs.nlp.chiqat.server.api.ChiQatServerCom;
import edu.uic.cs.nlp.chiqat.server.api.ILogCommitListener;
import edu.uic.cs.nlp.chiqat.server.api.structs.AddLogEntriesRequest;
import edu.uic.cs.nlp.toolbox.MiscFuncs;
import edu.uic.cs.nlp.toolbox.XmlConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Log
extends XmlConfig
implements ILogCommitListener {
    public List<LogEntry> CFG_Entries = new ArrayList<LogEntry>();
    protected Lock m_Lock = new ReentrantLock();
    protected static Log s_Singleton = null;
    protected User m_User = null;
    protected int m_iLogEntriesSubmitted = 0;

    public boolean Init() {
        return true;
    }

    public boolean Destroy() {
        this.Save();
        return true;
    }

    public static Log Global() {
        if (s_Singleton == null) {
            s_Singleton = new Log();
            s_Singleton.Init();
        }
        return s_Singleton;
    }

    public boolean SetFileOutput(String directory) {
        boolean bSuccess = false;
        if (!MiscFuncs.IsPathDirectory(directory)) {
            MiscFuncs.CreateDirectory(directory);
        }
        if (MiscFuncs.IsPathDirectory(directory)) {
            this.Load(String.valueOf(directory) + "/CurrentLog.log");
            this.SetFileName(String.valueOf(directory) + "/CurrentLog.log");
        }
        this.Save();
        return bSuccess;
    }

    public void Post(LogEntry.EntryLevel level, String msgType, String arg1, boolean bDebug) {
        this.Post(level, msgType, bDebug, arg1, "", "");
    }

    public void Post(LogEntry.EntryLevel level, String msgType, boolean bDebug, String arg1, String arg2, String arg3) {
        String sessionId = "";
        String userId = "";
        if (this.m_User != null) {
            userId = this.m_User.getId();
            sessionId = this.m_User.getSession();
        }
        LogEntry entry = new LogEntry(MiscFuncs.GetLocalTimeMs(), level, bDebug, msgType, sessionId, ++this.m_iLogEntriesSubmitted, userId, arg1, arg2, arg3);
        this.PrintToView(entry);
        if (this.m_User != null && this.m_User.IsDataCollectionAllowed()) {
            this.m_Lock.lock();
            this.CFG_Entries.add(entry);
            this.SaveCacheLog();
            this.m_Lock.unlock();
        }
    }

    public void PostInfo(String msgType, String msg) {
        this.Post(LogEntry.EntryLevel.El_Info, msgType, msg, false);
    }

    public void PostWarning(String msgType, String msg) {
        this.Post(LogEntry.EntryLevel.El_Warning, msgType, msg, false);
    }

    public void PostError(String msgType, String msg) {
        this.Post(LogEntry.EntryLevel.El_Error, msgType, msg, false);
    }

    public void PostDebugInfo(String msgType, String msg) {
        this.Post(LogEntry.EntryLevel.El_Info, msgType, msg, true);
    }

    public void PostDebugWarning(String msgType, String msg) {
        this.Post(LogEntry.EntryLevel.El_Warning, msgType, msg, true);
    }

    public void PostDebugError(String msgType, String msg) {
        this.Post(LogEntry.EntryLevel.El_Error, msgType, msg, true);
    }

    protected void SaveCacheLog() {
        this.Save();
        if ((this.CFG_Entries.size() & 0x40) == 64) {
            this.CommitToServer();
        }
    }

    public boolean CommitToServer() {
        return this.CommitToServer(null, true);
    }

    public boolean CommitToServer(ChiQatServerCom com, boolean bArchiveLog) {
        String newFileName;
        boolean bSuccess;
        int iClientTime = MiscFuncs.GetLocalTimeSec();
        AddLogEntriesRequest req = new AddLogEntriesRequest();
        req.client_send_time = iClientTime;
        for (LogEntry entry : this.CFG_Entries) {
            AddLogEntriesRequest.LogEntry e = new AddLogEntriesRequest.LogEntry();
            e.client_time = entry.CFG_TimeStamp;
            e.debug = entry.CFG_Debug;
            e.arg1 = MiscFuncs.EncodeEntityString(entry.CFG_Arg1);
            e.arg2 = MiscFuncs.EncodeEntityString(entry.CFG_Arg2);
            e.arg3 = MiscFuncs.EncodeEntityString(entry.CFG_Arg3);
            e.entry_num = entry.CFG_EntryNum;
            e.session_id = entry.CFG_SessionId;
            e.user_id = entry.CFG_UserId;
            e.level = entry.CFG_Level;
            e.msg_type = MiscFuncs.EncodeEntityString(entry.CFG_MsgType);
            e.client_version = entry.CFG_ClientVersion;
            req.entries.add(e);
        }
        if (com == null) {
            com = PluginInstance.m_ChiQatServer;
        }
        if ((bSuccess = com.AddLogEntries(req, this, bArchiveLog, newFileName = this.GetFileName().replace(".log", "-" + req.client_send_time + ".log"))) && bArchiveLog) {
            MiscFuncs.RenameFile(this.GetFileName(), newFileName);
            this.CFG_Entries.clear();
            this.Save();
        }
        return bSuccess;
    }

    protected void PrintToView(LogEntry entry) {
        String str = entry.ToDisplayString();
        System.out.println(str);
    }

    public void SetUser(User user) {
        this.m_User = user;
    }

    @Override
    public void OnLogCommitResult(AddLogEntriesRequest req, boolean bSuccess, boolean bArchiveLog, String fileName) {
        if (bSuccess && bArchiveLog) {
            MiscFuncs.RenameFile(fileName, fileName.replace("Current", "Previous"));
        }
    }
}

