/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.loggerplugin;

import edu.uic.cs.nlp.chiqat.server.api.ChiQatServerCom;
import edu.uic.cs.nlp.toolbox.XmlConfig;
import java.text.SimpleDateFormat;

public class LogEntry
extends XmlConfig {
    public long CFG_TimeStamp = 0L;
    public String CFG_Level = "Info";
    public boolean CFG_Debug = false;
    public String CFG_MsgType = "";
    public String CFG_Arg1 = "";
    public String CFG_Arg2 = "";
    public String CFG_Arg3 = "";
    public int CFG_ClientVersion = 0;
    public String CFG_SessionId = "";
    public String CFG_UserId = "";
    public int CFG_EntryNum = 0;

    public LogEntry() {
        this(0L, EntryLevel.El_Info, false, "", "", 0, "", "");
    }

    public LogEntry(long lTimeStamp, EntryLevel level, boolean bDebug, String msgType, String sessionId, int iEntryNum, String userId, String arg1) {
        this(lTimeStamp, level, bDebug, msgType, sessionId, iEntryNum, userId, arg1, "", "");
    }

    public LogEntry(long lTimeStamp, EntryLevel level, boolean bDebug, String msgType, String sessionId, int iEntryNum, String userId, String arg1, String arg2, String arg3) {
        this.CFG_MsgType = msgType;
        this.CFG_TimeStamp = lTimeStamp;
        this.CFG_Level = LogEntry.GetLevelStr(level);
        this.CFG_Debug = bDebug;
        this.CFG_Arg1 = arg1;
        this.CFG_Arg2 = arg2;
        this.CFG_Arg3 = arg3;
        this.CFG_ClientVersion = ChiQatServerCom.ClientVersionNum;
        this.CFG_SessionId = sessionId;
        this.CFG_EntryNum = iEntryNum;
        this.CFG_UserId = userId;
    }

    public static String GetLevelStr(EntryLevel t) {
        switch (t) {
            case El_Info: {
                return "Info";
            }
            case El_Warning: {
                return "Warn";
            }
            case El_Error: {
                return "Err ";
            }
        }
        return "Unknown";
    }

    public String ToDataString() {
        String argStr = this.CFG_Arg1;
        if (this.CFG_Arg2.length() > 0) {
            argStr = String.valueOf(argStr.length() > 0 ? "|" : "") + this.CFG_Arg2;
        }
        if (this.CFG_Arg3.length() > 0) {
            argStr = String.valueOf(argStr.length() > 0 ? "|" : "") + this.CFG_Arg3;
        }
        return String.valueOf(this.CFG_TimeStamp) + "\t" + this.CFG_Level + "\t" + this.CFG_MsgType + ":" + argStr + "\t" + (this.CFG_Debug ? "Debug" : "");
    }

    public String ToDisplayString() {
        String argStr = this.CFG_Arg1;
        if (this.CFG_Arg2.length() > 0) {
            argStr = String.valueOf(argStr) + (argStr.length() > 0 ? "|" : "") + this.CFG_Arg2;
        }
        if (this.CFG_Arg3.length() > 0) {
            argStr = String.valueOf(argStr) + (argStr.length() > 0 ? "|" : "") + this.CFG_Arg3;
        }
        SimpleDateFormat df = new SimpleDateFormat("yy:MM:dd-HH:mm:ss");
        String s = df.format(this.CFG_TimeStamp);
        return "[" + this.CFG_Level + "]  " + s + ": " + this.CFG_MsgType + ":" + argStr + (this.CFG_Debug ? "   [Debug]" : "");
    }

    public static enum EntryLevel {
        El_Info,
        El_Warning,
        El_Error;

    }
}

