/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.loggerplugin;

import edu.uic.cs.nlp.chiqat.plugin.loggerplugin.Log;
import edu.uic.cs.nlp.chiqat.server.api.ChiQatServerCom;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class LogUploadTool {
    private static ChiQatServerCom s_ServerComs = null;

    public static void main(String[] args) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Enter directory to upload: ");
            String srcDir = br.readLine();
            int iValidCollections = LogUploadTool.ValidateSrcDir(srcDir);
            if (iValidCollections > 0) {
                System.out.print("There are " + iValidCollections + " valid collections. Import (Y/N)? ");
                String answer = br.readLine();
                if (answer.compareToIgnoreCase("Y") == 0) {
                    s_ServerComs = new ChiQatServerCom();
                    if (s_ServerComs.Init() == ChiQatServerCom.InitResult.S_OK) {
                        System.out.print("Importing...");
                        int iNumFilesImported = LogUploadTool.ImportLogFiles(srcDir);
                        System.out.println("\nImported " + iNumFilesImported + " files");
                    } else {
                        System.out.println("Can't contact server, bye bye");
                    }
                } else {
                    System.out.println("Bye bye");
                }
            } else {
                System.out.println("No valid directories. Bye bye");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int ImportLogFiles(String srcDir) {
        File[] files;
        int iNumFilesImported = 0;
        File rootDir = new File(srcDir);
        File[] fileArray = files = rootDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File ld = fileArray[n2];
            try {
                String userIdStr;
                int iUserId;
                String dirName;
                if (ld.isDirectory() && (dirName = ld.getName()).startsWith("userlog-") && dirName.length() > "userlog-".length() && (iUserId = Integer.parseInt(userIdStr = ld.getName().substring("userlog-".length()))) > 0) {
                    File[] logFiles;
                    File[] fileArray2 = logFiles = ld.listFiles();
                    int n3 = logFiles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File lf = fileArray2[n4];
                        if (lf.isFile() && (lf.getName().startsWith("CurrentLog") || lf.getName().startsWith("PreviousLog")) && (lf.getName().endsWith(".log.sent") || lf.getName().endsWith(".log")) && LogUploadTool.SendFileToServer(lf.getPath(), iUserId)) {
                            lf.renameTo(new File(String.valueOf(lf.getPath()) + ".sent"));
                            ++iNumFilesImported;
                        }
                        ++n4;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return iNumFilesImported;
    }

    private static boolean SendFileToServer(String filePath, int iUserId) {
        boolean bSuccess = false;
        Log log = new Log();
        if (log.Load(filePath)) {
            bSuccess = log.CommitToServer(s_ServerComs, false);
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bSuccess;
    }

    private static int ValidateSrcDir(String srcDir) {
        File rootDir = new File(srcDir);
        File[] files = rootDir.listFiles();
        int iNumLogCols = 0;
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File ld = fileArray[n2];
                if (ld.isDirectory() && ld.getName().startsWith("userlog-")) {
                    ++iNumLogCols;
                }
                ++n2;
            }
        }
        return iNumLogCols;
    }
}

