/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.loggerplugin;

import edu.uic.cs.nlp.chiqat.framework.AppDataStore;
import edu.uic.cs.nlp.chiqat.framework.BluePrintNode;
import edu.uic.cs.nlp.chiqat.framework.DelayedMessageReceiver;
import edu.uic.cs.nlp.chiqat.framework.KeyValuePair;
import edu.uic.cs.nlp.chiqat.framework.LocalPluginConnector;
import edu.uic.cs.nlp.chiqat.framework.Message;
import edu.uic.cs.nlp.chiqat.framework.PluginConnector;
import edu.uic.cs.nlp.chiqat.framework.messages.LogMsg;
import edu.uic.cs.nlp.chiqat.framework.messages.ShowViewMsg;
import edu.uic.cs.nlp.chiqat.framework.messages.UserLoginMessage;
import edu.uic.cs.nlp.chiqat.plugin.base.BasePluginInstance;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginMenuItemDefinition;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginViewDefinition;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginViewFx;
import edu.uic.cs.nlp.chiqat.plugin.loggerplugin.Log;
import edu.uic.cs.nlp.chiqat.plugin.loggerplugin.LogBrowserController;
import edu.uic.cs.nlp.chiqat.plugin.loggerplugin.LogBrowserView;
import edu.uic.cs.nlp.chiqat.plugin.loggerplugin.LogEntry;
import edu.uic.cs.nlp.chiqat.server.api.ChiQatServerCom;
import java.io.Serializable;
import java.util.List;

public class PluginInstance
extends BasePluginInstance
implements Serializable {
    public static ChiQatServerCom m_ChiQatServer = null;
    private static final long serialVersionUID = 1L;
    private LogBrowserController m_Controller = null;
    private Log m_Log = null;
    private String m_DataDir = "";

    static {
        m_ChiQatServer = new ChiQatServerCom();
        ChiQatServerCom.InitResult initResult = m_ChiQatServer.Init();
    }

    @Override
    public boolean Init(PluginConnector connector, List<KeyValuePair> args, BluePrintNode node, AppDataStore appDataStore) {
        super.Init(connector, args, node, appDataStore, new DelayedMessageReceiver((LocalPluginConnector)connector, this));
        this.m_DataDir = this.m_AppDataStore.GetValue("DataDir");
        this.m_Log = new Log();
        this.m_Log.Init();
        this.m_Log.SetFileOutput(String.valueOf(this.m_DataDir) + "/LogDir");
        this.m_Controller = new LogBrowserController(this, "LogBrowserController");
        this.RegisterController(this.m_Controller);
        PluginViewDefinition view = new PluginViewDefinition(this);
        view.m_ViewType = LogBrowserView.class;
        view.m_ViewTypeId = "LogBrowserView";
        view.m_Title = "Log Browser";
        view.m_iHostHint = 32;
        this.m_ViewDefs.add(view);
        PluginMenuItemDefinition menuItem = new PluginMenuItemDefinition();
        menuItem.m_Text = "File|View Log";
        ShowViewMsg msg = new ShowViewMsg();
        msg.m_DestPlugin = "host";
        msg.m_MessageId = "ShowView";
        msg.m_ViewTypeId = "LogBrowserView";
        msg.m_ViewId = "SingleLogBrowser";
        msg.m_PluginInstanceId = this.GetInstanceId();
        msg.m_bPopup = true;
        menuItem.m_Message = msg;
        menuItem.m_bAdminOnly = true;
        this.m_MenuItemDefs.add(menuItem);
        this.m_Receiver.start();
        return true;
    }

    @Override
    public boolean Destroy() {
        super.Destroy();
        this.m_Log.CommitToServer();
        this.m_Log.Destroy();
        if (this.m_Receiver != null) {
            this.m_Receiver.Shutdown();
        }
        return true;
    }

    @Override
    public void OnMessage(Message msg) {
        super.OnMessage(msg);
        switch (msg.m_MessageId) {
            case "UserLoggedIn": {
                UserLoginMessage userMsg = (UserLoginMessage)msg;
                this.m_Log.SetUser(userMsg.m_User);
                break;
            }
            case "Log": {
                LogMsg logMsg = (LogMsg)msg;
                LogEntry.EntryLevel level = LogEntry.EntryLevel.El_Info;
                switch (logMsg.m_Level) {
                    case Lel_Warning: {
                        level = LogEntry.EntryLevel.El_Warning;
                        break;
                    }
                    case Lel_Error: {
                        level = LogEntry.EntryLevel.El_Error;
                        break;
                    }
                }
                this.m_Log.Post(level, logMsg.m_MsgType, logMsg.m_bDebug, logMsg.m_Arg1, logMsg.m_Arg2, logMsg.m_Arg3);
            }
        }
    }

    @Override
    protected void OnCreatingView(PluginViewFx view, PluginViewDefinition def) {
        if (view instanceof LogBrowserView) {
            LogBrowserView v = (LogBrowserView)view;
            v.SetController(this.m_Controller);
            this.m_Controller.RegisterView(v);
        }
    }

    @Override
    protected void OnViewCreated(PluginViewFx view) {
        super.OnViewCreated(view);
    }
}

