/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.recursionplugin.problems;

import edu.uic.cs.nlp.chiqat.plugin.recursionplugin.problems.rgQuestion;
import edu.uic.cs.nlp.chiqat.plugin.recursionplugin.recursiongraph.rgGraphInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class rgProblem {
    Document doc;
    private Number problemIndex;

    public void setProblemIndex(Number problemIndex) {
        this.problemIndex = problemIndex;
    }

    public Number getProblemIndex() {
        return this.problemIndex;
    }

    public rgProblem(Number problemIndex) {
        this.problemIndex = problemIndex;
        InputStream xml = ClassLoader.class.getResourceAsStream("/resources/rgProblems.xml");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        try {
            this.doc = db.parse(xml);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.doc.getDocumentElement().normalize();
    }

    public String getProblem() {
        String problemDescription = " hello";
        NodeList nl = this.doc.getElementsByTagName("problem");
        int temp = 0;
        while (temp < nl.getLength()) {
            Element eElement;
            Node nNode = nl.item(temp);
            if (nNode.getNodeType() == 1 && Integer.parseInt((eElement = (Element)nNode).getAttribute("id")) == this.problemIndex.intValue()) {
                problemDescription = eElement.getElementsByTagName("description").item(0).getTextContent();
            }
            ++temp;
        }
        return problemDescription;
    }

    public String getSolution() {
        String problemSolution = "Hello";
        NodeList nl = this.doc.getElementsByTagName("problem");
        int temp = 0;
        while (temp < nl.getLength()) {
            Element eElement;
            Node nNode = nl.item(temp);
            if (nNode.getNodeType() == 1 && Integer.parseInt((eElement = (Element)nNode).getAttribute("id")) == this.problemIndex.intValue()) {
                problemSolution = eElement.getElementsByTagName("solution").item(0).getTextContent();
            }
            ++temp;
        }
        return problemSolution;
    }

    public List<rgQuestion> getQuestions() {
        ArrayList<rgQuestion> questions = new ArrayList<rgQuestion>();
        NodeList nl = this.doc.getElementsByTagName("problem");
        int temp = 0;
        while (temp < nl.getLength()) {
            Element eElement;
            Node nNode = nl.item(temp);
            if (nNode.getNodeType() == 1 && Integer.parseInt((eElement = (Element)nNode).getAttribute("id")) == this.problemIndex.intValue()) {
                NodeList qnl = eElement.getElementsByTagName("Question");
                int i = 0;
                while (i < qnl.getLength()) {
                    Node qnNode = qnl.item(i);
                    Element qeElement = (Element)qnNode;
                    rgQuestion question = new rgQuestion();
                    question.setText(qnNode.getFirstChild().getTextContent().toString());
                    NodeList optionsNl = qeElement.getElementsByTagName("OP");
                    int j = 0;
                    while (j < optionsNl.getLength()) {
                        question.addOption(optionsNl.item(j).getTextContent());
                        ++j;
                    }
                    String answer = ((Element)qnl.item(i)).getAttribute("Answer");
                    question.setAnswer(answer);
                    questions.add(question);
                    ++i;
                }
            }
            ++temp;
        }
        return questions;
    }

    public rgGraphInfo getGraphInfo(Number graphIndex) {
        rgGraphInfo graphInfo = new rgGraphInfo();
        NodeList nl = this.doc.getElementsByTagName("problem");
        int temp = 0;
        while (temp < nl.getLength()) {
            Element eElement;
            Node nNode = nl.item(temp);
            if (nNode.getNodeType() == 1 && Integer.parseInt((eElement = (Element)nNode).getAttribute("id")) == this.problemIndex.intValue()) {
                NodeList graphnl = eElement.getElementsByTagName("Graph");
                int gtemp = 0;
                while (gtemp < graphnl.getLength()) {
                    Element gElement;
                    Node gNode = graphnl.item(gtemp);
                    if (gNode.getNodeType() == 1 && Integer.parseInt((gElement = (Element)gNode).getAttribute("id")) == graphIndex.intValue()) {
                        NodeList vnl = gElement.getElementsByTagName("Vertex");
                        NodeList enl = gElement.getElementsByTagName("Edge");
                        int i = 0;
                        while (i < vnl.getLength()) {
                            rgGraphInfo.rgVertex tempVertex = new rgGraphInfo.rgVertex(graphInfo);
                            tempVertex.setShape(((Element)vnl.item(i)).getAttribute("Shape"));
                            tempVertex.setName(((Element)vnl.item(i)).getAttribute("Name"));
                            tempVertex.setLayoutX(Double.parseDouble(((Element)vnl.item(i)).getAttribute("LayoutX")));
                            tempVertex.setLayoutY(Double.parseDouble(((Element)vnl.item(i)).getAttribute("LayoutY")));
                            tempVertex.setId(((Element)vnl.item(i)).getAttribute("id"));
                            tempVertex.setCodeAnimationIndecies(((Element)vnl.item(i)).getAttribute("AnimationIndices"));
                            graphInfo.getVertices().add(tempVertex);
                            ++i;
                        }
                        i = 0;
                        while (i < enl.getLength()) {
                            rgGraphInfo.rgEdge tempEdge = new rgGraphInfo.rgEdge(graphInfo);
                            tempEdge.setSource(((Element)enl.item(i)).getAttribute("SourceId"));
                            tempEdge.setTarget(((Element)enl.item(i)).getAttribute("TargetId"));
                            graphInfo.getEdges().add(tempEdge);
                            ++i;
                        }
                    }
                    ++gtemp;
                }
            }
            ++temp;
        }
        return graphInfo;
    }

    public rgGraphInfo getPartialGraphInfo(rgGraphInfo graphInfo) {
        int size = graphInfo.getVertices().size();
        int vertciesCount = (int)((double)size * 0.3);
        int previousNumber = -999;
        int i = 0;
        HashSet<Integer> set = new HashSet<Integer>();
        while (i < vertciesCount) {
            int randomIndex = 1 + (int)(Math.random() * (double)(size - 1 - 1 + 1));
            if (randomIndex == previousNumber || set.contains(randomIndex)) continue;
            set.add(randomIndex);
            graphInfo.getVertices().get(randomIndex).setName("");
            ++i;
            previousNumber = randomIndex;
        }
        return graphInfo;
    }

    public rgGraphInfo getFlawedGraphInfo(rgGraphInfo graphInfo) {
        int size = graphInfo.getVertices().size();
        int vertciesCount = (int)((double)size * 0.3);
        int previousNumber = -999;
        int i = 0;
        HashSet<Integer> set = new HashSet<Integer>();
        while (i < vertciesCount) {
            int randomIndex = 1 + (int)(Math.random() * (double)(size - 1 - 1 + 1));
            if (randomIndex == previousNumber || set.contains(randomIndex)) continue;
            set.add(randomIndex);
            ++i;
            previousNumber = randomIndex;
        }
        Iterator Ite = set.iterator();
        while (Ite.hasNext()) {
            int first = (Integer)Ite.next();
            if (!Ite.hasNext()) continue;
            int second = (Integer)Ite.next();
            String name1 = graphInfo.getVertices().get(first).getName();
            String name2 = graphInfo.getVertices().get(second).getName();
            graphInfo.getVertices().get(first).setName(name2);
            graphInfo.getVertices().get(second).setName(name1);
        }
        return graphInfo;
    }
}

