/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.recursionplugin.problems;

import edu.uic.cs.nlp.chiqat.plugin.recursionplugin.problems.rgQuestion;
import java.util.List;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;

public class rgQuestionsReport1 {
    private TableView<Row> table = new TableView();
    private final ObservableList<Row> data = FXCollections.observableArrayList();

    public rgQuestionsReport1(List<rgQuestion> Questions, TextFlow problemView) {
        Label label = new Label("Score Report");
        label.setFont(new Font("Arial", 20.0));
        this.table.setEditable(true);
        int countCorrect = 0;
        boolean flag = false;
        if (!Questions.isEmpty() && Questions != null) {
            System.out.println("Questions size: " + Questions.size());
            int i = 0;
            while (i < Questions.size()) {
                rgQuestion tempRgQuestion = Questions.get(i);
                if (tempRgQuestion.getUserAnswer().equalsIgnoreCase(tempRgQuestion.getAnswer())) {
                    ++countCorrect;
                    flag = true;
                } else {
                    flag = false;
                }
                Row tempRow = new Row(flag, i + 1, tempRgQuestion.getQuestionString(), tempRgQuestion.getUserAnswer(), tempRgQuestion.getAnswer());
                this.data.add((Object)tempRow);
                ++i;
            }
        }
        Label label1 = new Label("You have answered " + countCorrect + " out of " + Questions.size() + " correctly !!");
        label1.setFont(new Font("Arial", 12.0));
        TableColumn IdCol = new TableColumn("No");
        IdCol.setCellValueFactory((Callback)new PropertyValueFactory("Id"));
        IdCol.setSortable(false);
        IdCol.setMinWidth(50.0);
        IdCol.setMaxWidth(50.0);
        TableColumn questionCol = new TableColumn("Question");
        questionCol.setMinWidth(100.0);
        questionCol.setSortable(false);
        questionCol.setCellValueFactory((Callback)new QuestionFactory());
        questionCol.setCellFactory((Callback)new Callback<TableColumn<Row, Object>, TableCell<Row, Object>>(){

            public TableCell<Row, Object> call(TableColumn<Row, Object> column) {
                return new ImageCell();
            }
        });
        TableColumn userAnswerCol = new TableColumn("User Answer");
        userAnswerCol.setMinWidth(100.0);
        userAnswerCol.setSortable(false);
        userAnswerCol.setCellValueFactory((Callback)new UserAnswerFactory());
        userAnswerCol.setCellFactory((Callback)new Callback<TableColumn<Row, Object>, TableCell<Row, Object>>(){

            public TableCell<Row, Object> call(TableColumn<Row, Object> column) {
                return new ImageCell();
            }
        });
        TableColumn CorrectAnswerCol = new TableColumn("Correct Answer");
        CorrectAnswerCol.setMinWidth(100.0);
        CorrectAnswerCol.setSortable(false);
        CorrectAnswerCol.setCellValueFactory((Callback)new CorrectAnswerFactory());
        CorrectAnswerCol.setCellFactory((Callback)new Callback<TableColumn<Row, Object>, TableCell<Row, Object>>(){

            public TableCell<Row, Object> call(TableColumn<Row, Object> column) {
                return new ImageCell();
            }
        });
        TableColumn imgCol = new TableColumn("");
        imgCol.setMinWidth(50.0);
        imgCol.setMaxWidth(50.0);
        imgCol.setSortable(false);
        imgCol.setCellValueFactory((Callback)new ImageFactory());
        imgCol.setCellFactory((Callback)new Callback<TableColumn<Row, Object>, TableCell<Row, Object>>(){

            public TableCell<Row, Object> call(TableColumn<Row, Object> column) {
                return new ImageCell();
            }
        });
        this.table.setItems(this.data);
        this.table.getColumns().addAll((Object[])new TableColumn[]{imgCol, IdCol, questionCol, userAnswerCol, CorrectAnswerCol});
        this.table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.table.setStyle("-fx-background-insets: 0 0 -1 0, 0, 1.5; -fx-background-radius: 6, 5, 4; -fx-padding: 6 10 4 10; -fx-effect: innershadow( gaussian, rgba(0, 0, 0, 0.8), 5, 0, 0, 2 );");
        VBox vbox = new VBox();
        vbox.getChildren().addAll((Object[])new Node[]{label, label1, this.table});
        vbox.setPadding(new Insets(10.0));
        vbox.setSpacing(20.0);
        vbox.setStyle("-fx-background-color: rgba(255, 255, 255, 0.3), linear-gradient(rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.8) 50%), rgb(218, 226, 224)");
        Scene scene = new Scene((Parent)vbox);
        this.table.prefWidthProperty().bind((ObservableValue)scene.widthProperty());
        this.table.prefHeightProperty().bind((ObservableValue)scene.heightProperty());
        Stage stage = new Stage();
        stage.setTitle("Score Report");
        stage.setWidth(800.0);
        stage.setHeight(300.0);
        stage.setMaxHeight(500.0);
        stage.setMaxWidth(1024.0);
        stage.initModality(Modality.WINDOW_MODAL);
        stage.initOwner((Window)((Stage)problemView.getScene().getWindow()));
        stage.setScene(scene);
        stage.show();
    }

    class CorrectAnswerFactory
    implements Callback<TableColumn.CellDataFeatures<Row, Object>, ObservableValue<Object>> {
        CorrectAnswerFactory() {
        }

        public ObservableValue<Object> call(TableColumn.CellDataFeatures<Row, Object> data) {
            String value = ((Row)data.getValue()).CorrectAnswer.getValue();
            return value instanceof ObservableValue ? (ObservableValue)value : new ReadOnlyObjectWrapper((Object)value);
        }
    }

    private class ImageCell
    extends TableCell<Row, Object> {
        final ImageView iv = new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/resources/correct.png")));
        final ImageView iv1 = new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/resources/incorrect.png")));

        private ImageCell() {
        }

        protected void updateItem(Object item, boolean empty) {
            super.updateItem(item, empty);
            if (item != null && item instanceof Boolean) {
                if (((Boolean)item).booleanValue()) {
                    this.iv.setFitHeight(20.0);
                    this.iv.setFitWidth(20.0);
                    this.setGraphic((Node)this.iv);
                } else {
                    this.iv1.setFitHeight(20.0);
                    this.iv1.setFitWidth(20.0);
                    this.setGraphic((Node)this.iv1);
                }
            } else if (item != null && item instanceof String) {
                Text text = new Text((String)item);
                text.setTextAlignment(TextAlignment.LEFT);
                text.prefWidth(250.0);
                text.setWrappingWidth(250.0);
                this.setGraphic((Node)text);
            }
            this.setAlignment(Pos.CENTER_LEFT);
        }
    }

    class ImageFactory
    implements Callback<TableColumn.CellDataFeatures<Row, Object>, ObservableValue<Object>> {
        ImageFactory() {
        }

        public ObservableValue<Object> call(TableColumn.CellDataFeatures<Row, Object> data) {
            Boolean value = ((Row)data.getValue()).right.getValue();
            return value instanceof ObservableValue ? (ObservableValue)value : new ReadOnlyObjectWrapper((Object)value);
        }
    }

    class QuestionFactory
    implements Callback<TableColumn.CellDataFeatures<Row, Object>, ObservableValue<Object>> {
        QuestionFactory() {
        }

        public ObservableValue<Object> call(TableColumn.CellDataFeatures<Row, Object> data) {
            String value = ((Row)data.getValue()).question.getValue();
            return value instanceof ObservableValue ? (ObservableValue)value : new ReadOnlyObjectWrapper((Object)value);
        }
    }

    public static class Row {
        private final SimpleBooleanProperty right;
        private final SimpleIntegerProperty Id;
        private final SimpleStringProperty question;
        private final SimpleStringProperty userAnswer;
        private final SimpleStringProperty CorrectAnswer;

        private Row(boolean right, int Id, String question, String userAnswer, String CorrectAnswer) {
            this.right = new SimpleBooleanProperty(right);
            this.Id = new SimpleIntegerProperty(Id);
            this.question = new SimpleStringProperty(question);
            this.userAnswer = new SimpleStringProperty(userAnswer);
            this.CorrectAnswer = new SimpleStringProperty(CorrectAnswer);
        }

        public int getId() {
            return this.Id.get();
        }

        public String getQuestion() {
            return this.question.get();
        }

        public String getUserAnswer() {
            return this.userAnswer.get();
        }

        public String getCorrectAnswer() {
            return this.CorrectAnswer.get();
        }

        public SimpleBooleanProperty getRight() {
            return this.right;
        }
    }

    class UserAnswerFactory
    implements Callback<TableColumn.CellDataFeatures<Row, Object>, ObservableValue<Object>> {
        UserAnswerFactory() {
        }

        public ObservableValue<Object> call(TableColumn.CellDataFeatures<Row, Object> data) {
            String value = ((Row)data.getValue()).userAnswer.getValue();
            return value instanceof ObservableValue ? (ObservableValue)value : new ReadOnlyObjectWrapper((Object)value);
        }
    }
}

