/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.recursionplugin.recursiongraph;

import edu.uic.cs.nlp.chiqat.plugin.recursionplugin.recursiongraph.Arrow;
import edu.uic.cs.nlp.chiqat.plugin.recursionplugin.recursiongraph.rgNode;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;

class rgConnection
extends Group {
    public rgConnection(final rgNode source, final rgNode target) {
        final DoubleProperty startX = source.CenterXProperty();
        final DoubleProperty startY = source.CenterYProperty();
        final DoubleProperty endX = target.CenterXProperty();
        final DoubleProperty endY = target.CenterYProperty();
        DoubleBinding targetBoundryX = new DoubleBinding(){
            {
                super.bind(new Observable[]{doubleProperty, doubleProperty2, doubleProperty3, doubleProperty4});
            }

            protected double computeValue() {
                Point2D a = new Point2D(startX.get(), startY.get());
                Point2D b = new Point2D(endX.get(), endY.get());
                Point2D result = rgConnection.this.findBoundaryPoint(a, b, target);
                return result.getX();
            }
        };
        DoubleBinding targetBoundryY = new DoubleBinding(){
            {
                super.bind(new Observable[]{doubleProperty, doubleProperty2, doubleProperty3, doubleProperty4});
            }

            protected double computeValue() {
                Point2D a = new Point2D(startX.get(), startY.get());
                Point2D b = new Point2D(endX.get(), endY.get());
                Point2D result = rgConnection.this.findBoundaryPoint(a, b, target);
                return result.getY();
            }
        };
        DoubleBinding sourceBoundryX = new DoubleBinding(){
            {
                super.bind(new Observable[]{doubleProperty, doubleProperty2, doubleProperty3, doubleProperty4});
            }

            protected double computeValue() {
                Point2D a = new Point2D(startX.get(), startY.get());
                Point2D b = new Point2D(endX.get(), endY.get());
                Point2D result = rgConnection.this.findBoundaryPoint(b, a, source);
                return result.getX();
            }
        };
        DoubleBinding sourceBoundryY = new DoubleBinding(){
            {
                super.bind(new Observable[]{doubleProperty, doubleProperty2, doubleProperty3, doubleProperty4});
            }

            protected double computeValue() {
                Point2D a = new Point2D(startX.get(), startY.get());
                Point2D b = new Point2D(endX.get(), endY.get());
                Point2D result = rgConnection.this.findBoundaryPoint(b, a, source);
                return result.getY();
            }
        };
        Line line = new Line();
        line.setFill((Paint)Color.GREY.deriveColor(1.0, 1.0, 1.0, 0.5));
        line.setStrokeWidth(1.0);
        line.setStroke((Paint)Color.GREY);
        Arrow arrow = new Arrow(line);
        line.endXProperty().bind((ObservableValue)targetBoundryX);
        line.endYProperty().bind((ObservableValue)targetBoundryY);
        line.startXProperty().bind((ObservableValue)sourceBoundryX);
        line.startYProperty().bind((ObservableValue)sourceBoundryY);
        Label connectionLabel = new Label();
        connectionLabel.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.LIGHT, (double)12.0));
        connectionLabel.setStyle("-fx-text-fill: #006464;");
        connectionLabel.layoutXProperty().bind((ObservableValue)line.startXProperty().add((ObservableNumberValue)line.endXProperty()).divide(2).subtract(10));
        connectionLabel.layoutYProperty().bind((ObservableValue)line.startYProperty().add((ObservableNumberValue)line.endYProperty()).divide(2).subtract(10));
        if (source.getNodeShape().equals("Ellipse") && target.getNodeShape().equals("Ellipse")) {
            connectionLabel.setText("F");
            connectionLabel.setTooltip(new Tooltip("Function Call"));
        } else if (source.getNodeShape().equals("Ellipse") && target.getNodeShape().equals("Box")) {
            connectionLabel.setText("IR");
            connectionLabel.setTooltip(new Tooltip("Intermediate Result"));
        } else if (source.getNodeShape().equals("Box") && target.getNodeShape().equals("Ellipse")) {
            connectionLabel.setText("R");
            connectionLabel.setTooltip(new Tooltip("Return Result"));
        }
        this.getChildren().addAll((Object[])new Node[]{line, arrow, connectionLabel});
    }

    public Point2D findBoundaryPoint(Point2D a, Point2D b, rgNode target) {
        Double x = (a.getX() + b.getX()) / 2.0;
        Double y = (a.getY() + b.getY()) / 2.0;
        Point2D m = new Point2D(x.doubleValue(), y.doubleValue());
        if (a.distance(b) < 1.0) {
            return m;
        }
        Point2D n = new Point2D(m.getX() - target.layoutXProperty().get(), m.getY() - target.layoutYProperty().get());
        if (target.contains(n)) {
            return this.findBoundaryPoint(a, m, target);
        }
        return this.findBoundaryPoint(m, b, target);
    }
}

