/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.recursionplugin.recursiongraph;

import edu.uic.cs.nlp.chiqat.framework.messages.LogMsg;
import edu.uic.cs.nlp.chiqat.lessontoolbox.LessonController;
import java.util.ArrayList;
import javafx.animation.FadeTransition;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Ellipse;
import javafx.util.Duration;

public class rgNode
extends TextField {
    double boxWidth = 130.0;
    double boxHeight = 60.0;
    double ellipseWidth = 200.0;
    double ellipseHeight = 80.0;
    private String nameId;
    private DoubleProperty centerX;
    private DoubleProperty centerY;
    String shape;
    private ArrayList<Integer> codeAnimationIndecies = new ArrayList();
    FadeTransition fadeTransition;
    LessonController m_Controller = null;

    public rgNode(LessonController m_Controller) {
        this.setText("       ");
        this.m_Controller = m_Controller;
    }

    public rgNode getRGNode() {
        return this;
    }

    public void setController(LessonController m_Controller) {
        this.m_Controller = m_Controller;
    }

    public DoubleProperty CenterXProperty() {
        if (this.centerX == null) {
            this.centerX = new SimpleDoubleProperty();
            DoubleBinding centerX = this.layoutXProperty().add((ObservableNumberValue)this.widthProperty().divide(2));
            this.centerX.bind((ObservableValue)centerX);
        }
        return this.centerX;
    }

    public DoubleProperty CenterYProperty() {
        if (this.centerY == null) {
            this.centerY = new SimpleDoubleProperty();
            DoubleBinding centerY = this.layoutYProperty().add((ObservableNumberValue)this.heightProperty().divide(2));
            this.centerY.bind((ObservableValue)centerY);
        }
        return this.centerY;
    }

    public FadeTransition fadeTransitionProperty() {
        return this.fadeTransition;
    }

    public rgNode(String id, String shape, String name, double layoutX, double layoutY, final LessonController m_Controller) {
        this.setNameId(id);
        this.setText(name);
        this.setAlignment(Pos.CENTER);
        if (shape.equals("Box")) {
            this.setStyle("-fx-text-fill: #006464; -fx-border-color: Grey;-fx-border-width: 2; -fx-background-color: aliceblue; -fx-border-radius: 5;");
            this.setPrefSize(this.boxWidth, this.boxHeight);
            this.setLayoutX(layoutX);
            this.setLayoutY(layoutY);
            this.shape = shape;
        } else if (shape.equals("Ellipse")) {
            Ellipse ellipse = new Ellipse();
            this.setStyle("-fx-text-fill: #006464; -fx-border-color: Grey;-fx-border-width: 1;-fx-background-color: lightblue; ");
            ellipse.setCenterX(this.ellipseWidth / 2.0);
            ellipse.setCenterY(this.ellipseHeight / 2.0);
            ellipse.setRadiusX(80.0);
            ellipse.setRadiusY(30.0);
            this.setClip((Node)ellipse);
            this.setPrefSize(this.ellipseWidth, this.ellipseHeight);
            this.setLayoutX(layoutX);
            this.setLayoutY(layoutY);
            this.shape = shape;
        }
        this.fadeTransition = new FadeTransition(Duration.millis((double)1000.0));
        this.fadeTransition.setFromValue(1.0);
        this.fadeTransition.setToValue(0.1);
        this.fadeTransition.setCycleCount(2);
        this.fadeTransition.setAutoReverse(true);
        this.fadeTransition.setNode((Node)this);
        final Delta dragDelta = new Delta();
        this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                dragDelta.x = rgNode.this.getLayoutX() - mouseEvent.getSceneX();
                dragDelta.y = rgNode.this.getLayoutY() - mouseEvent.getSceneY();
                rgNode.this.setCursor(Cursor.MOVE);
                mouseEvent.consume();
            }
        });
        this.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                rgNode.this.setCursor(Cursor.HAND);
            }
        });
        this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.isPrimaryButtonDown()) {
                    rgNode.this.setLayoutX(mouseEvent.getSceneX() + dragDelta.x);
                    rgNode.this.setLayoutY(mouseEvent.getSceneY() + dragDelta.y);
                }
            }
        });
        this.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                rgNode.this.setCursor(Cursor.HAND);
            }
        });
        this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
                    if (mouseEvent.getClickCount() == 1) {
                        rgNode.this.setEditable(false);
                    } else if (mouseEvent.getClickCount() == 2) {
                        rgNode.this.setEditable(true);
                    }
                }
            }
        });
        this.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                m_Controller.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Node old Text: " + oldValue, false);
                m_Controller.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Node New Text: " + newValue, false);
            }
        });
    }

    public String getNameId() {
        return this.nameId;
    }

    public void setNameId(String nameId) {
        this.nameId = nameId;
    }

    public String getNodeShape() {
        return this.shape;
    }

    public ArrayList<Integer> getCodeAnimationIndecies() {
        return this.codeAnimationIndecies;
    }

    public void setCodeAnimationIndecies(String AnimationIndecies) {
        if (AnimationIndecies != "") {
            String[] temp = AnimationIndecies.split("\\s");
            int i = 0;
            while (i < temp.length) {
                this.codeAnimationIndecies.add(i, Integer.valueOf(temp[i]));
                ++i;
            }
        }
    }

    class Delta {
        double x;
        double y;

        Delta() {
        }
    }
}

