/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.recursionplugin.utilities;

import java.util.ArrayList;
import java.util.List;

public class rgLexer {
    private List<Token> tokens;

    public rgLexer(String string) {
        this.tokens = this.lex(string);
    }

    public rgLexer() {
    }

    public String getAtom(String s, int i) {
        int j;
        for (j = i; j < s.length(); ++j) {
            if (Character.isLetterOrDigit(s.charAt(j)) || s.charAt(j) == '$' || s.charAt(j) == '_') {
                continue;
            }
            return s.substring(i, j);
        }
        return s.substring(i, j);
    }

    public List<Token> lex(String input) {
        ArrayList<Token> result = new ArrayList<Token>();
        int i = 0;
        while (i < input.length()) {
            switch (input.charAt(i)) {
                case '(': {
                    result.add(new Token(Type.LPAREN, "("));
                    ++i;
                    break;
                }
                case ')': {
                    result.add(new Token(Type.RPAREN, ")"));
                    ++i;
                    break;
                }
                case ';': {
                    result.add(new Token(Type.SEMICOLON, ";"));
                    ++i;
                    break;
                }
                case '=': {
                    result.add(new Token(Type.EQAUL, "="));
                    ++i;
                    break;
                }
                case '*': {
                    result.add(new Token(Type.MULTIPLY, "*"));
                    ++i;
                    break;
                }
                case '+': {
                    result.add(new Token(Type.PLUS, "+"));
                    ++i;
                    break;
                }
                case '-': {
                    result.add(new Token(Type.MINUS, "-"));
                    ++i;
                    break;
                }
                case '/': {
                    result.add(new Token(Type.DIVISON, "/"));
                    ++i;
                    break;
                }
                case '!': {
                    result.add(new Token(Type.NOT, "!"));
                    ++i;
                    break;
                }
                case '&': {
                    result.add(new Token(Type.AMPERSAND, "&"));
                    ++i;
                    break;
                }
                case '|': {
                    result.add(new Token(Type.OR, "|"));
                    ++i;
                    break;
                }
                case '^': {
                    result.add(new Token(Type.POWER, "^"));
                    ++i;
                    break;
                }
                case '<': {
                    result.add(new Token(Type.LESSTHAN, "<"));
                    ++i;
                    break;
                }
                case '>': {
                    result.add(new Token(Type.GREATERTHAN, ">"));
                    ++i;
                    break;
                }
                default: {
                    if (Character.isWhitespace(input.charAt(i))) {
                        ++i;
                        break;
                    }
                    if (input.charAt(i) == '$' || input.charAt(i) == '_' || Character.isLetterOrDigit(input.charAt(i))) {
                        String atom = this.getAtom(input, i);
                        i += atom.length();
                        result.add(new Token(Type.ATOM, atom));
                        break;
                    }
                    result.add(new Token(Type.OTHER, Character.toString(input.charAt(i))));
                    ++i;
                }
            }
        }
        return result;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public boolean isEqual(rgLexer l) {
        if (this.tokens.size() != l.tokens.size()) {
            return false;
        }
        int i = 0;
        while (i < this.tokens.size()) {
            if (!this.tokens.get((int)i).c.equalsIgnoreCase(l.tokens.get((int)i).c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void main(String[] args) {
        rgLexer l1 = new rgLexer(" _this $is +   a test (5); \"");
        rgLexer l2 = new rgLexer(" _this $is + a #test (5); \"");
        System.out.println(" _this $is a #test (4);\"");
        for (Token t : l1.tokens) {
            System.out.println((Object)((Object)t.t) + " " + t.c);
        }
        System.out.println(l1.isEqual(l2));
    }

    public static class Token {
        public final Type t;
        public final String c;

        public Token(Type t, String c) {
            this.t = t;
            this.c = c;
        }

        public String toString() {
            if (this.t == Type.ATOM) {
                return "ATOM<" + this.c + ">";
            }
            return this.t.toString();
        }
    }

    public static enum Type {
        LPAREN,
        RPAREN,
        ATOM,
        SEMICOLON,
        MINUS,
        PLUS,
        MULTIPLY,
        DIVISON,
        EQAUL,
        NOT,
        AMPERSAND,
        LESSTHAN,
        GREATERTHAN,
        POWER,
        OR,
        OTHER;

    }
}

