/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.recursionplugin.utilities;

import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public class rgSolutionListView {
    private static final int WRAPPING_WIDTH = 350;
    private static final int PREF_TEXT_DISPLAY_WIDTH = 300;
    private ListView<String> textDisplay = new ListView();
    private StringProperty searchText = new SimpleStringProperty();

    public rgSolutionListView(String solution) {
        this.textDisplay = new ListView(this.createLinesFromString(solution, 350));
        this.textDisplay.addEventFilter(MouseEvent.ANY, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }
        });
        this.textDisplay.setCellFactory((Callback)new Callback<ListView<String>, ListCell<String>>(){

            public ListCell<String> call(ListView<String> param) {
                return new ListCell<String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(null);
                        if (!empty) {
                            this.setText(item);
                            if (item.length() > 100) {
                                this.setPrefWidth(350.0);
                                this.setWrapText(true);
                            }
                        }
                    }
                };
            }
        });
    }

    public void updateText(String solution) {
        this.textDisplay.setItems(this.createLinesFromString(solution, 350));
    }

    ObservableList<String> createLinesFromString(String string, int wrappingWidth) {
        Object[] parts = string.split("\\n");
        if (wrappingWidth <= 0) {
            return FXCollections.observableArrayList((Object[])parts);
        }
        ObservableList lines = FXCollections.observableArrayList();
        Object[] objectArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            Object part = objectArray[n2];
            if (((String)part).length() == 0) {
                lines.add(part);
            } else {
                int offset = 0;
                String nextLine = this.getNextLine((String)part, offset, wrappingWidth);
                while (nextLine.length() > 0) {
                    lines.add((Object)nextLine);
                    nextLine = this.getNextLine((String)part, offset += nextLine.length(), wrappingWidth);
                }
            }
            ++n2;
        }
        return lines;
    }

    String getNextLine(String part, int offset, int wrappingWidth) {
        if (part.length() - offset <= wrappingWidth) {
            return part.substring(offset);
        }
        int idx = wrappingWidth;
        while (idx >= 0) {
            if (part.charAt(offset + idx) == ' ') {
                return part.substring(offset, offset + idx + 1);
            }
            --idx;
        }
        return part.substring(offset, Math.min(part.length(), offset + wrappingWidth));
    }

    public StringProperty getSearchText() {
        return this.searchText;
    }

    public ListView<String> getTextDisplay() {
        this.textDisplay.setEditable(true);
        this.forceUpdate();
        return this.textDisplay;
    }

    public void forceUpdate() {
        this.textDisplay.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue ov, Number value, Number new_value) {
                ObservableList items = rgSolutionListView.this.textDisplay.getItems();
                rgSolutionListView.this.textDisplay.setItems(null);
                rgSolutionListView.this.textDisplay.setItems(items);
            }
        });
    }
}

