/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.woeplugin;

import edu.uic.cs.nlp.chiqat.framework.AppDataStore;
import edu.uic.cs.nlp.chiqat.framework.BluePrintNode;
import edu.uic.cs.nlp.chiqat.framework.DefaultMessageReceiver;
import edu.uic.cs.nlp.chiqat.framework.IMessageReceiver;
import edu.uic.cs.nlp.chiqat.framework.KeyValuePair;
import edu.uic.cs.nlp.chiqat.framework.LocalPluginConnector;
import edu.uic.cs.nlp.chiqat.framework.Message;
import edu.uic.cs.nlp.chiqat.framework.PluginConnector;
import edu.uic.cs.nlp.chiqat.framework.messages.PlayWoeMsg;
import edu.uic.cs.nlp.chiqat.framework.messages.StopWoeMsg;
import edu.uic.cs.nlp.chiqat.framework.messages.StudentResponseMsg;
import edu.uic.cs.nlp.chiqat.plugin.base.BasePluginInstance;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginViewDefinition;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.editor.EditorView;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.WoeEngine;
import java.util.ArrayList;
import java.util.List;

public class PluginInstance
extends BasePluginInstance
implements IMessageReceiver {
    private List<WoeEngine> m_Engines = new ArrayList<WoeEngine>();

    @Override
    public boolean Init(PluginConnector connector, List<KeyValuePair> args, BluePrintNode node, AppDataStore appDataStore) {
        super.Init(connector, args, node, appDataStore, new DefaultMessageReceiver((LocalPluginConnector)connector, this));
        PluginViewDefinition view = new PluginViewDefinition(this);
        view.m_ViewType = EditorView.class;
        view.m_Title = "WOE Editor";
        view.m_iHostHint = 32;
        this.m_ViewDefs.add(view);
        this.m_Receiver.start();
        return true;
    }

    @Override
    public boolean Destroy() {
        super.Destroy();
        if (this.m_Receiver != null) {
            this.m_Receiver.Shutdown();
            this.DestroyAllEngines();
        }
        return true;
    }

    @Override
    public void OnMessage(Message msg) {
        super.OnMessage(msg);
        switch (msg.m_MessageId) {
            case "PlayWoe": {
                PlayWoeMsg playMsg = (PlayWoeMsg)msg;
                WoeEngine engine = this.GetWoeEngine(playMsg.m_PlaybackInstanceId, playMsg.m_PlaybackControllerId);
                if (engine == null) break;
                engine.LoadWoe(playMsg.m_FilePath);
                engine.Play();
                break;
            }
            case "StudentResponse": {
                StudentResponseMsg responseMsg = (StudentResponseMsg)msg;
                WoeEngine engine = this.GetWoeEngine(responseMsg.m_PlaybackInstanceId, responseMsg.m_PlaybackControllerId);
                int iResponse = 0;
                try {
                    iResponse = Integer.parseInt(msg.m_StringData);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                engine.OnStudentResponse(iResponse);
                break;
            }
            case "StopWoe": {
                StopWoeMsg stopMsg = (StopWoeMsg)msg;
                WoeEngine engine = this.GetWoeEngine(stopMsg.m_PlaybackInstanceId, stopMsg.m_PlaybackControllerId);
                if (engine == null) break;
                engine.Stop();
            }
        }
    }

    public WoeEngine GetWoeEngine(String pluginId, String controllerId) {
        int i = 0;
        while (i < this.m_Engines.size()) {
            WoeEngine engine = this.m_Engines.get(i);
            if (engine.GetPlaybackPluginId().compareToIgnoreCase(pluginId) == 0 && engine.GetPlaybackControllerId().compareToIgnoreCase(controllerId) == 0) {
                return engine;
            }
            ++i;
        }
        WoeEngine engine = new WoeEngine(pluginId, controllerId, this);
        this.m_Engines.add(engine);
        return engine;
    }

    protected void DestroyAllEngines() {
        for (WoeEngine e : this.m_Engines) {
            e.Stop();
        }
        this.m_Engines.clear();
    }
}

