/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.woeplugin.editor;

import edu.uic.cs.nlp.chiqat.framework.messages.PlayWoeMsg;
import edu.uic.cs.nlp.chiqat.plugin.base.PluginViewFx;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.PluginInstance;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.editor.FlowGraphPane;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.editor.PropertiesPane;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.WoeEngine;
import java.io.File;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;

public class EditorView
extends PluginViewFx
implements EventHandler<ActionEvent> {
    protected BorderPane m_RootPane = null;
    protected FlowGraphPane m_FlowGraphPane = null;
    protected PropertiesPane m_PropertiesPane = null;
    protected MenuBar m_MenuBar = null;
    protected WoeEngine m_Engine = null;

    @Override
    public boolean Init() {
        this.m_Engine = ((PluginInstance)this.m_Owner).GetWoeEngine("HelpPlugin", "UiOverviewView");
        this.m_RootPane = new BorderPane();
        this.m_MenuBar = new MenuBar();
        this.m_RootPane.setTop((Node)this.m_MenuBar);
        Menu mainMenu = new Menu("File");
        Menu toolsMenu = new Menu("Tools");
        this.AddMenuItem(mainMenu, "New", "NewWoeItem");
        this.AddMenuItem(mainMenu, "Open...", "OpenWoeItem");
        this.AddMenuItem(mainMenu, "Save", "SaveWoeItem");
        this.AddMenuItem(mainMenu, "Save As...", "SaveAsWoeItem");
        this.AddMenuItem(mainMenu, "Close", "CloseItem");
        this.m_MenuBar.getMenus().add((Object)mainMenu);
        this.AddMenuItem(toolsMenu, "Play WOE", "PlayItem");
        this.m_MenuBar.getMenus().add((Object)toolsMenu);
        this.m_PropertiesPane = new PropertiesPane();
        this.m_RootPane.setRight((Node)this.m_PropertiesPane);
        this.m_PropertiesPane.setStyle("-fx-background-color: #A9BCF5;");
        this.m_PropertiesPane.setStyle("-fx-border-radius: 10 10 0 0;");
        this.m_PropertiesPane.setStyle("-fx-background-radius: 10 10 0 0;");
        this.m_PropertiesPane.setPrefWidth(300.0);
        this.m_PropertiesPane.SetEngine(this.m_Engine);
        this.m_FlowGraphPane = new FlowGraphPane(this.m_Owner.m_AppDataStore.GetValue("DataDir"));
        this.m_FlowGraphPane.SetEngine(this.m_Engine);
        this.m_RootPane.setCenter((Node)this.m_FlowGraphPane);
        this.m_FlowGraphPane.setStyle("-fx-background-color: #900082;");
        this.m_FlowGraphPane.SetSelectorListener(this.m_PropertiesPane);
        this.m_PropertiesPane.SetPropertyListener(this.m_FlowGraphPane);
        EditorView.setTopAnchor((Node)this.m_RootPane, (Double)0.0);
        EditorView.setBottomAnchor((Node)this.m_RootPane, (Double)0.0);
        EditorView.setLeftAnchor((Node)this.m_RootPane, (Double)0.0);
        EditorView.setRightAnchor((Node)this.m_RootPane, (Double)0.0);
        this.getChildren().add((Object)this.m_RootPane);
        this.m_RootPane.setPrefSize(800.0, 600.0);
        return true;
    }

    private void AddMenuItem(Menu mainMenu, String text, String idStr) {
        MenuItem menuItem = new MenuItem(text);
        mainMenu.getItems().add((Object)menuItem);
        menuItem.setId(idStr);
        menuItem.onActionProperty().set((Object)this);
    }

    public void handle(ActionEvent evt) {
        String id = ((MenuItem)evt.getSource()).getId();
        if (id.compareTo("OpenWoeItem") == 0) {
            File selectedFile;
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Open WOE File");
            fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Worked Out Example File", new String[]{"*.woe"}), new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"})});
            String defaultDirStr = "/C:/git/chiqat/Projects/ChiQat-PC/Bin/Resources";
            File defaultDirectory = new File(defaultDirStr);
            if (defaultDirectory.isDirectory()) {
                fileChooser.setInitialDirectory(defaultDirectory);
            }
            if ((selectedFile = fileChooser.showOpenDialog(this.getScene().getWindow())) != null) {
                String s = selectedFile.getPath();
                this.m_Engine.LoadWoe(s);
                this.m_FlowGraphPane.RefreshGraph();
            }
        } else if (id.compareTo("SaveAsWoeItem") == 0) {
            File selectedFile;
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Save WOE File");
            fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Worked Out Example File", new String[]{"*.woe"}), new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"})});
            String defaultDirStr = "/C:/git/chiqat/Projects/ChiQat-PC/Bin/Resources";
            File defaultDirectory = new File(defaultDirStr);
            if (defaultDirectory.isDirectory()) {
                fileChooser.setInitialDirectory(defaultDirectory);
            }
            if ((selectedFile = fileChooser.showSaveDialog(this.getScene().getWindow())) != null) {
                String s = selectedFile.getPath();
                this.m_Engine.SaveWoe(s);
            }
        } else if (id.compareTo("SaveWoeItem") == 0) {
            this.m_Engine.SaveWoe();
        } else if (id.compareTo("CloseWoeItem") == 0) {
            this.Close();
        } else if (id.compareTo("NewWoeItem") == 0) {
            this.m_Engine.CreateNewWoe();
            this.m_FlowGraphPane.RefreshGraph();
        } else if (id.compareTo("PlayItem") == 0) {
            PlayWoeMsg msg = new PlayWoeMsg();
            msg.m_FilePath = this.m_Engine.GetDefinition().GetFileName();
            msg.m_MessageId = "PlayWoe";
            this.m_Owner.PostMessage(msg);
        }
    }
}

