/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.woeplugin.editor;

import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.definition.ActionDefinition;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.definition.WoeDefinition;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.definition.WoeStepDefinition;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class StepPropertiesDlg
extends Stage {
    protected BorderPane m_Root = null;
    protected Scene m_Scene = null;
    protected GridPane m_PropertyGrid = null;
    protected Button m_OkBtn = null;
    protected WoeStepDefinition m_StepDefinition = null;
    protected WoeDefinition m_WoeDefinition = null;
    protected HashMap<String, Node> m_ValueCtrls = null;

    public StepPropertiesDlg() {
        this.setTitle("Properties");
        this.m_Root = new BorderPane();
        this.m_Scene = new Scene((Parent)this.m_Root, 800.0, 600.0, (Paint)Color.WHITE);
        this.setScene(this.m_Scene);
        this.m_ValueCtrls = new HashMap();
        this.m_PropertyGrid = new GridPane();
        this.m_Root.setCenter((Node)this.m_PropertyGrid);
        ColumnConstraints col1 = new ColumnConstraints();
        col1.setPercentWidth(50.0);
        ColumnConstraints col2 = new ColumnConstraints();
        col2.setPercentWidth(50.0);
        this.m_PropertyGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2});
        this.m_OkBtn = new Button("OK");
        this.m_Root.setBottom((Node)this.m_OkBtn);
        this.m_OkBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent evt) {
                StepPropertiesDlg.this.UpdateProperties();
                StepPropertiesDlg.this.close();
            }
        });
    }

    protected void UpdateProperties() {
        if (this.m_StepDefinition != null) {
            this.m_StepDefinition.CFG_Name = this.GetTextField("Name");
        } else if (this.m_WoeDefinition != null) {
            this.m_WoeDefinition.CFG_Name = this.GetTextField("Name");
            this.m_WoeDefinition.CFG_RootStep = this.GetIntField("Start Step ID");
        }
    }

    private String GetTextField(String refName) {
        return ((TextField)this.m_ValueCtrls.get(refName)).getText();
    }

    private int GetIntField(String refName) {
        return Integer.parseInt(((TextField)this.m_ValueCtrls.get(refName)).getText());
    }

    public void SetProperties(WoeStepDefinition wsd) {
        this.m_WoeDefinition = null;
        this.m_StepDefinition = wsd;
        this.ClearFields();
        this.m_ValueCtrls.clear();
        this.AddTextField("Name", wsd.CFG_Name);
        int i = 0;
        while (i < wsd.CFG_Actions.size()) {
            ActionDefinition actionDef = wsd.CFG_Actions.get(i);
            this.AddTextField("Action Type " + (i + 1), actionDef.CFG_ActionType.toString());
            this.AddTextField("Name" + (i + 1), actionDef.CFG_DataStr);
            ++i;
        }
    }

    public void SetProperties(WoeDefinition woe) {
        this.m_WoeDefinition = woe;
        this.m_StepDefinition = null;
        this.ClearFields();
        this.m_ValueCtrls.clear();
        this.AddTextField("Name", woe.CFG_Name);
        this.AddTextField("Start Step ID", woe.CFG_RootStep);
    }

    private void ClearFields() {
        this.m_PropertyGrid.getChildren().clear();
    }

    private void AddTextField(String key, int iVal) {
        Text keyCtrl = new Text(key);
        TextField valCtrl = new TextField(String.valueOf(iVal));
        this.m_PropertyGrid.addRow(0, new Node[]{keyCtrl, valCtrl});
        this.m_ValueCtrls.put(key, (Node)valCtrl);
    }

    private void AddTextField(String key, String val) {
        Text keyCtrl = new Text(key);
        TextField valCtrl = new TextField(val);
        this.m_PropertyGrid.addRow(0, new Node[]{keyCtrl, valCtrl});
        this.m_ValueCtrls.put(key, (Node)valCtrl);
    }
}

