/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.woeplugin.editor;

import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.definition.ActionDefinition;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.definition.WoeDefinition;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.definition.WoeStepDefinition;
import java.util.HashMap;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;

public class StepPropertiesPane
extends BorderPane {
    protected GridPane m_PropertyGrid = null;
    protected Button m_OkBtn = null;
    protected WoeStepDefinition m_StepDefinition = null;
    protected WoeDefinition m_WoeDefinition = null;
    protected HashMap<String, Node> m_ValueCtrls = new HashMap();
    protected Button m_AddActionBtn = null;
    protected int m_iNumRows = 0;

    public StepPropertiesPane() {
        this.m_PropertyGrid = new GridPane();
        this.setCenter((Node)this.m_PropertyGrid);
        this.m_AddActionBtn = new Button("Add Action");
        this.m_AddActionBtn.setMaxWidth(Double.MAX_VALUE);
        this.m_AddActionBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent evt) {
                StepPropertiesPane.this.AddAction();
            }
        });
        this.setBottom((Node)this.m_AddActionBtn);
        ColumnConstraints col1 = new ColumnConstraints();
        col1.setPercentWidth(40.0);
        ColumnConstraints col2 = new ColumnConstraints();
        col2.setPercentWidth(60.0);
        this.m_PropertyGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2});
    }

    protected void AddAction() {
        ActionDefinition def = this.m_StepDefinition.CreateActionDefinition();
        this.m_StepDefinition.CFG_Actions.add(def);
        this.AddActionFields(def);
    }

    protected void CommitProperties() {
        if (this.m_StepDefinition != null) {
            this.m_StepDefinition.CFG_Name = this.GetTextField("Name");
            this.m_StepDefinition.CFG_Actions.clear();
            Set<String> valSet = this.m_ValueCtrls.keySet();
            for (String str : valSet) {
                ActionDefinition actionDef;
                int iId;
                if (str.contains("Action Type ")) {
                    iId = Integer.parseInt(str.substring("Action Type ".length(), str.length()));
                    actionDef = this.GetActionDef(iId);
                    if (actionDef == null) {
                        actionDef = new ActionDefinition();
                        actionDef.CFG_ActionId = iId;
                        this.m_StepDefinition.CFG_Actions.add(actionDef);
                    }
                    ComboBox cb = (ComboBox)this.m_ValueCtrls.get(str);
                    String typeStr = ((String)cb.getSelectionModel().getSelectedItem()).toString();
                    actionDef.CFG_ActionType = ActionDefinition.ActionType.valueOf(typeStr);
                    continue;
                }
                if (!str.contains("Data String ")) continue;
                iId = Integer.parseInt(str.substring("Data String ".length(), str.length()));
                actionDef = this.GetActionDef(iId);
                if (actionDef == null) {
                    actionDef = new ActionDefinition();
                    actionDef.CFG_ActionId = iId;
                    this.m_StepDefinition.CFG_Actions.add(actionDef);
                }
                TextField tf = (TextField)this.m_ValueCtrls.get(str);
                actionDef.CFG_DataStr = tf.getText();
            }
        } else if (this.m_WoeDefinition != null) {
            this.m_WoeDefinition.CFG_Name = this.GetTextField("Name");
            this.m_WoeDefinition.CFG_RootStep = this.GetIntField("Start Step ID");
        }
    }

    protected ActionDefinition GetActionDef(int iId) {
        int i = 0;
        while (i < this.m_StepDefinition.CFG_Actions.size()) {
            if (this.m_StepDefinition.CFG_Actions.get((int)i).CFG_ActionId == iId) {
                return this.m_StepDefinition.CFG_Actions.get(i);
            }
            ++i;
        }
        return null;
    }

    private String GetTextField(String refName) {
        return ((TextField)this.m_ValueCtrls.get(refName)).getText();
    }

    private int GetIntField(String refName) {
        return Integer.parseInt(((TextField)this.m_ValueCtrls.get(refName)).getText());
    }

    public void SetProperties(WoeStepDefinition wsd) {
        this.m_WoeDefinition = null;
        this.m_StepDefinition = wsd;
        this.ClearFields();
        this.m_ValueCtrls.clear();
        this.AddTextField("Name", wsd.CFG_Name);
        int i = 0;
        while (i < wsd.CFG_Actions.size()) {
            ActionDefinition actionDef = this.m_StepDefinition.CFG_Actions.get(i);
            this.AddActionFields(actionDef);
            ++i;
        }
    }

    protected void AddActionFields(ActionDefinition def) {
        this.AddActionTypeField(def.CFG_ActionId, def.CFG_ActionType.toString());
        this.AddTextField("Data String " + def.CFG_ActionId, def.CFG_DataStr);
        this.AddButtonField("Delete Action " + def.CFG_ActionId);
    }

    public void SetProperties(WoeDefinition woe) {
        this.m_WoeDefinition = woe;
        this.m_StepDefinition = null;
        this.ClearFields();
        this.m_ValueCtrls.clear();
        this.AddTextField("Name", woe.CFG_Name);
        this.AddTextField("Start Step ID", woe.CFG_RootStep);
    }

    private void ClearFields() {
        this.m_PropertyGrid.getChildren().clear();
    }

    private void AddTextField(String key, int iVal) {
        Text keyCtrl = new Text(key);
        TextField valCtrl = new TextField(String.valueOf(iVal));
        this.m_PropertyGrid.addRow(this.m_iNumRows++, new Node[]{keyCtrl, valCtrl});
        this.m_ValueCtrls.put(key, (Node)valCtrl);
    }

    private void AddTextField(String key, String val) {
        Text keyCtrl = new Text(key);
        TextField valCtrl = new TextField(val);
        this.m_PropertyGrid.addRow(this.m_iNumRows++, new Node[]{keyCtrl, valCtrl});
        this.m_ValueCtrls.put(key, (Node)valCtrl);
    }

    private void AddButtonField(String key) {
        Button keyCtrl = new Button(key);
        keyCtrl.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent evt) {
                StepPropertiesPane.this.OnButtonFieldAction((Button)evt.getTarget());
            }
        });
        this.m_PropertyGrid.addRow(this.m_iNumRows++, new Node[]{keyCtrl});
    }

    protected void OnButtonFieldAction(Button btn) {
        if (btn.getText().contains("Delete Action ")) {
            int iActionId = Integer.parseInt(btn.getText().substring("Delete Action ".length(), btn.getText().length()));
            this.DeleteAction(iActionId);
        }
    }

    private void AddActionTypeField(int iId, String typeStr) {
        Text keyCtrl = new Text("Action Type " + iId);
        ComboBox comboCtrl = new ComboBox();
        comboCtrl.getItems().addAll((Object[])new String[]{"PrintToConsole", "TutorMessage", "ExecuteCommand", "StartNodeHighlight", "StopNodeHighlight", "SetScratchText", "ClearScratch", "SetNumStateSpaces", "HighlightUiComponent", "SetBackgroundImage", "SetSecondaryBackgroundImage"});
        comboCtrl.getSelectionModel().select((Object)typeStr);
        this.m_PropertyGrid.addRow(this.m_iNumRows++, new Node[]{keyCtrl, comboCtrl});
        this.m_ValueCtrls.put("Action Type " + iId, (Node)comboCtrl);
    }

    protected void DeleteAction(int iActionId) {
    }
}

