/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.woeplugin.editor;

import edu.uic.cs.nlp.chiqat.plugin.woeplugin.editor.IGraphListener;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.editor.PropertiesPane;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.editor.WoeGraphNodeDef;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.WoeEngine;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.definition.WoeDefinition;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.definition.WoeStepDefinition;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.definition.WoeTransitionDefinition;
import edu.uic.cs.nlp.ui.graph.Connector;
import edu.uic.cs.nlp.ui.graph.FxGraphComponentInfo;
import edu.uic.cs.nlp.ui.graph.FxGraphCtrl;
import edu.uic.cs.nlp.ui.graph.FxGraphNode;
import edu.uic.cs.nlp.ui.graph.ImageCache;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class WoeGraphCtrl
extends FxGraphCtrl {
    protected ImageCache m_ImageCache = null;
    protected ContextMenu m_BackMenu = null;
    protected ContextMenu m_NodeMenu = null;
    protected int m_iContextSpawnX = 0;
    protected int m_iContextSpawnY = 0;
    protected WoeEngine m_WoeEngine = null;
    protected IGraphListener m_GraphListener = null;
    protected Node m_RightClickedItem = null;
    private EventHandler<ActionEvent> m_ContextHandler = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent e) {
            String idStr;
            switch (idStr = ((MenuItem)e.getTarget()).getId()) {
                case "addStepItem": {
                    WoeGraphNodeDef newNode = WoeGraphCtrl.this.CreateGraphNode(null);
                    newNode.m_iLeft = WoeGraphCtrl.this.m_iContextSpawnX - newNode.m_iWidth / 2;
                    newNode.m_iTop = WoeGraphCtrl.this.m_iContextSpawnY - newNode.m_iHeight / 2;
                    WoeGraphCtrl.this.AddGraphNode(newNode);
                    break;
                }
                case "deleteStepItem": {
                    FxGraphNode graphNode = WoeGraphCtrl.this.FindFxNode(WoeGraphCtrl.this.m_RightClickedItem);
                    if (graphNode == null) break;
                    WoeGraphCtrl.this.m_WoeEngine.RemoveStep(((WoeGraphNodeDef)graphNode.GetNodeDef()).m_WoeStep.CFG_Id);
                    break;
                }
                case "makeStartStepItem": {
                    FxGraphNode graphNode = WoeGraphCtrl.this.FindFxNode(WoeGraphCtrl.this.m_RightClickedItem);
                    if (graphNode == null) break;
                    WoeGraphCtrl.this.m_WoeEngine.GetDefinition().CFG_RootStep = ((WoeGraphNodeDef)graphNode.GetNodeDef()).m_WoeStep.CFG_Id;
                }
            }
        }
    };
    protected static int s_iNodeId = 0;
    protected FxGraphComponentInfo m_SelectedComponent = null;

    public WoeGraphCtrl() {
        super(257);
    }

    public boolean Init(String dataDir) {
        boolean bSuccess = true;
        this.m_ImageCache = new ImageCache();
        this.m_ImageCache.Init();
        this.SetConnectionImage(this.m_ImageCache.GetImage("file://" + dataDir + "/Resources/ConnectionArrow.png"));
        this.SetImages(this.m_ImageCache.GetImage("file://" + dataDir + "/Resources/WoeNode.png"), this.m_ImageCache.GetImage("file://" + dataDir + "/Resources/WoeNode_Selected.png"), this.m_ImageCache.GetImage("file://" + dataDir + "/Resources/Connector.png"), this.m_ImageCache.GetImage("file://" + dataDir + "/Resources/ConnectorSelected.png"), 0);
        this.setLayoutX(0.0);
        this.setLayoutY(0.0);
        this.SetGraphEventHandler(this);
        this.m_BackMenu = new ContextMenu();
        MenuItem addStepItem = new MenuItem();
        addStepItem.setText("Add Step");
        addStepItem.setId("addStepItem");
        addStepItem.setOnAction(this.m_ContextHandler);
        this.m_BackMenu.getItems().add((Object)addStepItem);
        this.m_NodeMenu = new ContextMenu();
        MenuItem deleteStepItem = new MenuItem();
        deleteStepItem.setText("Delete Step");
        deleteStepItem.setId("deleteStepItem");
        deleteStepItem.setOnAction(this.m_ContextHandler);
        MenuItem makeRootItem = new MenuItem();
        makeRootItem.setText("Make Start Node");
        makeRootItem.setId("makeStartStepItem");
        makeRootItem.setOnAction(this.m_ContextHandler);
        this.m_NodeMenu.getItems().add((Object)deleteStepItem);
        this.m_NodeMenu.getItems().add((Object)makeRootItem);
        return bSuccess;
    }

    public void SetWoeEngine(WoeEngine engine) {
        this.m_WoeEngine = engine;
        this.RefreshGraph();
    }

    public void OnBackgroundClicked(MouseEvent event) {
        super.OnBackgroundClicked(event);
        this.OnRightClick(event);
    }

    private void AddGraphNode(WoeStepDefinition wsd) {
        WoeGraphNodeDef nodeDef = this.CreateGraphNode(wsd);
        this.AddGraphNode(nodeDef);
    }

    private void OnRightClick(MouseEvent event) {
        this.m_BackMenu.hide();
        this.m_NodeMenu.hide();
        this.m_RightClickedItem = (Node)event.getTarget();
        if (event.getButton() == MouseButton.SECONDARY) {
            if (event.getTarget() == this) {
                this.m_BackMenu.show((Node)event.getSource(), event.getScreenX(), event.getScreenY());
                this.m_iContextSpawnX = (int)event.getSceneX();
                this.m_iContextSpawnY = (int)event.getSceneY();
            } else {
                this.m_NodeMenu.show((Node)event.getSource(), event.getScreenX(), event.getScreenY());
                this.m_iContextSpawnX = (int)event.getSceneX();
                this.m_iContextSpawnY = (int)event.getSceneY();
            }
        }
    }

    public WoeGraphNodeDef CreateGraphNode(WoeStepDefinition stepDef) {
        WoeGraphNodeDef node = new WoeGraphNodeDef();
        if (stepDef == null) {
            node.m_WoeStep = this.m_WoeEngine.AddStep();
            node.m_WoeStep.CFG_Name = "New Step";
            node.m_iLeft = 30;
            node.m_iTop = 30;
            node.m_iNodeId = node.m_WoeStep.CFG_Id;
        } else {
            node.m_WoeStep = stepDef;
            node.m_iNodeId = stepDef.CFG_Id;
            node.m_iLeft = stepDef.CFG_DisplayX;
            node.m_iTop = stepDef.CFG_DisplayY;
        }
        node.m_Text = node.m_WoeStep.CFG_Name;
        node.m_iHeight = 70;
        node.m_iWidth = 70;
        Connector con = null;
        con = new Connector();
        con.m_Position = Connector.Position_Centre;
        node.m_Connectors.add(con);
        return node;
    }

    protected FxGraphNode FindFxNode(Node childNode) {
        Node node = childNode;
        while (node != null && !this.IsFxNode(node)) {
            node = node.getParent();
        }
        return (FxGraphNode)node;
    }

    private boolean IsFxNode(Node node) {
        for (FxGraphNode n : this.m_Nodes) {
            if (node != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public void OnNodeClicked(Object sender, FxGraphComponentInfo info) {
        super.OnNodeClicked(sender, info);
        this.OnStepSelected(info);
    }

    @Override
    public void OnNodeConnectorClicked(Object sender, FxGraphComponentInfo info) {
        if (this.m_SelectedComponent != null && info.m_iConnectorId != -1 && info.m_iNodeId != -1 && this.m_SelectedComponent.m_iConnectorId != -1 && this.m_SelectedComponent.m_iNodeId != -1) {
            this.OnConnectionAttempted(this.m_SelectedComponent, info);
        }
        this.m_SelectedComponent = new FxGraphComponentInfo(info);
    }

    @Override
    public void OnBackgroundClicked(Object sender) {
        this.OnStepSelected(null);
    }

    private void OnStepSelected(FxGraphComponentInfo info) {
        if (this.m_GraphListener != null) {
            this.m_GraphListener.OnNodeSelected(info == null ? -1 : info.m_iNodeId);
        }
    }

    private void OnConnectionAttempted(FxGraphComponentInfo src, FxGraphComponentInfo dest) {
        System.out.println("Connection attempted - (" + src.m_iNodeId + ":" + src.m_iConnectorId + ") - (" + dest.m_iNodeId + ":" + dest.m_iConnectorId + ")");
        this.AddConnection(src, dest, false);
    }

    @Override
    public void AddConnection(FxGraphComponentInfo src, FxGraphComponentInfo dest, boolean bidirectional) {
        WoeTransitionDefinition wtd;
        super.AddConnection(src, dest, bidirectional);
        WoeStepDefinition wsd = this.m_WoeEngine.GetStep(src.m_iNodeId);
        if (wsd != null && (wtd = wsd.FindTransition(dest.m_iNodeId)) == null) {
            wsd.AddTransition(dest.m_iNodeId);
        }
    }

    public void RefreshGraph() {
        this.Clear();
        WoeDefinition woeDef = this.m_WoeEngine.GetDefinition();
        if (woeDef != null) {
            for (WoeStepDefinition wsd : woeDef.CFG_Steps) {
                this.AddGraphNode(wsd);
            }
            for (WoeStepDefinition wsd : woeDef.CFG_Steps) {
                for (WoeTransitionDefinition wtd : wsd.CFG_Transitions) {
                    this.AddTransitionLink(wsd.CFG_Id, wtd.CFG_DestId);
                }
            }
        }
    }

    private void AddTransitionLink(int iSrcId, int iDestId) {
        this.AddConnection(new FxGraphComponentInfo(iSrcId, 0), new FxGraphComponentInfo(iDestId, 0), false);
    }

    @Override
    public void OnNodeMoved(FxGraphNode node, double x, double y) {
        WoeGraphNodeDef woeNode = (WoeGraphNodeDef)node.GetNodeDef();
        woeNode.m_WoeStep.CFG_DisplayX = (int)x;
        woeNode.m_WoeStep.CFG_DisplayY = (int)y;
    }

    public void SetSelectorListener(PropertiesPane pane) {
        this.m_GraphListener = pane;
    }

    public void RefreshNode(int iNodeId) {
        WoeStepDefinition def = this.m_WoeEngine.GetStep(iNodeId);
        if (def != null) {
            FxGraphNode node = this.FindGraphNode(iNodeId);
            node.SetNodeName(def.CFG_Name);
        }
    }

    public FxGraphNode FindGraphNode(int iId) {
        for (FxGraphNode fx : this.m_Nodes) {
            if (((WoeGraphNodeDef)fx.GetNodeDef()).m_iNodeId != iId) continue;
            return fx;
        }
        return null;
    }
}

