/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine;

import edu.uic.cs.nlp.chiqat.framework.Message;
import edu.uic.cs.nlp.chiqat.framework.messages.LogMsg;
import edu.uic.cs.nlp.chiqat.plugin.base.BasePluginInstance;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.definition.ActionDefinition;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.definition.WoeDefinition;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.definition.WoeStepDefinition;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.definition.WoeTransitionDefinition;
import edu.uic.cs.nlp.toolbox.ManualResetEvent;
import edu.uic.cs.nlp.toolbox.ThreadObject;
import java.util.List;

public class EngineExecutor
extends ThreadObject {
    public int m_iCurrentStep = -1;
    protected WoeDefinition m_Definition = null;
    protected BasePluginInstance m_PluginInst = null;
    protected String m_PlaybackPluginId = "";
    protected String m_PlaybackControllerId = "";
    protected Integer m_iStimulus = null;
    protected ManualResetEvent m_StimulusUpdatedEvt = new ManualResetEvent(false);

    public EngineExecutor(WoeDefinition def, BasePluginInstance pluginInst, String playbackPluginId, String playbackViewId) {
        this(def, pluginInst);
        this.m_PlaybackPluginId = playbackPluginId;
        this.m_PlaybackControllerId = playbackViewId;
    }

    public EngineExecutor(WoeDefinition def, BasePluginInstance pluginInst) {
        this.m_Definition = def;
        this.m_PluginInst = pluginInst;
    }

    @Override
    protected void Run() {
        this.PlayThroughExample();
    }

    protected void PlayThroughExample() {
        this.m_iCurrentStep = this.m_Definition.CFG_RootStep;
        this.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Example Started", false, this.m_Definition.CFG_Name, this.m_Definition.GetFileName());
        while (this.m_iCurrentStep != -1) {
            this.m_iCurrentStep = this.ExecuteStep(this.m_iCurrentStep);
        }
        this.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Example Completed", false);
    }

    protected int ExecuteStep(int iStepId) {
        int iNextStep = -1;
        WoeStepDefinition stepDef = this.m_Definition.GetStep(iStepId);
        this.LogInfo(LogMsg.LogEntryLevel.Lel_Info, "Executing Example Step", false, "" + this.m_iCurrentStep);
        if (stepDef != null) {
            for (ActionDefinition actionDef : stepDef.CFG_Actions) {
                this.ExecuteAction(actionDef);
            }
            iNextStep = this.DecideTransition(stepDef.CFG_Transitions);
        }
        return iNextStep;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int DecideTransition(List<WoeTransitionDefinition> transitions) {
        int iNextStep = -1;
        try {
            if (transitions.size() > 0) {
                boolean bStimulusNeeded;
                boolean bl = bStimulusNeeded = transitions.size() > 1 || transitions.get((int)0).CFG_StimulusId != -1;
                if (bStimulusNeeded) {
                    if (!this.WaitOnEvent(this.m_StimulusUpdatedEvt)) {
                        return -1;
                    }
                    this.m_StimulusUpdatedEvt.reset();
                    int iPath = 0;
                    int i = 0;
                    while (i < transitions.size()) {
                        if (transitions.get((int)i).CFG_InputValue == this.m_iStimulus) {
                            iPath = i;
                            break;
                        }
                        ++i;
                    }
                    iNextStep = transitions.get((int)iPath).CFG_DestId;
                } else {
                    WoeTransitionDefinition def = transitions.get(0);
                    if (def != null && def.CFG_PauseDuration > 0) {
                        this.m_BeginShutdownEvt.waitOne(def.CFG_PauseDuration);
                    }
                    iNextStep = def.CFG_DestId;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iNextStep;
    }

    private void ExecuteAction(ActionDefinition actionDef) {
        Message msg = null;
        switch (actionDef.CFG_ActionType) {
            case PrintToConsole: {
                System.out.println("Action - " + actionDef.CFG_DataStr);
                break;
            }
            case TutorMessage: {
                msg = new Message("OnTutorMessage");
                msg.m_StringData = actionDef.CFG_DataStr;
                msg.m_StringData = this.ReplaceDynamicStringContent(msg.m_StringData);
                break;
            }
            case ExecuteCommand: {
                msg = new Message("ExecuteCommand");
                msg.m_StringData = actionDef.CFG_DataStr;
                break;
            }
            case StartNodeHighlight: {
                msg = new Message("StartNodeHighlight");
                msg.m_StringData = actionDef.CFG_DataStr;
                break;
            }
            case HighlightUiComponent: {
                msg = new Message("HighlightUiComponent");
                msg.m_StringData = actionDef.CFG_DataStr;
                break;
            }
            case StopNodeHighlight: {
                msg = new Message("StopNodeHighlight");
                msg.m_StringData = actionDef.CFG_DataStr;
                break;
            }
            case SetScratchText: {
                msg = new Message("SetScratchText");
                msg.m_StringData = actionDef.CFG_DataStr;
                break;
            }
            case ClearScratch: {
                msg = new Message("ClearScratch");
                msg.m_StringData = actionDef.CFG_DataStr;
                break;
            }
            case SetNumStateSpaces: {
                msg = new Message("SetNumStateSpaces");
                msg.m_StringData = actionDef.CFG_DataStr;
                break;
            }
            case SetBackgroundImage: {
                msg = new Message("SetBackgroundImage");
                msg.m_StringData = actionDef.CFG_DataStr;
                break;
            }
            case SetSecondaryBackgroundImage: {
                msg = new Message("SetSecondaryBackgroundImage");
                msg.m_StringData = actionDef.CFG_DataStr;
                break;
            }
        }
        if (msg != null) {
            msg.m_DestPlugin = this.m_PlaybackPluginId;
            msg.m_DestControllerId = this.m_PlaybackControllerId;
            this.m_PluginInst.PostMessage(msg);
        }
    }

    public void LogInfo(LogMsg.LogEntryLevel level, String msgType, boolean bDebug) {
        this.LogInfo(level, msgType, bDebug, "", "", "");
    }

    public void LogInfo(LogMsg.LogEntryLevel level, String msgType, boolean bDebug, String arg1) {
        this.LogInfo(level, msgType, bDebug, arg1, "", "");
    }

    public void LogInfo(LogMsg.LogEntryLevel level, String msgType, boolean bDebug, String arg1, String arg2) {
        this.LogInfo(level, msgType, bDebug, arg1, arg2, "");
    }

    public void LogInfo(LogMsg.LogEntryLevel level, String msgType, boolean bDebug, String arg1, String arg2, String arg3) {
        LogMsg msg = new LogMsg();
        msg.m_MessageId = "Log";
        msg.m_MsgType = msgType;
        msg.m_Level = level;
        msg.m_Arg1 = arg1;
        msg.m_Arg2 = arg2;
        msg.m_Arg3 = arg3;
        msg.m_bDebug = bDebug;
        this.m_PluginInst.PostMessage(msg);
    }

    protected WoeStepDefinition GetCurrentStep() {
        return this.m_Definition.GetStep(this.m_iCurrentStep);
    }

    public void SetStimulus(int iResponse) {
        this.m_iStimulus = iResponse;
        this.m_StimulusUpdatedEvt.set();
    }

    private String ReplaceDynamicStringContent(String str) {
        str = str.replace("<%USER_NAME%>", this.m_PluginInst.GetLoggedInUser().GetFirstName());
        return str;
    }
}

